/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation.positivedefinite;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GoldfeldQuandtTrotter
extends DenseMatrix {
    private static Matrix final(Matrix a2, double a3) {
        ArgumentAssertion.assertPositive(a3, "beta");
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(a2), "H must be a square matrix", new Object[0]);
        Object a4 = a2.ONE();
        if (a3 != Double.POSITIVE_INFINITY) {
            a4 = a2.add(a2.ONE().scaled(a3)).scaled(1.0 / (1.0 + a3));
        }
        return a4;
    }

    public GoldfeldQuandtTrotter(Matrix H2, double beta) {
        super(GoldfeldQuandtTrotter.final(H2, beta));
    }
}

