/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.SVD;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.misc.Constants;
import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PseudoInverse
extends DenseMatrix {
    public PseudoInverse(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2));
    }

    private static Matrix final(Matrix a2, double a3) {
        SVD a4 = new SVD(a2, true, a3, SVD.Method.GOLUB_KAHAN);
        DiagonalMatrix a5 = a4.D();
        double a6 = Math.min(PseudoInverse.final(a2, a5), a3);
        for (int a7 = 1; a7 <= a5.nRows(); ++a7) {
            double a8 = a5.get(a7, a7);
            if (DoubleUtils.compare(a8, 0.0, a6) > 0) {
                a5.set(a7, a7, 1.0 / a8);
                continue;
            }
            a5.set(a7, a7, 0.0);
        }
        Matrix a9 = a4.V().multiply(a5).multiply(a4.Ut());
        return a9;
    }

    private static double final(Matrix a2, DiagonalMatrix a3) {
        double a4 = DoubleArrayMath.max(a3.getDiagonal().toArray());
        double a5 = Math.max(a2.nRows(), a2.nCols());
        double a6 = Constants.EPSILON * a4 * a5;
        return a6;
    }

    public PseudoInverse(Matrix A2, double epsilon) {
        super(PseudoInverse.final(A2, epsilon));
    }
}

