/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixTable;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ElementaryOperation
implements MatrixTable {
    private final int void;
    private final Vector[] if;
    private final int new;

    public ElementaryOperation addRow(int i1, int i2, double c2) {
        Vector a2 = this.if[i1 - 1];
        Vector a3 = this.if[i2 - 1];
        for (int a4 = 1; a4 <= this.void; ++a4) {
            a2.set(a4, a2.get(a4) + c2 * a3.get(a4));
        }
        return this;
    }

    public ElementaryOperation(Matrix A2) {
        this.new = A2.nRows();
        this.void = A2.nCols();
        this.if = new Vector[this.new];
        for (int a2 = 1; a2 <= this.new; ++a2) {
            this.if[a2 - 1] = A2.getRow(a2);
        }
    }

    public ElementaryOperation scaleRow(int i2, double c2) {
        Vector a2 = this.if[i2 - 1];
        for (int a3 = 1; a3 <= this.void; ++a3) {
            a2.set(a3, c2 * a2.get(a3));
        }
        return this;
    }

    @Override
    public int nCols() {
        return this.void;
    }

    public ElementaryOperation addColumn(int j1, int j2, double c2) {
        for (Vector a2 : this.if) {
            a2.set(j1, a2.get(j1) + c2 * a2.get(j2));
        }
        return this;
    }

    public ElementaryOperation swapRow(int i1, int i2) {
        Vector a2 = this.if[i1 - 1];
        this.if[i1 - 1] = this.if[i2 - 1];
        this.if[i2 - 1] = a2;
        return this;
    }

    public ElementaryOperation scaleColumn(int j2, double c2) {
        for (Vector a2 : this.if) {
            a2.set(j2, c2 * a2.get(j2));
        }
        return this;
    }

    public ElementaryOperation swapColumn(int j1, int j2) {
        for (Vector a2 : this.if) {
            double a3 = a2.get(j1);
            a2.set(j1, a2.get(j2));
            a2.set(j2, a3);
        }
        return this;
    }

    @Override
    @Deprecated
    public void set(int i2, int j2, double value) throws MatrixAccessException {
        throw new UnsupportedOperationException("please use the elementary operations");
    }

    @Override
    public double get(int i2, int j2) {
        return this.if[i2 - 1].get(j2);
    }

    public ElementaryOperation(int nRows, int nCols) {
        this(new DenseMatrix(nRows, nCols).ONE());
    }

    @Override
    public int nRows() {
        return this.new;
    }

    public Matrix T() {
        return MatrixFactory.rbind(this.if);
    }

    public ElementaryOperation(int dim) {
        this(dim, dim);
    }

    public String toString() {
        return this.T().toString();
    }
}

