/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.stationary.SORSweep;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.algorithm.iterative.monitor.IterationMonitor;
import dev.nm.misc.algorithm.iterative.monitor.NullMonitor;
import dev.nm.misc.algorithm.iterative.tolerance.Tolerance;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SymmetricSuccessiveOverrelaxationSolver
implements IterativeLinearSystemSolver {
    private final Tolerance void;
    private final double if;
    private final int new;

    public SymmetricSuccessiveOverrelaxationSolver(double omega, int maxIteration, Tolerance tolerance) {
        this.if = omega;
        this.new = maxIteration;
        this.void = tolerance;
    }

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(problem.A()), "A must be a square matrix", new Object[0]);
        return new IterativeLinearSystemSolver.Solution(){
            private boolean short;
            private Vector enum;
            int count;
            private final SORSweep false;
            private final Matrix void;
            private final Vector if;
            private Vector new;

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                monitor.addIterate(this.enum);
                this.enum = this.false.forward(this.enum);
                this.enum = this.false.backward(this.enum);
                this.new = this.if.minus(this.void.multiply(this.enum));
                return monitor;
            }

            public void setInitials(Vector ... initials) {
                this.enum = initials[0];
                this.new = this.if.minus(this.void.multiply(this.enum));
                this.short = SymmetricSuccessiveOverrelaxationSolver.this.void.isResidualSmall(this.new.norm());
            }
            {
                1 a3;
                a3.void = a3.problem.A();
                a3.if = a3.problem.b();
                a3.false = new SORSweep(a3.void, a3.if, a3.SymmetricSuccessiveOverrelaxationSolver.this.if);
                a3.count = 0;
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.count < SymmetricSuccessiveOverrelaxationSolver.this.new && !this.short) {
                    this.step();
                    ++this.count;
                    this.short |= SymmetricSuccessiveOverrelaxationSolver.this.void.isResidualSmall(this.new.norm());
                }
                monitor.addIterate(this.enum);
                if (!this.short) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, SymmetricSuccessiveOverrelaxationSolver.this.new + " exceeded");
                }
                return this.enum;
            }
        };
    }
}

