/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrixUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DOKSparseMatrix
implements SparseMatrix {
    private final int false;
    private final int void;
    private static final MatrixMathOperation if = new AutoParallelMatrixMathOperation();
    private HashMap<MatrixCoordinate, Double> new;

    @Override
    public SparseVector getRow(int i2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i2);
        SparseVector a2 = new SparseVector(this.false);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.new.entrySet()) {
            if (a3.getKey().i != i2) continue;
            a2.set(a3.getKey().j, a3.getValue());
        }
        return a2;
    }

    public DOKSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] value) {
        this(nRows, nCols);
        this.new = new HashMap(value.length);
        ArgumentAssertion.assertTrue(rowIndices.length == columnIndices.length && rowIndices.length == value.length, "input arrays size mismatch", new Object[0]);
        for (int a2 = 0; a2 < rowIndices.length; ++a2) {
            this.final(rowIndices[a2], columnIndices[a2], value[a2]);
        }
    }

    @Override
    public List<SparseMatrix.Entry> getEntryList() {
        ArrayList<SparseMatrix.Entry> a2 = new ArrayList<SparseMatrix.Entry>(this.nNonZeros());
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.new.entrySet()) {
            a2.add(new SparseMatrix.Entry(a3.getKey(), a3.getValue()));
        }
        SparseMatrixUtils.sortInRowColumnOrder(a2, this.void, this.false, false, false);
        return a2;
    }

    @Override
    public DenseMatrix toDense() {
        DenseMatrix a2 = new DenseMatrix(this.void, this.false);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.new.entrySet()) {
            MatrixCoordinate a4 = a3.getKey();
            a2.set(a4.i, a4.j, a3.getValue());
        }
        return a2;
    }

    private Double final(int a2, int a3, double a4) {
        DOKSparseMatrix a5;
        DimensionCheck.throwIfInvalidRow(a5, a2);
        DimensionCheck.throwIfInvalidColumn(a5, a3);
        if (Double.compare(0.0, a4) != 0) {
            return a5.new.put(new MatrixCoordinate(a2, a3), a4);
        }
        return a5.new.remove(new MatrixCoordinate(a2, a3));
    }

    @Override
    public SparseVector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        SparseVector a2 = new SparseVector(this.void);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.new.entrySet()) {
            if (a3.getKey().j != j2) continue;
            a2.set(a3.getKey().i, a3.getValue());
        }
        return a2;
    }

    @Override
    public DOKSparseMatrix scaled(double c2) {
        if (Double.compare(0.0, c2) == 0) {
            return new DOKSparseMatrix(this.void, this.false);
        }
        DOKSparseMatrix a2 = new DOKSparseMatrix(this.void, this.false);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.new.entrySet()) {
            a2.new.put(a3.getKey(), c2 * a3.getValue());
        }
        return a2;
    }

    @Override
    public DOKSparseMatrix t() {
        DOKSparseMatrix a2 = new DOKSparseMatrix(this.false, this.void);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.new.entrySet()) {
            MatrixCoordinate a4 = a3.getKey();
            a2.set(a4.j, a4.i, a3.getValue());
        }
        return a2;
    }

    @Override
    public Vector multiply(Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        Vector a2 = v instanceof SparseVector ? new SparseVector(this.void) : new DenseVector(this.void);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.new.entrySet()) {
            double a4 = a3.getValue() * v.get(a3.getKey().j);
            int a5 = a3.getKey().i;
            a2.set(a5, a2.get(a5) + a4);
        }
        return a2;
    }

    @Override
    public DOKSparseMatrix deepCopy() {
        return new DOKSparseMatrix(this);
    }

    public DOKSparseMatrix(DOKSparseMatrix that) {
        this(that.void, that.false);
        this.new = new HashMap<MatrixCoordinate, Double>(that.new);
    }

    @Override
    public DOKSparseMatrix ONE() {
        int a2 = Math.min(this.void, this.false);
        double[] a3 = DoubleUtils.rep(1.0, a2);
        int[] a4 = DoubleUtils.seq(1, a2);
        int[] a5 = DoubleUtils.seq(1, a2);
        return new DOKSparseMatrix(this.void, this.false, a4, a5, a3);
    }

    @Override
    public void set(int row, int col, double value) {
        this.final(row, col, value);
    }

    public DOKSparseMatrix(int nRows, int nCols, List<SparseMatrix.Entry> entries) {
        this(nRows, nCols);
        this.new = new HashMap(entries.size());
        for (SparseMatrix.Entry a2 : entries) {
            Double a3 = this.final(a2.coordinates.i, a2.coordinates.j, a2.value);
            ArgumentAssertion.assertTrue(a3 == null, "repeated entry at coordinates %s", a2.coordinates);
        }
    }

    public DOKSparseMatrix(int nRows, int nCols) {
        this.void = nRows;
        this.false = nCols;
        this.new = new HashMap(0);
    }

    @Override
    public int nRows() {
        return this.void;
    }

    @Override
    public double get(int i2, int j2) {
        DimensionCheck.throwIfInvalidRow(this, i2);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        Double a2 = this.new.get(new MatrixCoordinate(i2, j2));
        return a2 == null ? 0.0 : a2;
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof DOKSparseMatrix) {
            return this.final((DOKSparseMatrix)that, -1);
        }
        return if.minus(this, that);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!SparseMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        DOKSparseMatrix a2 = (DOKSparseMatrix)obj;
        if (this.void != a2.void) {
            return false;
        }
        if (this.false != a2.false) {
            return false;
        }
        return SparseMatrixUtils.equals(this, a2);
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 71 * a2 + (this.new != null ? this.new.hashCode() : 0);
        a2 = 71 * a2 + this.void;
        a2 = 71 * a2 + this.false;
        return a2;
    }

    public String toString() {
        return SparseMatrixUtils.toString(this);
    }

    @Override
    public Matrix multiply(Matrix that) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, that);
        int a2 = that.nCols();
        Densifiable a3 = that instanceof SparseMatrix ? new DOKSparseMatrix(this.void, a2) : new DenseMatrix(this.void, a2);
        for (Map.Entry<MatrixCoordinate, Double> a4 : this.new.entrySet()) {
            int a5 = a4.getKey().i;
            int a6 = a4.getKey().j;
            double a7 = a4.getValue();
            for (int a8 = 1; a8 <= a2; ++a8) {
                a3.set(a5, a8, a3.get(a5, a8) + a7 * that.get(a6, a8));
            }
        }
        return a3;
    }

    @Override
    public DOKSparseMatrix opposite() {
        return this.scaled(-1.0);
    }

    private DOKSparseMatrix final(DOKSparseMatrix a2, int a3) {
        DOKSparseMatrix a4;
        DimensionCheck.throwIfDifferentDimension(a4, a2);
        DOKSparseMatrix a5 = new DOKSparseMatrix(a4);
        for (Map.Entry<MatrixCoordinate, Double> a6 : a2.new.entrySet()) {
            MatrixCoordinate a7 = a6.getKey();
            Double a8 = a5.new.get(a7);
            a8 = a8 == null ? (double)a3 * a6.getValue() : a8 + (double)a3 * a6.getValue();
            if (Double.compare(0.0, a8) != 0) {
                a5.new.put(a7, a8);
                continue;
            }
            a5.new.remove(a7);
        }
        return a5;
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof DOKSparseMatrix) {
            return this.final((DOKSparseMatrix)that, 1);
        }
        return if.add(this, that);
    }

    @Override
    public int nNonZeros() {
        return this.new.size();
    }

    @Override
    public int nCols() {
        return this.false;
    }

    @Override
    public SparseMatrix.ValueArray getValueArray() {
        int a2 = this.nNonZeros();
        int[] a3 = new int[a2];
        int[] a4 = new int[a2];
        double[] a5 = new double[a2];
        int a6 = 0;
        for (Map.Entry<MatrixCoordinate, Double> a7 : this.new.entrySet()) {
            MatrixCoordinate a8 = a7.getKey();
            a3[a6] = a8.i;
            a4[a6] = a8.j;
            a5[a6] = a7.getValue();
            ++a6;
        }
        return new SparseMatrix.ValueArray(a3, a4, a5);
    }

    @Override
    public DOKSparseMatrix ZERO() {
        return new DOKSparseMatrix(this.void, this.false);
    }
}

