/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.svd;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.GolubKahanSVD;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.SVDDecomposition;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.mr3.SVDbyMR3;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SVD
implements SVDDecomposition {
    private final SVDDecomposition enum;
    private final double false;
    public static final Method DEFAULT_METHOD = Method.MR3;
    private final boolean void;
    private final Matrix if;
    private final boolean new;

    public SVD(Matrix A2, boolean doUV, double epsilon, Method method) {
        this.if = A2;
        this.new = doUV;
        this.false = epsilon;
        this.void = DimensionCheck.isTall(A2);
        Matrix a2 = this.void ? this.if : this.if.t();
        this.enum = method.getImplementation(a2, this.new, this.false);
    }

    @Override
    public DiagonalMatrix D() {
        return this.enum.D();
    }

    public SVD(Matrix A2, boolean doUV, double epsilon) {
        this(A2, doUV, epsilon, Method.MR3);
    }

    @Override
    public double[] getSingularValues() {
        return this.enum.getSingularValues();
    }

    @Override
    public Matrix V() {
        Matrix a2 = this.void ? this.enum.V() : this.enum.U();
        return a2;
    }

    @Override
    public Matrix Ut() {
        return this.U().t();
    }

    @Override
    public Matrix U() {
        Matrix a2 = this.void ? this.enum.U() : this.enum.V();
        return a2;
    }

    public SVD(Matrix A2, boolean doUV) {
        this(A2, doUV, PrecisionUtils.autoEpsilon(A2));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Method {
        GOLUB_KAHAN{

            @Override
            SVDDecomposition getImplementation(Matrix a2, boolean a3, double a4) {
                return new GolubKahanSVD(a2, a3, true, a4);
            }
            {
                1 a2;
            }
        }
        ,
        MR3{
            {
                2 a2;
            }

            @Override
            SVDDecomposition getImplementation(Matrix a2, boolean a3, double a4) {
                return new SVDbyMR3(a2, a3);
            }
        };


        private Method() {
            Method a2;
        }

        abstract SVDDecomposition getImplementation(Matrix var1, boolean var2, double var3);
    }
}

