/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.trend.dai2011;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.ThomasAlgorithm;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation.ConvectionDiffusionEquation1D;
import dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation.CrankNicolsonConvectionDiffusionEquation1D;
import dev.nm.analysis.function.rn2r1.AbstractBivariateRealFunction;
import dev.nm.analysis.function.rn2r1.BivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import tech.nmfin.trend.dai2011.Dai2011HMM;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Dai2011Solver {
    private final UnivariateRealFunction do;
    private final double long;
    private final CrankNicolsonConvectionDiffusionEquation1D.Coefficients case;
    private static final double catch = 1.0E-6;
    private final Vector int;
    private final BivariateRealFunction final;
    private final CrankNicolsonConvectionDiffusionEquation1D.Coefficients super;
    private static final int null = 10;
    private final TridiagonalMatrix class;
    private final double true;
    private final Vector break;
    private final Dai2011HMM const;
    private final BivariateRealFunction this;
    private final ConvectionDiffusionEquation1D else;
    private final double goto;
    private final ConvectionDiffusionEquation1D try;
    private static final double float = 1.0E7;
    private final BivariateRealFunction short;
    private final int enum;
    private final double false;
    private final double void;
    private final BivariateRealFunction if;
    private final int new;

    private Dai2011Solver(Builder a2) {
        Dai2011Solver a3;
        a3.short = new AbstractBivariateRealFunction(){

            @Override
            public double evaluate(double t, double p) {
                double a2 = -(Dai2011Solver.this.const.lambda1() + Dai2011Solver.this.const.lambda2()) * p + Dai2011Solver.this.const.lambda2();
                return -a2;
            }
            {
                1 a3;
            }
        };
        a3.final = new AbstractBivariateRealFunction(){

            @Override
            public double evaluate(double t, double p) {
                double a2 = (Dai2011Solver.this.const.mu1() - Dai2011Solver.this.const.mu2()) * p * (1.0 - p) / Dai2011Solver.this.const.sigma();
                a2 = a2 * a2 / 2.0;
                return a2;
            }
            {
                2 a3;
            }
        };
        a3.do = new AbstractUnivariateRealFunction(){
            {
                3 a3;
            }

            @Override
            public double evaluate(double p) {
                return 0.0;
            }
        };
        a3.if = new AbstractBivariateRealFunction(){
            {
                4 a3;
            }

            @Override
            public double evaluate(double t, double p) {
                return Dai2011Solver.this.false;
            }
        };
        a3.this = new AbstractBivariateRealFunction(){

            @Override
            public double evaluate(double t, double p) {
                double a2 = (Dai2011Solver.this.const.mu1() - Dai2011Solver.this.const.mu2()) * p;
                a2 += Dai2011Solver.this.const.mu2();
                return a2 -= Dai2011Solver.this.const.sigma() * Dai2011Solver.this.const.sigma() / 2.0;
            }
            {
                5 a3;
            }
        };
        a3.const = a2.enum;
        a3.false = a2.short;
        a3.true = a2.void;
        a3.goto = a2.false;
        a3.long = a2.new;
        a3.void = a2.if;
        a3.new = (int)(1.0 / a3.long);
        a3.enum = (int)(1.0 / a3.void) + 1;
        if (a3.enum < 50) {
            throw new IllegalArgumentException("spatial step size is too large!");
        }
        a3.try = new ConvectionDiffusionEquation1D(a3.final, a3.short, a3.if, 1.0, 1.0, a3.do, 1.0, a3.do, 1.0, a3.do);
        double[] a4 = DoubleUtils.seq(0.0, a3.try.a(), a3.enum + 2);
        a3.case = new CrankNicolsonConvectionDiffusionEquation1D.Coefficients(a3.try, a3.new, a3.enum, a4);
        a3.class = a3.case.getLHS(0.0);
        a3.else = new ConvectionDiffusionEquation1D(a3.final, a3.short, a3.this, 1.0, 1.0, a3.do, 1.0, a3.do, 1.0, a3.do);
        a3.super = new CrankNicolsonConvectionDiffusionEquation1D.Coefficients(a3.else, a3.new, a3.enum, a4);
        a3.int = new DenseVector(a3.new);
        a3.break = new DenseVector(a3.new);
    }

    private double final(Vector a2, double a3) {
        Dai2011Solver a4;
        for (int a5 = a4.enum / 10; a5 < a4.enum; ++a5) {
            if (!(a2.get(a5) > a3)) continue;
            double a6 = a4.void * (double)a5;
            return a6;
        }
        return a4.void * (double)(a4.enum - 1);
    }

    static {
        Package.validate("ALGOQUANT_DAI2011");
    }

    private Vector[] final(Vector a2, Vector a3) {
        Dai2011Solver a4;
        Vector[] a5 = new DenseVector[2];
        Vector a6 = a4.case.getRHS(a2, 0.0);
        a5[0] = new ThomasAlgorithm().solve(a4.class, a6);
        Vector a7 = a4.super.getRHS(a3, 0.0);
        a5[1] = new ThomasAlgorithm().solve(a4.class, a7);
        Vector a8 = a3.minus(a2);
        Vector[] a9 = a4.final(a8, a5, a6, a7);
        return a9;
    }

    public Boundaries solve() {
        Vector a2 = new DenseVector(this.enum);
        Vector a3 = new DenseVector(this.enum, this.goto);
        for (int a4 = this.new; a4 >= 1; --a4) {
            Vector[] a5 = this.final(a2, a3);
            Vector a6 = a5[1].minus(a5[0]);
            this.int.set(a4, this.final(a6, this.true - 1.0E-6));
            this.break.set(a4, this.final(a6, this.goto + 1.0E-6));
            a2 = a5[0].deepCopy();
            a3 = a5[1].deepCopy();
        }
        Boundaries a7 = new Boundaries(this.int, this.break);
        return a7;
    }

    private Vector[] final(Vector a2, Vector[] a3, Vector a4, Vector a5) {
        Vector[] a6 = new Vector[]{a3[0].deepCopy(), a3[1].deepCopy()};
        double a7 = Double.POSITIVE_INFINITY;
        double a8 = Double.POSITIVE_INFINITY;
        for (int a9 = 0; a9 < 10; ++a9) {
            Dai2011Solver a10;
            Vector a11 = a6[1].minus(a6[0]);
            Matrix a12 = a10.class.deepCopy();
            Matrix a13 = a10.class.deepCopy();
            Vector a14 = a4.deepCopy();
            Vector a15 = a5.deepCopy();
            boolean a16 = false;
            boolean a17 = false;
            for (int a18 = 1; a18 <= a10.enum; ++a18) {
                if (a11.get(a18) + a2.get(a18) > 2.0 * a10.true) {
                    a16 = true;
                    ((TridiagonalMatrix)a12).set(a18, a18, ((TridiagonalMatrix)a12).get(a18, a18) + 1.0E7 * a10.long / 2.0);
                    a14.set(a18, a14.get(a18) + 1.0E7 * a10.long * (a6[1].get(a18) / 2.0 + a2.get(a18) / 2.0 - a10.true));
                    continue;
                }
                if (!(a11.get(a18) + a2.get(a18) < 2.0 * a10.goto)) continue;
                a17 = true;
                ((TridiagonalMatrix)a13).set(a18, a18, ((TridiagonalMatrix)a13).get(a18, a18) + 1.0E7 * a10.long / 2.0);
                a15.set(a18, a15.get(a18) + 1.0E7 * a10.long * (a6[0].get(a18) / 2.0 - a2.get(a18) / 2.0 + a10.goto));
            }
            if (a16) {
                a7 = a6[0].norm();
                a6[0] = new ThomasAlgorithm().solve((TridiagonalMatrix)a12, a14);
                a7 = Math.abs(a7 / a6[0].norm() - 1.0);
            }
            if (a17) {
                a8 = a6[1].norm();
                a6[1] = new ThomasAlgorithm().solve((TridiagonalMatrix)a13, a15);
                a8 = Math.abs(a8 / a6[1].norm() - 1.0);
            }
            if (a7 < 1.0E-6 && a8 < 1.0E-6) break;
        }
        return a6;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Builder {
        private static final double float = 0.0025;
        private final double short;
        private final Dai2011HMM enum;
        private double false;
        private double void = Math.log(1.0025);
        private double if = 0.001;
        private double new = 1.0E-4;

        public Builder(Dai2011HMM model, double rho) {
            this.false = Math.log(0.9975);
            this.enum = model;
            this.short = rho;
        }

        public Builder grid(double dt, double dp) {
            this.new = dt;
            this.if = dp;
            return this;
        }

        public Builder commission(double K2) {
            this.void = Math.log(1.0 + K2);
            this.false = Math.log(1.0 - K2);
            return this;
        }

        public Dai2011Solver build() {
            return new Dai2011Solver(this);
        }

        public Builder commission(double Kb, double Ks) {
            this.void = Math.log(1.0 + Kb);
            this.false = Math.log(1.0 - Ks);
            return this;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Boundaries {
        private final Vector if;
        private final Vector new;

        public double getBuyThreshold() {
            return this.final(this.if);
        }

        private Boundaries(Vector a2, Vector a3) {
            Boundaries a4;
            a4.if = a2;
            a4.new = a3;
        }

        public double getSellThreshold() {
            return this.final(this.new);
        }

        private double final(Vector a2) {
            int a3 = a2.size();
            int a4 = a3 / 10;
            int a5 = a3 - a3 / 10;
            double a6 = 0.0;
            int a7 = 0;
            for (int a8 = a4; a8 < a5; ++a8) {
                a6 += a2.get(a8);
                ++a7;
            }
            return a6 / (double)a7;
        }
    }
}

