/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.returns;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.Vector;
import tech.nmfin.returns.ReturnsCalculator;

public final class Returns {
    public static double[] getPricesFromReturns(double price0, double[] returns, ReturnsCalculator calc) {
        int a2 = returns.length + 1;
        double[] a3 = new double[a2];
        a3[0] = price0;
        for (int a4 = 1; a4 < a2; ++a4) {
            a3[a4] = calc.computePrice(a3[a4 - 1], returns[a4 - 1]);
        }
        return a3;
    }

    public static Vector getMeanReturns(Matrix returns) {
        Vector a2 = MatrixUtils.colMeanVector(returns);
        return a2;
    }

    public static double[][] getVectorReturnsFromPrices(double[][] prices, ReturnsCalculator calc) {
        int a2 = prices.length;
        int a3 = prices[0].length;
        double[][] a4 = new double[a2 - 1][a3];
        for (int a5 = 0; a5 < a2 - 1; ++a5) {
            a4[a5] = Returns.getReturns(prices[a5], prices[a5 + 1], calc);
        }
        return a4;
    }

    public static Vector getMeanReturns(double[][] returns) {
        DenseMatrix a2 = new DenseMatrix(returns);
        return Returns.getMeanReturns(a2);
    }

    public static double[] getReturns(double[] lastPrices, double[] currentPrices, ReturnsCalculator calc) {
        int a2 = currentPrices.length;
        double[] a3 = new double[a2];
        for (int a4 = 0; a4 < a2; ++a4) {
            a3[a4] = calc.computeReturn(lastPrices[a4], currentPrices[a4]);
        }
        return a3;
    }

    public static double[] getReturnsFromPrices(double[] prices, ReturnsCalculator calc) {
        double[] a2 = new double[prices.length - 1];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = calc.computeReturn(prices[a3], prices[a3 + 1]);
        }
        return a2;
    }

    private Returns() {
        Returns a2;
    }
}

