/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.socp.constraints;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraint;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization.SOCPPortfolioConstraint;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SOCPMaximumLoan
extends SOCPPortfolioConstraint {
    private final Vector false;
    private final int void;
    private final Vector if;
    private final double new;

    public SOCPMaximumLoan(Vector w_0, Vector l2, double epsilon) {
        this.false = w_0;
        this.void = w_0.size();
        this.if = l2;
        this.new = epsilon;
        SOCPGeneralConstraints a2 = this.newSOCPGeneralConstraints(new SOCPPortfolioConstraint.Variable("y", this.void));
        for (int a3 = 1; a3 <= this.void; ++a3) {
            CSRSparseMatrix a4 = new CSRSparseMatrix(1, this.void);
            SparseVector a5 = new SparseVector(1);
            SparseVector a6 = new SparseVector(this.void, new int[]{a3}, new double[]{1.0});
            double a7 = (Math.abs(w_0.get(a3)) - w_0.get(a3)) / 2.0 - l2.get(a3);
            a2.add(new SOCPGeneralConstraint(a4.t(), a5, a6, a7));
        }
    }

    @Override
    public int dimensionOfRange() {
        return 1;
    }

    @Override
    public Double evaluate(Vector y) {
        Vector a2 = y.minus(this.false);
        double a3 = 0.0;
        for (int a4 = 1; a4 <= this.void; ++a4) {
            double a5 = a2.get(a4) + Math.max(0.0, this.false.get(a4));
            double a6 = a5 - this.if.get(a4);
            a3 += a6;
        }
        return a3;
    }

    static {
        Package.validate("ALGOQUANT_SOCP_CONSTRAINTS");
    }

    @Override
    public boolean areAllConstraintsSatisfied(Vector y) throws SOCPPortfolioConstraint.ConstraintViolationException {
        for (int a2 = 1; a2 <= this.void; ++a2) {
            double a3 = y.get(a2) + Math.max(0.0, this.false.get(a2));
            double a4 = a3 - this.if.get(a2);
            if (DoubleUtils.compare(a4, 0.0, this.new) >= 0) continue;
            throw new SOCPPortfolioConstraint.ConstraintViolationException(String.format("borrowing more than allowed: %f, %s", a4, y.toString()));
        }
        return true;
    }

    @Override
    public int dimensionOfDomain() {
        return this.false.size();
    }

    public SOCPMaximumLoan(Vector w_0, Vector l2) {
        this(w_0, l2, 0.01);
    }
}

