/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.meanreversion.elliott2005;

import dev.nm.number.DoubleUtils;
import dev.nm.stat.dlm.univariate.DLM;
import dev.nm.stat.dlm.univariate.DLMSeries;
import dev.nm.stat.dlm.univariate.ObservationEquation;
import dev.nm.stat.dlm.univariate.StateEquation;
import dev.nm.stat.random.rng.RNGUtils;
import dev.nm.stat.random.rng.univariate.normal.RandomStandardNormalGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Elliott2005DLM
extends DLM {
    private final OrnsteinUhlenbeckProcess if;
    private final RandomStandardNormalGenerator new;

    public double C() {
        return Math.sqrt(this.getStateModel().W(1));
    }

    public double[] simStates(int T2) {
        DLMSeries a2 = new DLMSeries(T2, this, DoubleUtils.rep(1.0, T2), this.new);
        double[] a3 = a2.getStates();
        return a3;
    }

    public double mu() {
        return this.if.a / this.if.b;
    }

    public double holdingTime(double c2) {
        double a2 = c2 * c2 - 3.0;
        a2 *= a2;
        a2 += 4.0 * c2 * c2;
        a2 = Math.sqrt(a2);
        a2 += c2 * c2 - 3.0;
        a2 /= 2.0;
        a2 += 1.0;
        a2 = Math.log(a2);
        a2 /= 2.0;
        return a2 /= this.if.b;
    }

    public double B() {
        return this.getStateModel().G(1);
    }

    public double A() {
        return this.getStateModel().H(1);
    }

    public double threshold(double c2) {
        double a2 = c2 * this.if.sigma / Math.sqrt(2.0 * this.if.b);
        return a2;
    }

    public Elliott2005DLM(Elliott2005DLM that) {
        this(that.m0(), that.A(), that.B(), that.C(), that.D());
    }

    public double[] simObs(int T2) {
        DLMSeries a2 = new DLMSeries(T2, this, DoubleUtils.rep(1.0, T2), this.new);
        double[] a3 = a2.getObservations();
        return a3;
    }

    public double D() {
        return Math.sqrt(this.getObservationModel().V(1));
    }

    public Elliott2005DLM(double x0, double A2, double B2, double C3, double D2, RandomStandardNormalGenerator rnorm) {
        super(x0, 0.0, new ObservationEquation(1.0, D2 * D2, rnorm), new StateEquation(B2, A2, C3 * C3, rnorm));
        this.new = rnorm;
        this.if = new OrnsteinUhlenbeckProcess(this);
    }

    public double holdingTimeByThreshold(double threshold) {
        double a2 = threshold * Math.sqrt(2.0 * this.if.b) / this.if.sigma;
        return this.holdingTime(a2);
    }

    public Elliott2005DLM(double x0, double A2, double B2, double C3, double D2) {
        this(x0, A2, B2, C3, D2, RNGUtils.RNORM);
    }

    private static class OrnsteinUhlenbeckProcess {
        final double a;
        final double b;
        final double sigma;

        private OrnsteinUhlenbeckProcess(Elliott2005DLM a2) {
            a3(a2, 1.0);
            OrnsteinUhlenbeckProcess a3;
        }

        private OrnsteinUhlenbeckProcess(Elliott2005DLM a2, double a3) {
            OrnsteinUhlenbeckProcess a4;
            a4.a = a2.A() / a3;
            a4.b = (1.0 - a2.B()) / a3;
            a4.sigma = a2.C() / Math.sqrt(a3);
        }
    }
}

