/*
 * Decompiled with CFR 0.152.
 */
package org.teneighty.heap;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.teneighty.heap.Action;
import org.teneighty.heap.Heap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Heaps {
    static boolean ReferenceEquals(Object a2, Object a3) {
        return a2 == a3;
    }

    public static <TKey, TValue> Heap<TKey, TValue> emptyHeap() {
        return new EmptyHeap();
    }

    public static <TKey, TValue> Heap<TKey, TValue> unmodifiableHeap(Heap<TKey, TValue> heap) throws NullPointerException {
        if (heap == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableHeap<TKey, TValue>(heap);
    }

    private Heaps() throws InternalError {
        Heaps a2;
        throw new InternalError("Instances are not allowed");
    }

    public static <TKey, TValue> Heap<TKey, TValue> synchronizedHeap(Heap<TKey, TValue> heap) throws NullPointerException {
        if (heap == null) {
            throw new NullPointerException();
        }
        return new SynchronizedHeap<TKey, TValue>(heap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SynchronizedHeap<TKey, TValue>
    implements Heap<TKey, TValue>,
    Iterable<Heap.Entry<TKey, TValue>>,
    Serializable {
        private transient Object mutex;
        private static final long serialVersionUID = 4798234789234L;
        private Heap<TKey, TValue> heap;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean holdsEntry(Heap.Entry<TKey, TValue> entry) throws NullPointerException {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.holdsEntry(entry);
            }
        }

        SynchronizedHeap(Heap<TKey, TValue> a2, Object a3) throws NullPointerException {
            SynchronizedHeap a4;
            if (a2 == null || a3 == null) {
                throw new NullPointerException();
            }
            a4.heap = a2;
            a4.mutex = a3;
        }

        private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
            SynchronizedHeap a3;
            a2.defaultReadObject();
            if (a3.heap == null) {
                throw new InvalidObjectException("Backing heap is non-existant.");
            }
            a3.mutex = a3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super TKey> getComparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.getComparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Heap.Entry<TKey, TValue>> getEntries() {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.getEntries();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(Action<Heap.Entry<TKey, TValue>> action) throws NullPointerException {
            Object object = this.mutex;
            synchronized (object) {
                this.heap.forEach(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void decreaseKey(Heap.Entry<TKey, TValue> e2, TKey key) throws IllegalArgumentException, ClassCastException, NullPointerException {
            Object object = this.mutex;
            synchronized (object) {
                this.heap.decreaseKey(e2, key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsEntry(Heap.Entry<TKey, TValue> entry) throws NullPointerException {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.containsEntry(entry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete(Heap.Entry<TKey, TValue> e2) throws IllegalArgumentException, NullPointerException {
            Object object = this.mutex;
            synchronized (object) {
                this.heap.delete(e2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object other) {
            Object object = this.mutex;
            synchronized (object) {
                if (other == null) {
                    return false;
                }
                if (this == other) {
                    return true;
                }
                return ((Object)this.heap).equals(other);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Heap.Entry<TKey, TValue> getMinimum() throws NoSuchElementException {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.getMinimum();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Heap.Entry<TKey, TValue> insert(TKey key, TValue value) throws ClassCastException {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.insert(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<TKey> getKeys() {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.getKeys();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getSize() {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.getSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.heap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertAll(Heap<? extends TKey, ? extends TValue> other) throws NullPointerException, ClassCastException, IllegalArgumentException {
            if (other == null) {
                throw new NullPointerException();
            }
            if (Heaps.ReferenceEquals(other, this) || Heaps.ReferenceEquals(other, this.heap)) {
                throw new IllegalArgumentException();
            }
            Object object = this.mutex;
            synchronized (object) {
                this.insertAll(other);
            }
        }

        private void writeObject(ObjectOutputStream a2) throws IOException {
            a2.defaultWriteObject();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<TValue> getValues() {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.getValues();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<Heap.Entry<TKey, TValue>> iterator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void union(Heap<TKey, TValue> other) throws ClassCastException, NullPointerException, IllegalArgumentException {
            Object object = this.mutex;
            synchronized (object) {
                this.heap.union(other);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Heap.Entry<TKey, TValue> extractMinimum() throws NoSuchElementException {
            Object object = this.mutex;
            synchronized (object) {
                return this.heap.extractMinimum();
            }
        }

        SynchronizedHeap(Heap<TKey, TValue> a2) throws NullPointerException {
            SynchronizedHeap a3;
            if (a2 == null) {
                throw new NullPointerException();
            }
            a3.heap = a2;
            a3.mutex = a3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.heap).hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnmodifiableHeap<TKey, TValue>
    implements Heap<TKey, TValue>,
    Iterable<Heap.Entry<TKey, TValue>>,
    Serializable {
        private Heap<TKey, TValue> heap;
        private static final long serialVersionUID = 23408234L;

        @Override
        public Heap.Entry<TKey, TValue> extractMinimum() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Action<Heap.Entry<TKey, TValue>> action) throws NullPointerException {
            this.heap.forEach(action);
        }

        @Override
        public Collection<TKey> getKeys() {
            return Collections.unmodifiableCollection(this.heap.getKeys());
        }

        @Override
        public void decreaseKey(Heap.Entry<TKey, TValue> e2, TKey key) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Heap.Entry<TKey, TValue> insert(TKey key, TValue value) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Comparator<? super TKey> getComparator() {
            return this.heap.getComparator();
        }

        @Override
        public void insertAll(Heap<? extends TKey, ? extends TValue> other) throws NullPointerException, ClassCastException, IllegalArgumentException {
            if (other == null) {
                throw new NullPointerException();
            }
            if (Heaps.ReferenceEquals(other, this) || Heaps.ReferenceEquals(other, this.heap)) {
                throw new IllegalArgumentException();
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsEntry(Heap.Entry<TKey, TValue> entry) throws NullPointerException {
            return this.heap.containsEntry(entry);
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            return ((Object)this.heap).equals(other);
        }

        @Override
        public Iterator<Heap.Entry<TKey, TValue>> iterator() {
            return new ImmutableHeapEntryIterator<TKey, TValue>(this.heap.iterator());
        }

        @Override
        public Heap.Entry<TKey, TValue> getMinimum() throws NoSuchElementException {
            return this.heap.getMinimum();
        }

        @Override
        public boolean isEmpty() {
            return this.heap.isEmpty();
        }

        @Override
        public Collection<TValue> getValues() {
            return Collections.unmodifiableCollection(this.heap.getValues());
        }

        public String toString() {
            return this.heap.toString();
        }

        @Override
        public int getSize() {
            return this.heap.getSize();
        }

        UnmodifiableHeap(Heap<TKey, TValue> a2) {
            UnmodifiableHeap a3;
            a3.heap = a2;
        }

        @Override
        public void delete(Heap.Entry<TKey, TValue> e2) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void union(Heap<TKey, TValue> other) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean holdsEntry(Heap.Entry<TKey, TValue> entry) throws NullPointerException {
            return this.heap.holdsEntry(entry);
        }

        @Override
        public Collection<Heap.Entry<TKey, TValue>> getEntries() {
            return Collections.unmodifiableCollection(this.heap.getEntries());
        }

        @Override
        public int hashCode() {
            return ((Object)this.heap).hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class ImmutableHeapEntry<TKey, TValue>
        implements Heap.Entry<TKey, TValue>,
        Serializable {
            private static final long serialVersionUID = 45897356L;
            private Heap.Entry<TKey, TValue> entry;

            @Override
            public TValue getValue() {
                return this.entry.getValue();
            }

            @Override
            public int hashCode() {
                return ((Object)this.entry).hashCode();
            }

            @Override
            public TValue setValue(TValue val) throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object other) {
                if (other == null) {
                    return false;
                }
                if (other == this) {
                    return true;
                }
                return ((Object)this.entry).equals(other);
            }

            @Override
            public TKey getKey() {
                return this.entry.getKey();
            }

            public String toString() {
                return this.entry.toString();
            }

            ImmutableHeapEntry(Heap.Entry<TKey, TValue> a2) {
                ImmutableHeapEntry a3;
                a3.entry = a2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class ImmutableHeapEntryIterator<TKey, TValue>
        implements Iterator<Heap.Entry<TKey, TValue>> {
            private Iterator<Heap.Entry<TKey, TValue>> backingIterator;

            @Override
            public boolean hasNext() {
                return this.backingIterator.hasNext();
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Heap.Entry<TKey, TValue> next() throws NoSuchElementException {
                Heap.Entry<TKey, TValue> a2 = this.backingIterator.next();
                return new ImmutableHeapEntry<TKey, TValue>(a2);
            }

            ImmutableHeapEntryIterator(Iterator<Heap.Entry<TKey, TValue>> a2) {
                ImmutableHeapEntryIterator a3;
                a3.backingIterator = a2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyHeap<TKey, TValue>
    implements Heap<TKey, TValue>,
    Iterable<Heap.Entry<TKey, TValue>>,
    Serializable {
        private static final long serialVersionUID = 476893L;

        public String toString() {
            return "EmptyHeap(0){}";
        }

        @Override
        public boolean holdsEntry(Heap.Entry<TKey, TValue> entry) throws NullPointerException {
            if (entry == null) {
                throw new NullPointerException();
            }
            return false;
        }

        @Override
        public void union(Heap<TKey, TValue> other) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public void forEach(Action<Heap.Entry<TKey, TValue>> action) throws NullPointerException {
            if (action == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public Heap.Entry<TKey, TValue> extractMinimum() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Heap.Entry<TKey, TValue>> getEntries() {
            return Collections.emptyList();
        }

        @Override
        public boolean containsEntry(Heap.Entry<TKey, TValue> entry) throws NullPointerException {
            if (entry == null) {
                throw new NullPointerException();
            }
            return false;
        }

        @Override
        public Comparator<? super TKey> getComparator() {
            return null;
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (Heap.class.isAssignableFrom(other.getClass())) {
                Heap a2 = (Heap)other;
                return a2.getSize() == 0;
            }
            return false;
        }

        EmptyHeap() {
            EmptyHeap a2;
        }

        @Override
        public Iterator<Heap.Entry<TKey, TValue>> iterator() {
            List a2 = Collections.emptyList();
            return a2.iterator();
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Heap.Entry<TKey, TValue> getMinimum() throws NoSuchElementException {
            throw new NoSuchElementException();
        }

        @Override
        public void decreaseKey(Heap.Entry<TKey, TValue> e2, TKey key) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Heap.Entry<TKey, TValue> insert(TKey key, TValue value) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<TKey> getKeys() {
            return Collections.emptyList();
        }

        @Override
        public Collection<TValue> getValues() {
            return Collections.emptyList();
        }

        @Override
        public void insertAll(Heap<? extends TKey, ? extends TValue> other) throws NullPointerException, ClassCastException, IllegalArgumentException {
            if (other == null) {
                throw new NullPointerException();
            }
            if (Heaps.ReferenceEquals(other, this)) {
                throw new IllegalArgumentException();
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete(Heap.Entry<TKey, TValue> e2) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

