/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTimeZone;
import org.joda.time.tz.DateTimeZoneBuilder;
import org.joda.time.tz.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoneInfoProvider
implements Provider {
    private final Set<String> iZoneInfoKeys;
    private final File iFileDir;
    private final Map<String, Object> iZoneInfoMap;
    private final String iResourcePath;
    private final ClassLoader iLoader;

    protected void uncaughtException(Exception arg0) {
        arg0.printStackTrace();
    }

    @Override
    public DateTimeZone getZone(String arg0) {
        if (arg0 == null) {
            return null;
        }
        Object object = this.iZoneInfoMap.get(arg0);
        if (object == null) {
            return null;
        }
        if (object instanceof SoftReference) {
            SoftReference softReference = (SoftReference)object;
            DateTimeZone dateTimeZone = (DateTimeZone)softReference.get();
            if (dateTimeZone != null) {
                return dateTimeZone;
            }
            return this.loadZoneData(arg0);
        }
        if (arg0.equals(object)) {
            return this.loadZoneData(arg0);
        }
        return this.getZone((String)object);
    }

    private static void readZoneInfoMap(DataInputStream a2, Map<String, Object> a3) throws IOException {
        int n;
        int n2 = a2.readUnsignedShort();
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = a2.readUTF().intern();
        }
        n2 = a2.readUnsignedShort();
        for (n = 0; n < n2; ++n) {
            try {
                a3.put(stringArray[a2.readUnsignedShort()], stringArray[a2.readUnsignedShort()]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Corrupt zone info map");
            }
        }
    }

    public ZoneInfoProvider(String arg0, ClassLoader arg1) throws IOException {
        this(arg0, arg1, true);
    }

    public ZoneInfoProvider(String arg0) throws IOException {
        this(arg0, null, false);
    }

    @Override
    public Set<String> getAvailableIDs() {
        return this.iZoneInfoKeys;
    }

    private InputStream openResource(String a2) throws IOException {
        InputStream inputStream;
        ZoneInfoProvider a3;
        if (a3.iFileDir != null) {
            inputStream = new FileInputStream(new File(a3.iFileDir, a2));
        } else {
            String string = a3.iResourcePath.concat(a2);
            inputStream = a3.iLoader != null ? a3.iLoader.getResourceAsStream(string) : ClassLoader.getSystemResourceAsStream(string);
            if (inputStream == null) {
                StringBuilder stringBuilder = new StringBuilder(40).append("Resource not found: \"").append(string).append("\" ClassLoader: ").append(a3.iLoader != null ? a3.iLoader.toString() : "system");
                throw new IOException(stringBuilder.toString());
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> loadZoneInfoMap(InputStream a2) throws IOException {
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        DataInputStream dataInputStream = new DataInputStream(a2);
        try {
            ZoneInfoProvider.readZoneInfoMap(dataInputStream, concurrentHashMap);
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
        }
        concurrentHashMap.put("UTC", new SoftReference<DateTimeZone>(DateTimeZone.UTC));
        return concurrentHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateTimeZone loadZoneData(String a2) {
        ZoneInfoProvider a3;
        InputStream inputStream = null;
        try {
            inputStream = a3.openResource(a2);
            DateTimeZone dateTimeZone = DateTimeZoneBuilder.readFrom(inputStream, a2);
            a3.iZoneInfoMap.put(a2, new SoftReference<DateTimeZone>(dateTimeZone));
            DateTimeZone dateTimeZone2 = dateTimeZone;
            return dateTimeZone2;
        }
        catch (IOException iOException) {
            a3.uncaughtException(iOException);
            a3.iZoneInfoMap.remove(a2);
            DateTimeZone dateTimeZone = null;
            return dateTimeZone;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private ZoneInfoProvider(String a2, ClassLoader a3, boolean a4) throws IOException {
        ZoneInfoProvider a5;
        if (a2 == null) {
            throw new IllegalArgumentException("No resource path provided");
        }
        if (!a2.endsWith("/")) {
            a2 = a2 + '/';
        }
        a5.iFileDir = null;
        a5.iResourcePath = a2;
        if (a3 == null && !a4) {
            a3 = a5.getClass().getClassLoader();
        }
        a5.iLoader = a3;
        a5.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(a5.openResource("ZoneInfoMap"));
        a5.iZoneInfoKeys = Collections.unmodifiableSortedSet(new TreeSet<String>(a5.iZoneInfoMap.keySet()));
    }

    public ZoneInfoProvider(File arg0) throws IOException {
        if (arg0 == null) {
            throw new IllegalArgumentException("No file directory provided");
        }
        if (!arg0.exists()) {
            throw new IOException("File directory doesn't exist: " + arg0);
        }
        if (!arg0.isDirectory()) {
            throw new IOException("File doesn't refer to a directory: " + arg0);
        }
        this.iFileDir = arg0;
        this.iResourcePath = null;
        this.iLoader = null;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
        this.iZoneInfoKeys = Collections.unmodifiableSortedSet(new TreeSet<String>(this.iZoneInfoMap.keySet()));
    }
}

