/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.MutableDateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.chrono.LenientChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.tz.DateTimeZoneBuilder;
import org.joda.time.tz.ZoneInfoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoneInfoCompiler {
    private Map<String, RuleSet> iRuleSets = new HashMap<String, RuleSet>();
    private List<String> iBackLinks;
    static Chronology cLenientISO;
    static DateTimeOfYear cStartOfYear;
    private List<Zone> iZones = new ArrayList<Zone>();
    private List<String> iGoodLinks = new ArrayList<String>();

    static String parseOptional(String a2) {
        return a2.equals("-") ? null : a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DateTimeZone> compile(File arg0, File[] arg1) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        if (arg1 != null) {
            for (int i2 = 0; i2 < arg1.length; ++i2) {
                object5 = new BufferedReader(new FileReader(arg1[i2]));
                this.parseDataFile((BufferedReader)object5, "backward".equals(arg1[i2].getName()));
                ((BufferedReader)object5).close();
            }
        }
        if (arg0 != null) {
            if (!arg0.exists() && !arg0.mkdirs()) {
                throw new IOException("Destination directory doesn't exist and cannot be created: " + arg0);
            }
            if (!arg0.isDirectory()) {
                throw new IOException("Destination is not a directory: " + arg0);
            }
        }
        TreeMap<String, DateTimeZone> treeMap = new TreeMap<String, DateTimeZone>();
        object5 = new TreeMap();
        System.out.println("Writing zoneinfo files");
        for (n = 0; n < this.iZones.size(); ++n) {
            object4 = this.iZones.get(n);
            object3 = new DateTimeZoneBuilder();
            ((Zone)object4).addToBuilder((DateTimeZoneBuilder)object3, this.iRuleSets);
            object2 = ((DateTimeZoneBuilder)object3).toDateTimeZone(((Zone)object4).iName, true);
            if (!ZoneInfoCompiler.test(((DateTimeZone)object2).getID(), (DateTimeZone)object2)) continue;
            treeMap.put(((DateTimeZone)object2).getID(), (DateTimeZone)object2);
            object5.put(((DateTimeZone)object2).getID(), object4);
            if (arg0 == null) continue;
            this.writeZone(arg0, (DateTimeZoneBuilder)object3, (DateTimeZone)object2);
        }
        for (n = 0; n < this.iGoodLinks.size(); n += 2) {
            object4 = this.iGoodLinks.get(n);
            object3 = this.iGoodLinks.get(n + 1);
            object2 = (Zone)object5.get(object4);
            if (object2 == null) {
                System.out.println("Cannot find source zone '" + (String)object4 + "' to link alias '" + (String)object3 + "' to");
                continue;
            }
            object = new DateTimeZoneBuilder();
            ((Zone)object2).addToBuilder((DateTimeZoneBuilder)object, this.iRuleSets);
            DateTimeZone dateTimeZone = ((DateTimeZoneBuilder)object).toDateTimeZone((String)object3, true);
            if (ZoneInfoCompiler.test(dateTimeZone.getID(), dateTimeZone)) {
                treeMap.put(dateTimeZone.getID(), dateTimeZone);
                if (arg0 != null) {
                    this.writeZone(arg0, (DateTimeZoneBuilder)object, dateTimeZone);
                }
            }
            treeMap.put(dateTimeZone.getID(), dateTimeZone);
            if (!ZoneInfoLogger.verbose()) continue;
            System.out.println("Good link: " + (String)object3 + " -> " + (String)object4 + " revived");
        }
        for (n = 0; n < 2; ++n) {
            for (int i3 = 0; i3 < this.iBackLinks.size(); i3 += 2) {
                object3 = this.iBackLinks.get(i3);
                object2 = this.iBackLinks.get(i3 + 1);
                object = (DateTimeZone)treeMap.get(object3);
                if (object == null) {
                    if (n <= 0) continue;
                    System.out.println("Cannot find time zone '" + (String)object3 + "' to link alias '" + object2 + "' to");
                    continue;
                }
                treeMap.put((String)object2, (DateTimeZone)object);
                if (!ZoneInfoLogger.verbose()) continue;
                System.out.println("Back link: " + object2 + " -> " + ((DateTimeZone)object).getID());
            }
        }
        if (arg0 != null) {
            System.out.println("Writing ZoneInfoMap");
            File file = new File(arg0, "ZoneInfoMap");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            object3 = new DataOutputStream(fileOutputStream);
            try {
                object2 = new TreeMap<String, DateTimeZone>(String.CASE_INSENSITIVE_ORDER);
                object2.putAll(treeMap);
                ZoneInfoCompiler.writeZoneInfoMap((DataOutputStream)object3, object2);
            }
            finally {
                ((FilterOutputStream)object3).close();
            }
        }
        return treeMap;
    }

    static boolean test(String a2, DateTimeZone a3) {
        long l2;
        long l3;
        if (!a2.equals(a3.getID())) {
            return true;
        }
        long l4 = ISOChronology.getInstanceUTC().year().set(0L, 1850);
        long l5 = ISOChronology.getInstanceUTC().year().set(0L, 2050);
        int n = a3.getOffset(l4);
        String string = a3.getNameKey(l4);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while ((l3 = a3.nextTransition(l4)) != l4 && l3 <= l5) {
            l4 = l3;
            int n2 = a3.getOffset(l4);
            String string2 = a3.getNameKey(l4);
            if (n == n2 && string.equals(string2)) {
                System.out.println("*d* Error in " + a3.getID() + " " + new DateTime(l4, (Chronology)ISOChronology.getInstanceUTC()));
                return false;
            }
            if (string2 == null || string2.length() < 3 && !"??".equals(string2)) {
                System.out.println("*s* Error in " + a3.getID() + " " + new DateTime(l4, (Chronology)ISOChronology.getInstanceUTC()) + ", nameKey=" + string2);
                return false;
            }
            arrayList.add(l4);
            n = n2;
            string = string2;
        }
        l4 = ISOChronology.getInstanceUTC().year().set(0L, 2050);
        l5 = ISOChronology.getInstanceUTC().year().set(0L, 1850);
        int n3 = arrayList.size();
        while (--n3 >= 0 && (l2 = a3.previousTransition(l4)) != l4 && l2 >= l5) {
            l4 = l2;
            long l6 = (Long)arrayList.get(n3);
            if (l6 - 1L == l4) continue;
            System.out.println("*r* Error in " + a3.getID() + " " + new DateTime(l4, (Chronology)ISOChronology.getInstanceUTC()) + " != " + new DateTime(l6 - 1L, (Chronology)ISOChronology.getInstanceUTC()));
            return false;
        }
        return true;
    }

    static char parseZoneChar(char a2) {
        switch (a2) {
            case 'S': 
            case 's': {
                return 's';
            }
            case 'G': 
            case 'U': 
            case 'Z': 
            case 'g': 
            case 'u': 
            case 'z': {
                return 'u';
            }
        }
        return 'w';
    }

    private static void printUsage() {
        System.out.println("Usage: java org.joda.time.tz.ZoneInfoCompiler <options> <source files>");
        System.out.println("where possible options include:");
        System.out.println("  -src <directory>    Specify where to read source files");
        System.out.println("  -dst <directory>    Specify where to write generated files");
        System.out.println("  -verbose            Output verbosely (default false)");
    }

    static int parseTime(String a2) {
        int n;
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.hourMinuteSecondFraction();
        MutableDateTime mutableDateTime = new MutableDateTime(0L, ZoneInfoCompiler.getLenientISOChronology());
        int n2 = 0;
        if (a2.startsWith("-")) {
            n2 = 1;
        }
        if ((n = dateTimeFormatter.parseInto(mutableDateTime, a2, n2)) == ~n2) {
            throw new IllegalArgumentException(a2);
        }
        int n3 = (int)mutableDateTime.getMillis();
        if (n2 == 1) {
            n3 = -n3;
        }
        return n3;
    }

    static Chronology getLenientISOChronology() {
        if (cLenientISO == null) {
            cLenientISO = LenientChronology.getInstance(ISOChronology.getInstanceUTC());
        }
        return cLenientISO;
    }

    static DateTimeOfYear getStartOfYear() {
        if (cStartOfYear == null) {
            cStartOfYear = new DateTimeOfYear();
        }
        return cStartOfYear;
    }

    static int parseMonth(String a2) {
        DateTimeField dateTimeField = ISOChronology.getInstanceUTC().monthOfYear();
        return dateTimeField.get(dateTimeField.set(0L, a2, Locale.ENGLISH));
    }

    static int parseDayOfWeek(String a2) {
        DateTimeField dateTimeField = ISOChronology.getInstanceUTC().dayOfWeek();
        return dateTimeField.get(dateTimeField.set(0L, a2, Locale.ENGLISH));
    }

    public ZoneInfoCompiler() {
        this.iBackLinks = new ArrayList<String>();
    }

    public static void main(String[] arg0) throws Exception {
        int n;
        if (arg0.length == 0) {
            ZoneInfoCompiler.printUsage();
            return;
        }
        File file = null;
        File file2 = null;
        boolean bl = false;
        for (n = 0; n < arg0.length; ++n) {
            try {
                if ("-src".equals(arg0[n])) {
                    file = new File(arg0[++n]);
                    continue;
                }
                if ("-dst".equals(arg0[n])) {
                    file2 = new File(arg0[++n]);
                    continue;
                }
                if ("-verbose".equals(arg0[n])) {
                    bl = true;
                    continue;
                }
                if (!"-?".equals(arg0[n])) break;
                ZoneInfoCompiler.printUsage();
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ZoneInfoCompiler.printUsage();
                return;
            }
        }
        if (n >= arg0.length) {
            ZoneInfoCompiler.printUsage();
            return;
        }
        File[] fileArray = new File[arg0.length - n];
        int n2 = 0;
        while (n < arg0.length) {
            fileArray[n2] = file == null ? new File(arg0[n]) : new File(file, arg0[n]);
            ++n;
            ++n2;
        }
        ZoneInfoLogger.set(bl);
        ZoneInfoCompiler zoneInfoCompiler = new ZoneInfoCompiler();
        zoneInfoCompiler.compile(file2, fileArray);
    }

    public void parseDataFile(BufferedReader arg0, boolean arg1) throws IOException {
        String string;
        Zone zone = null;
        while ((string = arg0.readLine()) != null) {
            Object object;
            Object object2;
            String string2 = string.trim();
            if (string2.length() == 0 || string2.charAt(0) == '#') continue;
            int n = string.indexOf(35);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
            if (Character.isWhitespace(string.charAt(0)) && stringTokenizer.hasMoreTokens()) {
                if (zone == null) continue;
                zone.chain(stringTokenizer);
                continue;
            }
            if (zone != null) {
                this.iZones.add(zone);
            }
            zone = null;
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            if (string3.equalsIgnoreCase("Rule")) {
                object2 = new Rule(stringTokenizer);
                object = this.iRuleSets.get(((Rule)object2).iName);
                if (object == null) {
                    object = new RuleSet((Rule)object2);
                    this.iRuleSets.put(((Rule)object2).iName, (RuleSet)object);
                    continue;
                }
                ((RuleSet)object).addRule((Rule)object2);
                continue;
            }
            if (string3.equalsIgnoreCase("Zone")) {
                zone = new Zone(stringTokenizer);
                continue;
            }
            if (string3.equalsIgnoreCase("Link")) {
                object2 = stringTokenizer.nextToken();
                object = stringTokenizer.nextToken();
                if (arg1 || ((String)object).equals("US/Pacific-New") || ((String)object).startsWith("Etc/") || ((String)object).equals("GMT")) {
                    this.iBackLinks.add((String)object2);
                    this.iBackLinks.add((String)object);
                    continue;
                }
                this.iGoodLinks.add((String)object2);
                this.iGoodLinks.add((String)object);
                continue;
            }
            System.out.println("Unknown line: " + string);
        }
        if (zone != null) {
            this.iZones.add(zone);
        }
    }

    static int parseYear(String a2, int a3) {
        if ((a2 = a2.toLowerCase()).equals("minimum") || a2.equals("min")) {
            return Integer.MIN_VALUE;
        }
        if (a2.equals("maximum") || a2.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (a2.equals("only")) {
            return a3;
        }
        return Integer.parseInt(a2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZone(File a2, DateTimeZoneBuilder a3, DateTimeZone a4) throws IOException {
        File file;
        if (ZoneInfoLogger.verbose()) {
            System.out.println("Writing " + a4.getID());
        }
        if (!(file = new File(a2, a4.getID())).getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            a3.writeTo(a4.getID(), fileOutputStream);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        DateTimeZone dateTimeZone = DateTimeZoneBuilder.readFrom(fileInputStream, a4.getID());
        ((InputStream)fileInputStream).close();
        if (!a4.equals(dateTimeZone)) {
            System.out.println("*e* Error in " + a4.getID() + ": Didn't read properly from file");
        }
    }

    static void writeZoneInfoMap(DataOutputStream a2, Map<String, DateTimeZone> a3) throws IOException {
        String string;
        HashMap<String, Short> hashMap = new HashMap<String, Short>(a3.size());
        TreeMap<Short, String> treeMap = new TreeMap<Short, String>();
        short s = 0;
        for (Map.Entry<String, DateTimeZone> entry : a3.entrySet()) {
            Short s2;
            string = entry.getKey();
            if (!hashMap.containsKey(string)) {
                s2 = s;
                hashMap.put(string, s2);
                treeMap.put(s2, string);
                s = (short)(s + 1);
                if (s == 0) {
                    throw new InternalError("Too many time zone ids");
                }
            }
            if (hashMap.containsKey(string = entry.getValue().getID())) continue;
            s2 = s;
            hashMap.put(string, s2);
            treeMap.put(s2, string);
            if ((s = (short)(s + 1)) != 0) continue;
            throw new InternalError("Too many time zone ids");
        }
        a2.writeShort(treeMap.size());
        for (Map.Entry<String, DateTimeZone> entry : treeMap.values()) {
            a2.writeUTF((String)((Object)entry));
        }
        a2.writeShort(a3.size());
        for (Map.Entry<String, DateTimeZone> entry : a3.entrySet()) {
            string = entry.getKey();
            a2.writeShort(((Short)hashMap.get(string)).shortValue());
            string = entry.getValue().getID();
            a2.writeShort(((Short)hashMap.get(string)).shortValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Zone {
        public final DateTimeOfYear iUntilDateTimeOfYear;
        public final int iOffsetMillis;
        public final String iFormat;
        public final String iRules;
        private Zone iNext;
        public final String iName;
        public final int iUntilYear;

        Zone(StringTokenizer a2) {
            a3(a2.nextToken(), a2);
            Zone a3;
        }

        private static void addToBuilder(Zone a2, DateTimeZoneBuilder a3, Map<String, RuleSet> a4) {
            while (a2 != null) {
                a3.setStandardOffset(a2.iOffsetMillis);
                if (a2.iRules == null) {
                    a3.setFixedSavings(a2.iFormat, 0);
                } else {
                    try {
                        int n = ZoneInfoCompiler.parseTime(a2.iRules);
                        a3.setFixedSavings(a2.iFormat, n);
                    }
                    catch (Exception exception) {
                        RuleSet ruleSet = a4.get(a2.iRules);
                        if (ruleSet == null) {
                            throw new IllegalArgumentException("Rules not found: " + a2.iRules);
                        }
                        ruleSet.addRecurring(a3, a2.iFormat);
                    }
                }
                if (a2.iUntilYear == Integer.MAX_VALUE) break;
                a2.iUntilDateTimeOfYear.addCutover(a3, a2.iUntilYear);
                a2 = a2.iNext;
            }
        }

        void chain(StringTokenizer a2) {
            Zone a3;
            if (a3.iNext != null) {
                a3.iNext.chain(a2);
            } else {
                a3.iNext = new Zone(a3.iName, a2);
            }
        }

        public String toString() {
            String string = "[Zone]\nName: " + this.iName + "\n" + "OffsetMillis: " + this.iOffsetMillis + "\n" + "Rules: " + this.iRules + "\n" + "Format: " + this.iFormat + "\n" + "UntilYear: " + this.iUntilYear + "\n" + this.iUntilDateTimeOfYear;
            if (this.iNext == null) {
                return string;
            }
            return string + "...\n" + this.iNext.toString();
        }

        private Zone(String a2, StringTokenizer a3) {
            Zone a4;
            a4.iName = a2.intern();
            a4.iOffsetMillis = ZoneInfoCompiler.parseTime(a3.nextToken());
            a4.iRules = ZoneInfoCompiler.parseOptional(a3.nextToken());
            a4.iFormat = a3.nextToken().intern();
            int n = Integer.MAX_VALUE;
            DateTimeOfYear dateTimeOfYear = ZoneInfoCompiler.getStartOfYear();
            if (a3.hasMoreTokens()) {
                n = Integer.parseInt(a3.nextToken());
                if (a3.hasMoreTokens()) {
                    dateTimeOfYear = new DateTimeOfYear(a3);
                }
            }
            a4.iUntilYear = n;
            a4.iUntilDateTimeOfYear = dateTimeOfYear;
        }

        public void addToBuilder(DateTimeZoneBuilder arg0, Map<String, RuleSet> arg1) {
            Zone.addToBuilder(this, arg0, arg1);
        }
    }

    private static class RuleSet {
        private List<Rule> iRules = new ArrayList<Rule>();

        RuleSet(Rule a2) {
            RuleSet a3;
            a3.iRules.add(a2);
        }

        void addRule(Rule a2) {
            RuleSet a3;
            if (!a2.iName.equals(a3.iRules.get((int)0).iName)) {
                throw new IllegalArgumentException("Rule name mismatch");
            }
            a3.iRules.add(a2);
        }

        public void addRecurring(DateTimeZoneBuilder arg0, String arg1) {
            for (int i2 = 0; i2 < this.iRules.size(); ++i2) {
                Rule rule = this.iRules.get(i2);
                rule.addRecurring(arg0, arg1);
            }
        }
    }

    private static class Rule {
        public final int iSaveMillis;
        public final int iFromYear;
        public final int iToYear;
        public final String iLetterS;
        public final DateTimeOfYear iDateTimeOfYear;
        public final String iType;
        public final String iName;

        public void addRecurring(DateTimeZoneBuilder arg0, String arg1) {
            String string = this.formatName(arg1);
            this.iDateTimeOfYear.addRecurring(arg0, string, this.iSaveMillis, this.iFromYear, this.iToYear);
        }

        Rule(StringTokenizer a2) {
            Rule a3;
            if (a2.countTokens() < 6) {
                throw new IllegalArgumentException("Attempting to create a Rule from an incomplete tokenizer");
            }
            a3.iName = a2.nextToken().intern();
            a3.iFromYear = ZoneInfoCompiler.parseYear(a2.nextToken(), 0);
            a3.iToYear = ZoneInfoCompiler.parseYear(a2.nextToken(), a3.iFromYear);
            if (a3.iToYear < a3.iFromYear) {
                throw new IllegalArgumentException();
            }
            a3.iType = ZoneInfoCompiler.parseOptional(a2.nextToken());
            a3.iDateTimeOfYear = new DateTimeOfYear(a2);
            a3.iSaveMillis = ZoneInfoCompiler.parseTime(a2.nextToken());
            a3.iLetterS = ZoneInfoCompiler.parseOptional(a2.nextToken());
        }

        public String toString() {
            return "[Rule]\nName: " + this.iName + "\n" + "FromYear: " + this.iFromYear + "\n" + "ToYear: " + this.iToYear + "\n" + "Type: " + this.iType + "\n" + this.iDateTimeOfYear + "SaveMillis: " + this.iSaveMillis + "\n" + "LetterS: " + this.iLetterS + "\n";
        }

        private String formatName(String a2) {
            Rule a3;
            int n = a2.indexOf(47);
            if (n > 0) {
                if (a3.iSaveMillis == 0) {
                    return a2.substring(0, n).intern();
                }
                return a2.substring(n + 1).intern();
            }
            n = a2.indexOf("%s");
            if (n < 0) {
                return a2;
            }
            String string = a2.substring(0, n);
            String string2 = a2.substring(n + 2);
            String string3 = a3.iLetterS == null ? string.concat(string2) : string + a3.iLetterS + string2;
            return string3.intern();
        }
    }

    static class DateTimeOfYear {
        public final int iDayOfWeek;
        public final int iMillisOfDay;
        public final boolean iAdvanceDayOfWeek;
        public final int iMonthOfYear;
        public final int iDayOfMonth;
        public final char iZoneChar;

        public String toString() {
            return "MonthOfYear: " + this.iMonthOfYear + "\n" + "DayOfMonth: " + this.iDayOfMonth + "\n" + "DayOfWeek: " + this.iDayOfWeek + "\n" + "AdvanceDayOfWeek: " + this.iAdvanceDayOfWeek + "\n" + "MillisOfDay: " + this.iMillisOfDay + "\n" + "ZoneChar: " + this.iZoneChar + "\n";
        }

        public void addRecurring(DateTimeZoneBuilder arg0, String arg1, int arg2, int arg3, int arg4) {
            arg0.addRecurringSavings(arg1, arg2, arg3, arg4, this.iZoneChar, this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvanceDayOfWeek, this.iMillisOfDay);
        }

        public void addCutover(DateTimeZoneBuilder arg0, int arg1) {
            arg0.addCutover(arg1, this.iZoneChar, this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvanceDayOfWeek, this.iMillisOfDay);
        }

        DateTimeOfYear() {
            DateTimeOfYear a2;
            a2.iMonthOfYear = 1;
            a2.iDayOfMonth = 1;
            a2.iDayOfWeek = 0;
            a2.iAdvanceDayOfWeek = false;
            a2.iMillisOfDay = 0;
            a2.iZoneChar = (char)119;
        }

        DateTimeOfYear(StringTokenizer a2) {
            DateTimeOfYear a3;
            int n = 1;
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            int n5 = 119;
            if (a2.hasMoreTokens()) {
                n = ZoneInfoCompiler.parseMonth(a2.nextToken());
                if (a2.hasMoreTokens()) {
                    String string = a2.nextToken();
                    if (string.startsWith("last")) {
                        n2 = -1;
                        n3 = ZoneInfoCompiler.parseDayOfWeek(string.substring(4));
                        bl = false;
                    } else {
                        try {
                            n2 = Integer.parseInt(string);
                            n3 = 0;
                            bl = false;
                        }
                        catch (NumberFormatException numberFormatException) {
                            int n6 = string.indexOf(">=");
                            if (n6 > 0) {
                                n2 = Integer.parseInt(string.substring(n6 + 2));
                                n3 = ZoneInfoCompiler.parseDayOfWeek(string.substring(0, n6));
                                bl = true;
                            }
                            n6 = string.indexOf("<=");
                            if (n6 > 0) {
                                n2 = Integer.parseInt(string.substring(n6 + 2));
                                n3 = ZoneInfoCompiler.parseDayOfWeek(string.substring(0, n6));
                                bl = false;
                            }
                            throw new IllegalArgumentException(string);
                        }
                    }
                    if (a2.hasMoreTokens()) {
                        string = a2.nextToken();
                        n5 = ZoneInfoCompiler.parseZoneChar(string.charAt(string.length() - 1));
                        if (string.equals("24:00")) {
                            if (n == 12 && n2 == 31) {
                                n4 = ZoneInfoCompiler.parseTime("23:59:59.999");
                            } else {
                                LocalDate localDate = n2 == -1 ? new LocalDate(2001, n, 1).plusMonths(1) : new LocalDate(2001, n, n2).plusDays(1);
                                bl = n2 != -1 && n3 != 0;
                                n = localDate.getMonthOfYear();
                                n2 = localDate.getDayOfMonth();
                                if (n3 != 0) {
                                    n3 = (n3 - 1 + 1) % 7 + 1;
                                }
                            }
                        } else {
                            n4 = ZoneInfoCompiler.parseTime(string);
                        }
                    }
                }
            }
            a3.iMonthOfYear = n;
            a3.iDayOfMonth = n2;
            a3.iDayOfWeek = n3;
            a3.iAdvanceDayOfWeek = bl;
            a3.iMillisOfDay = n4;
            a3.iZoneChar = (char)n5;
        }
    }
}

