/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.tz.CachedDateTimeZone;
import org.joda.time.tz.FixedDateTimeZone;
import org.joda.time.tz.ZoneInfoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeZoneBuilder {
    private final ArrayList<RuleSet> iRuleSets = new ArrayList(10);

    public DateTimeZone toDateTimeZone(String arg0, boolean arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Transition> arrayList = new ArrayList<Transition>();
        DSTZone dSTZone = null;
        long l2 = Long.MIN_VALUE;
        int n = 0;
        int n2 = this.iRuleSets.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            RuleSet ruleSet = this.iRuleSets.get(i2);
            Transition transition = ruleSet.firstTransition(l2);
            if (transition == null) continue;
            this.addTransition(arrayList, transition);
            l2 = transition.getMillis();
            n = transition.getSaveMillis();
            ruleSet = new RuleSet(ruleSet);
            while (!((transition = ruleSet.nextTransition(l2, n)) == null || this.addTransition(arrayList, transition) && dSTZone != null)) {
                l2 = transition.getMillis();
                n = transition.getSaveMillis();
                if (dSTZone != null || i2 != n2 - 1) continue;
                dSTZone = ruleSet.buildTailZone(arg0);
            }
            l2 = ruleSet.getUpperLimit(n);
        }
        if (arrayList.size() == 0) {
            if (dSTZone != null) {
                return dSTZone;
            }
            return DateTimeZoneBuilder.buildFixedZone(arg0, "UTC", 0, 0);
        }
        if (arrayList.size() == 1 && dSTZone == null) {
            Transition transition = (Transition)arrayList.get(0);
            return DateTimeZoneBuilder.buildFixedZone(arg0, transition.getNameKey(), transition.getWallOffset(), transition.getStandardOffset());
        }
        PrecalculatedZone precalculatedZone = PrecalculatedZone.create(arg0, arg1, arrayList, dSTZone);
        if (precalculatedZone.isCachable()) {
            return CachedDateTimeZone.forZone(precalculatedZone);
        }
        return precalculatedZone;
    }

    static void writeMillis(DataOutput a2, long a3) throws IOException {
        long l2;
        if (a3 % 1800000L == 0L && (l2 = a3 / 1800000L) << 58 >> 58 == l2) {
            a2.writeByte((int)(l2 & 0x3FL));
            return;
        }
        if (a3 % 60000L == 0L && (l2 = a3 / 60000L) << 34 >> 34 == l2) {
            a2.writeInt(0x40000000 | (int)(l2 & 0x3FFFFFFFL));
            return;
        }
        if (a3 % 1000L == 0L && (l2 = a3 / 1000L) << 26 >> 26 == l2) {
            a2.writeByte(0x80 | (int)(l2 >> 32 & 0x3FL));
            a2.writeInt((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
            return;
        }
        a2.writeByte(a3 < 0L ? 255 : 192);
        a2.writeLong(a3);
    }

    static long readMillis(DataInput a2) throws IOException {
        int n = a2.readUnsignedByte();
        switch (n >> 6) {
            default: {
                n = n << 26 >> 26;
                return (long)n * 1800000L;
            }
            case 1: {
                n = n << 26 >> 2;
                n |= a2.readUnsignedByte() << 16;
                n |= a2.readUnsignedByte() << 8;
                return (long)(n |= a2.readUnsignedByte()) * 60000L;
            }
            case 2: {
                long l2 = (long)n << 58 >> 26;
                l2 |= (long)(a2.readUnsignedByte() << 24);
                l2 |= (long)(a2.readUnsignedByte() << 16);
                l2 |= (long)(a2.readUnsignedByte() << 8);
                return (l2 |= (long)a2.readUnsignedByte()) * 1000L;
            }
            case 3: 
        }
        return a2.readLong();
    }

    private static DateTimeZone buildFixedZone(String a2, String a3, int a4, int a5) {
        if ("UTC".equals(a2) && a2.equals(a3) && a4 == 0 && a5 == 0) {
            return DateTimeZone.UTC;
        }
        return new FixedDateTimeZone(a2, a3, a4, a5);
    }

    public void writeTo(String arg0, DataOutput arg1) throws IOException {
        DateTimeZone dateTimeZone = this.toDateTimeZone(arg0, false);
        if (dateTimeZone instanceof FixedDateTimeZone) {
            arg1.writeByte(70);
            arg1.writeUTF(dateTimeZone.getNameKey(0L));
            DateTimeZoneBuilder.writeMillis(arg1, dateTimeZone.getOffset(0L));
            DateTimeZoneBuilder.writeMillis(arg1, dateTimeZone.getStandardOffset(0L));
        } else {
            if (dateTimeZone instanceof CachedDateTimeZone) {
                arg1.writeByte(67);
                dateTimeZone = ((CachedDateTimeZone)dateTimeZone).getUncachedZone();
            } else {
                arg1.writeByte(80);
            }
            ((PrecalculatedZone)dateTimeZone).writeTo(arg1);
        }
    }

    public void writeTo(String arg0, OutputStream arg1) throws IOException {
        if (arg1 instanceof DataOutput) {
            this.writeTo(arg0, (DataOutput)((Object)arg1));
        } else {
            this.writeTo(arg0, new DataOutputStream(arg1));
        }
    }

    public DateTimeZoneBuilder setStandardOffset(int arg0) {
        this.getLastRuleSet().setStandardOffset(arg0);
        return this;
    }

    private boolean addTransition(ArrayList<Transition> a2, Transition a3) {
        DateTimeZoneBuilder a4;
        int n = a2.size();
        if (n == 0) {
            a2.add(a3);
            return true;
        }
        Transition transition = a2.get(n - 1);
        if (!a3.isTransitionFrom(transition)) {
            return false;
        }
        int n2 = 0;
        if (n >= 2) {
            n2 = a2.get(n - 2).getWallOffset();
        }
        int n3 = transition.getWallOffset();
        long l2 = transition.getMillis() + (long)n2;
        long l3 = a3.getMillis() + (long)n3;
        if (l3 != l2) {
            a2.add(a3);
            return true;
        }
        a2.remove(n - 1);
        return a4.addTransition(a2, a3);
    }

    public DateTimeZoneBuilder setFixedSavings(String arg0, int arg1) {
        this.getLastRuleSet().setFixedSavings(arg0, arg1);
        return this;
    }

    public static DateTimeZone readFrom(DataInput arg0, String arg1) throws IOException {
        switch (arg0.readUnsignedByte()) {
            case 70: {
                DateTimeZone dateTimeZone = new FixedDateTimeZone(arg1, arg0.readUTF(), (int)DateTimeZoneBuilder.readMillis(arg0), (int)DateTimeZoneBuilder.readMillis(arg0));
                if (((DateTimeZone)dateTimeZone).equals(DateTimeZone.UTC)) {
                    dateTimeZone = DateTimeZone.UTC;
                }
                return dateTimeZone;
            }
            case 67: {
                return CachedDateTimeZone.forZone(PrecalculatedZone.readFrom(arg0, arg1));
            }
            case 80: {
                return PrecalculatedZone.readFrom(arg0, arg1);
            }
        }
        throw new IOException("Invalid encoding");
    }

    public DateTimeZoneBuilder addRecurringSavings(String arg0, int arg1, int arg2, int arg3, char arg4, int arg5, int arg6, int arg7, boolean arg8, int arg9) {
        if (arg2 <= arg3) {
            OfYear ofYear = new OfYear(arg4, arg5, arg6, arg7, arg8, arg9);
            Recurrence recurrence = new Recurrence(ofYear, arg0, arg1);
            Rule rule = new Rule(recurrence, arg2, arg3);
            this.getLastRuleSet().addRule(rule);
        }
        return this;
    }

    public static DateTimeZone readFrom(InputStream arg0, String arg1) throws IOException {
        if (arg0 instanceof DataInput) {
            return DateTimeZoneBuilder.readFrom((DataInput)((Object)arg0), arg1);
        }
        return DateTimeZoneBuilder.readFrom(new DataInputStream(arg0), arg1);
    }

    private RuleSet getLastRuleSet() {
        DateTimeZoneBuilder a2;
        if (a2.iRuleSets.size() == 0) {
            a2.addCutover(Integer.MIN_VALUE, 'w', 1, 1, 0, false, 0);
        }
        return a2.iRuleSets.get(a2.iRuleSets.size() - 1);
    }

    public DateTimeZoneBuilder addCutover(int arg0, char arg1, int arg2, int arg3, int arg4, boolean arg5, int arg6) {
        if (this.iRuleSets.size() > 0) {
            OfYear ofYear = new OfYear(arg1, arg2, arg3, arg4, arg5, arg6);
            RuleSet ruleSet = this.iRuleSets.get(this.iRuleSets.size() - 1);
            ruleSet.setUpperLimit(arg0, ofYear);
        }
        this.iRuleSets.add(new RuleSet());
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PrecalculatedZone
    extends DateTimeZone {
        private final long[] iTransitions;
        private final String[] iNameKeys;
        private static final long serialVersionUID = 7811976468055766265L;
        private final int[] iWallOffsets;
        private final int[] iStandardOffsets;
        private final DSTZone iTailZone;

        static PrecalculatedZone create(String a2, boolean a3, ArrayList<Transition> a4, DSTZone a5) {
            String[][] stringArray;
            int n = a4.size();
            if (n == 0) {
                throw new IllegalArgumentException();
            }
            long[] lArray = new long[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            String[] stringArray2 = new String[n];
            String[][] stringArray3 = null;
            for (int i2 = 0; i2 < n; ++i2) {
                stringArray = a4.get(i2);
                if (!stringArray.isTransitionFrom((Transition)stringArray3)) {
                    throw new IllegalArgumentException(a2);
                }
                lArray[i2] = stringArray.getMillis();
                nArray[i2] = stringArray.getWallOffset();
                nArray2[i2] = stringArray.getStandardOffset();
                stringArray2[i2] = stringArray.getNameKey();
                stringArray3 = stringArray;
            }
            String[] stringArray4 = new String[5];
            stringArray = new DateFormatSymbols(Locale.ENGLISH).getZoneStrings();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                String[] stringArray5 = stringArray[i3];
                if (stringArray5 == null || stringArray5.length != 5 || !a2.equals(stringArray5[0])) continue;
                stringArray4 = stringArray5;
            }
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            for (int i4 = 0; i4 < stringArray2.length - 1; ++i4) {
                String string = stringArray2[i4];
                String string2 = stringArray2[i4 + 1];
                long l2 = nArray[i4];
                long l3 = nArray[i4 + 1];
                long l4 = nArray2[i4];
                long l5 = nArray2[i4 + 1];
                Period period = new Period(lArray[i4], lArray[i4 + 1], PeriodType.yearMonthDay(), iSOChronology);
                if (l2 == l3 || l4 != l5 || !string.equals(string2) || period.getYears() != 0 || period.getMonths() <= 4 || period.getMonths() >= 8 || !string.equals(stringArray4[2]) || !string.equals(stringArray4[4])) continue;
                if (ZoneInfoLogger.verbose()) {
                    System.out.println("Fixing duplicate name key - " + string2);
                    System.out.println("     - " + new DateTime(lArray[i4], (Chronology)iSOChronology) + " - " + new DateTime(lArray[i4 + 1], (Chronology)iSOChronology));
                }
                if (l2 > l3) {
                    stringArray2[i4] = (string + "-Summer").intern();
                    continue;
                }
                if (l2 >= l3) continue;
                stringArray2[i4 + 1] = (string2 + "-Summer").intern();
                ++i4;
            }
            if (a5 != null && a5.iStartRecurrence.getNameKey().equals(a5.iEndRecurrence.getNameKey())) {
                if (ZoneInfoLogger.verbose()) {
                    System.out.println("Fixing duplicate recurrent name key - " + a5.iStartRecurrence.getNameKey());
                }
                a5 = a5.iStartRecurrence.getSaveMillis() > 0 ? new DSTZone(a5.getID(), a5.iStandardOffset, a5.iStartRecurrence.renameAppend("-Summer"), a5.iEndRecurrence) : new DSTZone(a5.getID(), a5.iStandardOffset, a5.iStartRecurrence, a5.iEndRecurrence.renameAppend("-Summer"));
            }
            return new PrecalculatedZone(a3 ? a2 : "", lArray, nArray, nArray2, stringArray2, a5);
        }

        @Override
        public String getNameKey(long arg0) {
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(lArray, arg0);
            if (n >= 0) {
                return this.iNameKeys[n];
            }
            if ((n ^= 0xFFFFFFFF) < lArray.length) {
                if (n > 0) {
                    return this.iNameKeys[n - 1];
                }
                return "UTC";
            }
            if (this.iTailZone == null) {
                return this.iNameKeys[n - 1];
            }
            return this.iTailZone.getNameKey(arg0);
        }

        @Override
        public boolean isFixed() {
            return false;
        }

        public void writeTo(DataOutput arg0) throws IOException {
            int n;
            int n2 = this.iTransitions.length;
            HashSet<String> hashSet = new HashSet<String>();
            for (n = 0; n < n2; ++n) {
                hashSet.add(this.iNameKeys[n]);
            }
            n = hashSet.size();
            if (n > 65535) {
                throw new UnsupportedOperationException("String pool is too large");
            }
            String[] stringArray = new String[n];
            Iterator iterator = hashSet.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                stringArray[n3] = (String)iterator.next();
                ++n3;
            }
            arg0.writeShort(n);
            for (n3 = 0; n3 < n; ++n3) {
                arg0.writeUTF(stringArray[n3]);
            }
            arg0.writeInt(n2);
            block3: for (n3 = 0; n3 < n2; ++n3) {
                DateTimeZoneBuilder.writeMillis(arg0, this.iTransitions[n3]);
                DateTimeZoneBuilder.writeMillis(arg0, this.iWallOffsets[n3]);
                DateTimeZoneBuilder.writeMillis(arg0, this.iStandardOffsets[n3]);
                String string = this.iNameKeys[n3];
                for (int i2 = 0; i2 < n; ++i2) {
                    if (!stringArray[i2].equals(string)) continue;
                    if (n < 256) {
                        arg0.writeByte(i2);
                        continue block3;
                    }
                    arg0.writeShort(i2);
                    continue block3;
                }
            }
            arg0.writeBoolean(this.iTailZone != null);
            if (this.iTailZone != null) {
                this.iTailZone.writeTo(arg0);
            }
        }

        @Override
        public long nextTransition(long arg0) {
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(lArray, arg0);
            int n2 = n = n >= 0 ? n + 1 : ~n;
            if (n < lArray.length) {
                return lArray[n];
            }
            if (this.iTailZone == null) {
                return arg0;
            }
            long l2 = lArray[lArray.length - 1];
            if (arg0 < l2) {
                arg0 = l2;
            }
            return this.iTailZone.nextTransition(arg0);
        }

        static PrecalculatedZone readFrom(DataInput a2, String a3) throws IOException {
            int n;
            int n2 = a2.readUnsignedShort();
            String[] stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = a2.readUTF();
            }
            n = a2.readInt();
            long[] lArray = new long[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            String[] stringArray2 = new String[n];
            for (int i2 = 0; i2 < n; ++i2) {
                lArray[i2] = DateTimeZoneBuilder.readMillis(a2);
                nArray[i2] = (int)DateTimeZoneBuilder.readMillis(a2);
                nArray2[i2] = (int)DateTimeZoneBuilder.readMillis(a2);
                try {
                    int n3 = n2 < 256 ? a2.readUnsignedByte() : a2.readUnsignedShort();
                    stringArray2[i2] = stringArray[n3];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IOException("Invalid encoding");
                }
            }
            DSTZone dSTZone = null;
            if (a2.readBoolean()) {
                dSTZone = DSTZone.readFrom(a2, a3);
            }
            return new PrecalculatedZone(a3, lArray, nArray, nArray2, stringArray2, dSTZone);
        }

        @Override
        public int getStandardOffset(long arg0) {
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(lArray, arg0);
            if (n >= 0) {
                return this.iStandardOffsets[n];
            }
            if ((n ^= 0xFFFFFFFF) < lArray.length) {
                if (n > 0) {
                    return this.iStandardOffsets[n - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iStandardOffsets[n - 1];
            }
            return this.iTailZone.getStandardOffset(arg0);
        }

        @Override
        public int getOffset(long arg0) {
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(lArray, arg0);
            if (n >= 0) {
                return this.iWallOffsets[n];
            }
            if ((n ^= 0xFFFFFFFF) < lArray.length) {
                if (n > 0) {
                    return this.iWallOffsets[n - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iWallOffsets[n - 1];
            }
            return this.iTailZone.getOffset(arg0);
        }

        private PrecalculatedZone(String a2, long[] a3, int[] a4, int[] a5, String[] a6, DSTZone a7) {
            super(a2);
            PrecalculatedZone a8;
            a8.iTransitions = a3;
            a8.iWallOffsets = a4;
            a8.iStandardOffsets = a5;
            a8.iNameKeys = a6;
            a8.iTailZone = a7;
        }

        @Override
        public boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 instanceof PrecalculatedZone) {
                PrecalculatedZone precalculatedZone = (PrecalculatedZone)arg0;
                return this.getID().equals(precalculatedZone.getID()) && Arrays.equals(this.iTransitions, precalculatedZone.iTransitions) && Arrays.equals(this.iNameKeys, precalculatedZone.iNameKeys) && Arrays.equals(this.iWallOffsets, precalculatedZone.iWallOffsets) && Arrays.equals(this.iStandardOffsets, precalculatedZone.iStandardOffsets) && (this.iTailZone == null ? null == precalculatedZone.iTailZone : this.iTailZone.equals(precalculatedZone.iTailZone));
            }
            return false;
        }

        public boolean isCachable() {
            if (this.iTailZone != null) {
                return true;
            }
            long[] lArray = this.iTransitions;
            if (lArray.length <= 1) {
                return false;
            }
            double d2 = 0.0;
            int n = 0;
            for (int i2 = 1; i2 < lArray.length; ++i2) {
                long l2 = lArray[i2] - lArray[i2 - 1];
                if (l2 >= 63158400000L) continue;
                d2 += (double)l2;
                ++n;
            }
            if (n > 0) {
                double d3 = d2 / (double)n;
                if ((d3 /= 8.64E7) >= 25.0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public long previousTransition(long arg0) {
            long l2;
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(lArray, arg0);
            if (n >= 0) {
                if (arg0 > Long.MIN_VALUE) {
                    return arg0 - 1L;
                }
                return arg0;
            }
            if ((n ^= 0xFFFFFFFF) < lArray.length) {
                long l3;
                if (n > 0 && (l3 = lArray[n - 1]) > Long.MIN_VALUE) {
                    return l3 - 1L;
                }
                return arg0;
            }
            if (this.iTailZone != null && (l2 = this.iTailZone.previousTransition(arg0)) < arg0) {
                return l2;
            }
            l2 = lArray[n - 1];
            if (l2 > Long.MIN_VALUE) {
                return l2 - 1L;
            }
            return arg0;
        }
    }

    private static final class DSTZone
    extends DateTimeZone {
        final Recurrence iEndRecurrence;
        final int iStandardOffset;
        final Recurrence iStartRecurrence;
        private static final long serialVersionUID = 6941492635554961361L;

        public long nextTransition(long arg0) {
            long l2;
            long l3;
            int n = this.iStandardOffset;
            Recurrence recurrence = this.iStartRecurrence;
            Recurrence recurrence2 = this.iEndRecurrence;
            try {
                l3 = recurrence.next(arg0, n, recurrence2.getSaveMillis());
                if (arg0 > 0L && l3 < 0L) {
                    l3 = arg0;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = arg0;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = arg0;
            }
            try {
                l2 = recurrence2.next(arg0, n, recurrence.getSaveMillis());
                if (arg0 > 0L && l2 < 0L) {
                    l2 = arg0;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l2 = arg0;
            }
            catch (ArithmeticException arithmeticException) {
                l2 = arg0;
            }
            return l3 > l2 ? l2 : l3;
        }

        public void writeTo(DataOutput arg0) throws IOException {
            DateTimeZoneBuilder.writeMillis(arg0, this.iStandardOffset);
            this.iStartRecurrence.writeTo(arg0);
            this.iEndRecurrence.writeTo(arg0);
        }

        public String getNameKey(long arg0) {
            return this.findMatchingRecurrence(arg0).getNameKey();
        }

        public int getOffset(long arg0) {
            return this.iStandardOffset + this.findMatchingRecurrence(arg0).getSaveMillis();
        }

        public long previousTransition(long arg0) {
            long l2;
            long l3;
            ++arg0;
            int n = this.iStandardOffset;
            Recurrence recurrence = this.iStartRecurrence;
            Recurrence recurrence2 = this.iEndRecurrence;
            try {
                l3 = recurrence.previous(arg0, n, recurrence2.getSaveMillis());
                if (arg0 < 0L && l3 > 0L) {
                    l3 = arg0;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = arg0;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = arg0;
            }
            try {
                l2 = recurrence2.previous(arg0, n, recurrence.getSaveMillis());
                if (arg0 < 0L && l2 > 0L) {
                    l2 = arg0;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l2 = arg0;
            }
            catch (ArithmeticException arithmeticException) {
                l2 = arg0;
            }
            return (l3 > l2 ? l3 : l2) - 1L;
        }

        static DSTZone readFrom(DataInput a2, String a3) throws IOException {
            return new DSTZone(a3, (int)DateTimeZoneBuilder.readMillis(a2), Recurrence.readFrom(a2), Recurrence.readFrom(a2));
        }

        DSTZone(String a2, int a3, Recurrence a4, Recurrence a5) {
            super(a2);
            DSTZone a6;
            a6.iStandardOffset = a3;
            a6.iStartRecurrence = a4;
            a6.iEndRecurrence = a5;
        }

        public boolean isFixed() {
            return false;
        }

        private Recurrence findMatchingRecurrence(long a2) {
            long l2;
            long l3;
            DSTZone a3;
            int n = a3.iStandardOffset;
            Recurrence recurrence = a3.iStartRecurrence;
            Recurrence recurrence2 = a3.iEndRecurrence;
            try {
                l3 = recurrence.next(a2, n, recurrence2.getSaveMillis());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = a2;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = a2;
            }
            try {
                l2 = recurrence2.next(a2, n, recurrence.getSaveMillis());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l2 = a2;
            }
            catch (ArithmeticException arithmeticException) {
                l2 = a2;
            }
            return l3 > l2 ? recurrence : recurrence2;
        }

        public boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 instanceof DSTZone) {
                DSTZone dSTZone = (DSTZone)arg0;
                return this.getID().equals(dSTZone.getID()) && this.iStandardOffset == dSTZone.iStandardOffset && this.iStartRecurrence.equals(dSTZone.iStartRecurrence) && this.iEndRecurrence.equals(dSTZone.iEndRecurrence);
            }
            return false;
        }

        public int getStandardOffset(long arg0) {
            return this.iStandardOffset;
        }
    }

    private static final class RuleSet {
        private int iInitialSaveMillis;
        private static final int YEAR_LIMIT;
        private OfYear iUpperOfYear;
        private ArrayList<Rule> iRules;
        private String iInitialNameKey;
        private int iStandardOffset;
        private int iUpperYear;

        public void setFixedSavings(String arg0, int arg1) {
            this.iInitialNameKey = arg0;
            this.iInitialSaveMillis = arg1;
        }

        public int getStandardOffset() {
            return this.iStandardOffset;
        }

        public void setStandardOffset(int arg0) {
            this.iStandardOffset = arg0;
        }

        RuleSet(RuleSet a2) {
            RuleSet a3;
            a3.iStandardOffset = a2.iStandardOffset;
            a3.iRules = new ArrayList<Rule>(a2.iRules);
            a3.iInitialNameKey = a2.iInitialNameKey;
            a3.iInitialSaveMillis = a2.iInitialSaveMillis;
            a3.iUpperYear = a2.iUpperYear;
            a3.iUpperOfYear = a2.iUpperOfYear;
        }

        public long getUpperLimit(int arg0) {
            if (this.iUpperYear == Integer.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            return this.iUpperOfYear.setInstant(this.iUpperYear, this.iStandardOffset, arg0);
        }

        public Transition nextTransition(long arg0, int arg1) {
            long l2;
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            Rule rule = null;
            long l3 = Long.MAX_VALUE;
            Iterator<Rule> iterator = this.iRules.iterator();
            while (iterator.hasNext()) {
                Rule rule2 = iterator.next();
                long l4 = rule2.next(arg0, this.iStandardOffset, arg1);
                if (l4 <= arg0) {
                    iterator.remove();
                    continue;
                }
                if (l4 > l3) continue;
                rule = rule2;
                l3 = l4;
            }
            if (rule == null) {
                return null;
            }
            if (((Chronology)iSOChronology).year().get(l3) >= YEAR_LIMIT) {
                return null;
            }
            if (this.iUpperYear < Integer.MAX_VALUE && l3 >= (l2 = this.iUpperOfYear.setInstant(this.iUpperYear, this.iStandardOffset, arg1))) {
                return null;
            }
            return new Transition(l3, rule, this.iStandardOffset);
        }

        public Transition firstTransition(long arg0) {
            Transition transition;
            if (this.iInitialNameKey != null) {
                return new Transition(arg0, this.iInitialNameKey, this.iStandardOffset + this.iInitialSaveMillis, this.iStandardOffset);
            }
            ArrayList<Rule> arrayList = new ArrayList<Rule>(this.iRules);
            long l2 = Long.MIN_VALUE;
            int n = 0;
            Transition transition2 = null;
            while ((transition = this.nextTransition(l2, n)) != null) {
                l2 = transition.getMillis();
                if (l2 == arg0) {
                    transition2 = new Transition(arg0, transition);
                    break;
                }
                if (l2 > arg0) {
                    if (transition2 == null) {
                        for (Rule rule : arrayList) {
                            if (rule.getSaveMillis() != 0) continue;
                            transition2 = new Transition(arg0, rule, this.iStandardOffset);
                            break;
                        }
                    }
                    if (transition2 != null) break;
                    transition2 = new Transition(arg0, transition.getNameKey(), this.iStandardOffset, this.iStandardOffset);
                    break;
                }
                transition2 = new Transition(arg0, transition);
                n = transition.getSaveMillis();
            }
            this.iRules = arrayList;
            return transition2;
        }

        public DSTZone buildTailZone(String arg0) {
            if (this.iRules.size() == 2) {
                Rule rule = this.iRules.get(0);
                Rule rule2 = this.iRules.get(1);
                if (rule.getToYear() == Integer.MAX_VALUE && rule2.getToYear() == Integer.MAX_VALUE) {
                    return new DSTZone(arg0, this.iStandardOffset, rule.iRecurrence, rule2.iRecurrence);
                }
            }
            return null;
        }

        public void addRule(Rule arg0) {
            if (!this.iRules.contains(arg0)) {
                this.iRules.add(arg0);
            }
        }

        static {
            long l2 = DateTimeUtils.currentTimeMillis();
            YEAR_LIMIT = ISOChronology.getInstanceUTC().year().get(l2) + 100;
        }

        public void setUpperLimit(int arg0, OfYear arg1) {
            this.iUpperYear = arg0;
            this.iUpperOfYear = arg1;
        }

        RuleSet() {
            RuleSet a2;
            a2.iRules = new ArrayList(10);
            a2.iUpperYear = Integer.MAX_VALUE;
        }
    }

    private static final class Transition {
        private final long iMillis;
        private final int iStandardOffset;
        private final String iNameKey;
        private final int iWallOffset;

        Transition(long a2, Transition a3) {
            Transition a4;
            a4.iMillis = a2;
            a4.iNameKey = a3.iNameKey;
            a4.iWallOffset = a3.iWallOffset;
            a4.iStandardOffset = a3.iStandardOffset;
        }

        public int getWallOffset() {
            return this.iWallOffset;
        }

        public int getSaveMillis() {
            return this.iWallOffset - this.iStandardOffset;
        }

        public long getMillis() {
            return this.iMillis;
        }

        public String getNameKey() {
            return this.iNameKey;
        }

        Transition(long a2, String a3, int a4, int a5) {
            Transition a6;
            a6.iMillis = a2;
            a6.iNameKey = a3;
            a6.iWallOffset = a4;
            a6.iStandardOffset = a5;
        }

        public boolean isTransitionFrom(Transition arg0) {
            if (arg0 == null) {
                return true;
            }
            return this.iMillis > arg0.iMillis && (this.iWallOffset != arg0.iWallOffset || !this.iNameKey.equals(arg0.iNameKey));
        }

        public int getStandardOffset() {
            return this.iStandardOffset;
        }

        Transition(long a2, Rule a3, int a4) {
            Transition a5;
            a5.iMillis = a2;
            a5.iNameKey = a3.getNameKey();
            a5.iWallOffset = a4 + a3.getSaveMillis();
            a5.iStandardOffset = a4;
        }
    }

    private static final class Rule {
        final Recurrence iRecurrence;
        final int iToYear;
        final int iFromYear;

        public int getSaveMillis() {
            return this.iRecurrence.getSaveMillis();
        }

        Rule(Recurrence a2, int a3, int a4) {
            Rule a5;
            a5.iRecurrence = a2;
            a5.iFromYear = a3;
            a5.iToYear = a4;
        }

        public int getFromYear() {
            return this.iFromYear;
        }

        public int getToYear() {
            return this.iToYear;
        }

        public String getNameKey() {
            return this.iRecurrence.getNameKey();
        }

        public OfYear getOfYear() {
            return this.iRecurrence.getOfYear();
        }

        public long next(long arg0, int arg1, int arg2) {
            long l2;
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            int n = arg1 + arg2;
            long l3 = arg0;
            int n2 = arg0 == Long.MIN_VALUE ? Integer.MIN_VALUE : ((Chronology)iSOChronology).year().get(arg0 + (long)n);
            if (n2 < this.iFromYear) {
                l3 = ((Chronology)iSOChronology).year().set(0L, this.iFromYear) - (long)n;
                --l3;
            }
            if ((l2 = this.iRecurrence.next(l3, arg1, arg2)) > arg0 && (n2 = ((Chronology)iSOChronology).year().get(l2 + (long)n)) > this.iToYear) {
                l2 = arg0;
            }
            return l2;
        }
    }

    private static final class Recurrence {
        final OfYear iOfYear;
        final int iSaveMillis;
        final String iNameKey;

        public long previous(long arg0, int arg1, int arg2) {
            return this.iOfYear.previous(arg0, arg1, arg2);
        }

        Recurrence(OfYear a2, String a3, int a4) {
            Recurrence a5;
            a5.iOfYear = a2;
            a5.iNameKey = a3;
            a5.iSaveMillis = a4;
        }

        public boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 instanceof Recurrence) {
                Recurrence recurrence = (Recurrence)arg0;
                return this.iSaveMillis == recurrence.iSaveMillis && this.iNameKey.equals(recurrence.iNameKey) && this.iOfYear.equals(recurrence.iOfYear);
            }
            return false;
        }

        Recurrence renameAppend(String a2) {
            Recurrence a3;
            return a3.rename((a3.iNameKey + a2).intern());
        }

        static Recurrence readFrom(DataInput a2) throws IOException {
            return new Recurrence(OfYear.readFrom(a2), a2.readUTF(), (int)DateTimeZoneBuilder.readMillis(a2));
        }

        public int getSaveMillis() {
            return this.iSaveMillis;
        }

        public OfYear getOfYear() {
            return this.iOfYear;
        }

        Recurrence rename(String a2) {
            Recurrence a3;
            return new Recurrence(a3.iOfYear, a2, a3.iSaveMillis);
        }

        public String getNameKey() {
            return this.iNameKey;
        }

        public void writeTo(DataOutput arg0) throws IOException {
            this.iOfYear.writeTo(arg0);
            arg0.writeUTF(this.iNameKey);
            DateTimeZoneBuilder.writeMillis(arg0, this.iSaveMillis);
        }

        public long next(long arg0, int arg1, int arg2) {
            return this.iOfYear.next(arg0, arg1, arg2);
        }
    }

    private static final class OfYear {
        final char iMode;
        final int iDayOfMonth;
        final int iMillisOfDay;
        final int iMonthOfYear;
        final int iDayOfWeek;
        final boolean iAdvance;

        public boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 instanceof OfYear) {
                OfYear ofYear = (OfYear)arg0;
                return this.iMode == ofYear.iMode && this.iMonthOfYear == ofYear.iMonthOfYear && this.iDayOfMonth == ofYear.iDayOfMonth && this.iDayOfWeek == ofYear.iDayOfWeek && this.iAdvance == ofYear.iAdvance && this.iMillisOfDay == ofYear.iMillisOfDay;
            }
            return false;
        }

        private long setDayOfMonth(Chronology a2, long a3) {
            OfYear a4;
            if (a4.iDayOfMonth >= 0) {
                a3 = a2.dayOfMonth().set(a3, a4.iDayOfMonth);
            } else {
                a3 = a2.dayOfMonth().set(a3, 1);
                a3 = a2.monthOfYear().add(a3, 1);
                a3 = a2.dayOfMonth().add(a3, a4.iDayOfMonth);
            }
            return a3;
        }

        public void writeTo(DataOutput arg0) throws IOException {
            arg0.writeByte(this.iMode);
            arg0.writeByte(this.iMonthOfYear);
            arg0.writeByte(this.iDayOfMonth);
            arg0.writeByte(this.iDayOfWeek);
            arg0.writeBoolean(this.iAdvance);
            DateTimeZoneBuilder.writeMillis(arg0, this.iMillisOfDay);
        }

        private long setDayOfMonthNext(Chronology a2, long a3) {
            OfYear a4;
            try {
                a3 = a4.setDayOfMonth(a2, a3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (a4.iMonthOfYear == 2 && a4.iDayOfMonth == 29) {
                    while (!a2.year().isLeap(a3)) {
                        a3 = a2.year().add(a3, 1);
                    }
                    a3 = a4.setDayOfMonth(a2, a3);
                }
                throw illegalArgumentException;
            }
            return a3;
        }

        public long previous(long arg0, int arg1, int arg2) {
            int n = this.iMode == 'w' ? arg1 + arg2 : (this.iMode == 's' ? arg1 : 0);
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l2 = ((Chronology)iSOChronology).monthOfYear().set(arg0 += (long)n, this.iMonthOfYear);
            l2 = ((Chronology)iSOChronology).millisOfDay().set(l2, 0);
            l2 = ((Chronology)iSOChronology).millisOfDay().add(l2, this.iMillisOfDay);
            l2 = this.setDayOfMonthPrevious(iSOChronology, l2);
            if (this.iDayOfWeek == 0) {
                if (l2 >= arg0) {
                    l2 = ((Chronology)iSOChronology).year().add(l2, -1);
                    l2 = this.setDayOfMonthPrevious(iSOChronology, l2);
                }
            } else if ((l2 = this.setDayOfWeek(iSOChronology, l2)) >= arg0) {
                l2 = ((Chronology)iSOChronology).year().add(l2, -1);
                l2 = ((Chronology)iSOChronology).monthOfYear().set(l2, this.iMonthOfYear);
                l2 = this.setDayOfMonthPrevious(iSOChronology, l2);
                l2 = this.setDayOfWeek(iSOChronology, l2);
            }
            return l2 - (long)n;
        }

        static OfYear readFrom(DataInput a2) throws IOException {
            return new OfYear((char)a2.readUnsignedByte(), a2.readUnsignedByte(), a2.readByte(), a2.readUnsignedByte(), a2.readBoolean(), (int)DateTimeZoneBuilder.readMillis(a2));
        }

        private long setDayOfWeek(Chronology a2, long a3) {
            OfYear a4;
            int n = a2.dayOfWeek().get(a3);
            int n2 = a4.iDayOfWeek - n;
            if (n2 != 0) {
                if (a4.iAdvance) {
                    if (n2 < 0) {
                        n2 += 7;
                    }
                } else if (n2 > 0) {
                    n2 -= 7;
                }
                a3 = a2.dayOfWeek().add(a3, n2);
            }
            return a3;
        }

        private long setDayOfMonthPrevious(Chronology a2, long a3) {
            OfYear a4;
            try {
                a3 = a4.setDayOfMonth(a2, a3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (a4.iMonthOfYear == 2 && a4.iDayOfMonth == 29) {
                    while (!a2.year().isLeap(a3)) {
                        a3 = a2.year().add(a3, -1);
                    }
                    a3 = a4.setDayOfMonth(a2, a3);
                }
                throw illegalArgumentException;
            }
            return a3;
        }

        public long setInstant(int arg0, int arg1, int arg2) {
            int n = this.iMode == 'w' ? arg1 + arg2 : (this.iMode == 's' ? arg1 : 0);
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l2 = ((Chronology)iSOChronology).year().set(0L, arg0);
            l2 = ((Chronology)iSOChronology).monthOfYear().set(l2, this.iMonthOfYear);
            l2 = ((Chronology)iSOChronology).millisOfDay().set(l2, this.iMillisOfDay);
            l2 = this.setDayOfMonth(iSOChronology, l2);
            if (this.iDayOfWeek != 0) {
                l2 = this.setDayOfWeek(iSOChronology, l2);
            }
            return l2 - (long)n;
        }

        OfYear(char a2, int a3, int a4, int a5, boolean a6, int a7) {
            OfYear a8;
            if (a2 != 'u' && a2 != 'w' && a2 != 's') {
                throw new IllegalArgumentException("Unknown mode: " + a2);
            }
            a8.iMode = a2;
            a8.iMonthOfYear = a3;
            a8.iDayOfMonth = a4;
            a8.iDayOfWeek = a5;
            a8.iAdvance = a6;
            a8.iMillisOfDay = a7;
        }

        public long next(long arg0, int arg1, int arg2) {
            int n = this.iMode == 'w' ? arg1 + arg2 : (this.iMode == 's' ? arg1 : 0);
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l2 = ((Chronology)iSOChronology).monthOfYear().set(arg0 += (long)n, this.iMonthOfYear);
            l2 = ((Chronology)iSOChronology).millisOfDay().set(l2, 0);
            l2 = ((Chronology)iSOChronology).millisOfDay().add(l2, this.iMillisOfDay);
            l2 = this.setDayOfMonthNext(iSOChronology, l2);
            if (this.iDayOfWeek == 0) {
                if (l2 <= arg0) {
                    l2 = ((Chronology)iSOChronology).year().add(l2, 1);
                    l2 = this.setDayOfMonthNext(iSOChronology, l2);
                }
            } else if ((l2 = this.setDayOfWeek(iSOChronology, l2)) <= arg0) {
                l2 = ((Chronology)iSOChronology).year().add(l2, 1);
                l2 = ((Chronology)iSOChronology).monthOfYear().set(l2, this.iMonthOfYear);
                l2 = this.setDayOfMonthNext(iSOChronology, l2);
                l2 = this.setDayOfWeek(iSOChronology, l2);
            }
            return l2 - (long)n;
        }
    }
}

