/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import org.joda.time.DateTimeZone;

public class CachedDateTimeZone
extends DateTimeZone {
    private final DateTimeZone iZone;
    private static final int cInfoCacheMask;
    private static final long serialVersionUID = 5472298452022250685L;
    private final transient Info[] iInfoCache = new Info[cInfoCacheMask + 1];

    private Info createInfo(long a2) {
        long l2;
        CachedDateTimeZone a3;
        long l3 = a2 & 0xFFFFFFFF00000000L;
        Info info = new Info(a3.iZone, l3);
        long l4 = l3 | 0xFFFFFFFFL;
        Info info2 = info;
        while ((l2 = a3.iZone.nextTransition(l3)) != l3 && l2 <= l4) {
            l3 = l2;
            info2 = info2.iNextInfo = new Info(a3.iZone, l3);
        }
        return info;
    }

    public boolean isFixed() {
        return this.iZone.isFixed();
    }

    public int hashCode() {
        return this.iZone.hashCode();
    }

    private Info getInfo(long a2) {
        CachedDateTimeZone a3;
        Info[] infoArray = a3.iInfoCache;
        int n = (int)(a2 >> 32);
        int n2 = n & cInfoCacheMask;
        Info info = infoArray[n2];
        if (info == null || (int)(info.iPeriodStart >> 32) != n) {
            infoArray[n2] = info = a3.createInfo(a2);
        }
        return info;
    }

    public long nextTransition(long arg0) {
        return this.iZone.nextTransition(arg0);
    }

    public String getNameKey(long arg0) {
        return this.getInfo(arg0).getNameKey(arg0);
    }

    static {
        int n;
        Integer n2;
        try {
            n2 = Integer.getInteger("org.joda.time.tz.CachedDateTimeZone.size");
        }
        catch (SecurityException securityException) {
            n2 = null;
        }
        if (n2 == null) {
            n = 512;
        } else {
            n = n2;
            --n;
            int n3 = 0;
            while (n > 0) {
                ++n3;
                n >>= 1;
            }
            n = 1 << n3;
        }
        cInfoCacheMask = n - 1;
    }

    public int getOffset(long arg0) {
        return this.getInfo(arg0).getOffset(arg0);
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof CachedDateTimeZone) {
            return this.iZone.equals(((CachedDateTimeZone)arg0).iZone);
        }
        return false;
    }

    public DateTimeZone getUncachedZone() {
        return this.iZone;
    }

    public int getStandardOffset(long arg0) {
        return this.getInfo(arg0).getStandardOffset(arg0);
    }

    public static CachedDateTimeZone forZone(DateTimeZone arg0) {
        if (arg0 instanceof CachedDateTimeZone) {
            return (CachedDateTimeZone)arg0;
        }
        return new CachedDateTimeZone(arg0);
    }

    private CachedDateTimeZone(DateTimeZone a2) {
        super(a2.getID());
        CachedDateTimeZone a3;
        a3.iZone = a2;
    }

    public long previousTransition(long arg0) {
        return this.iZone.previousTransition(arg0);
    }

    private static final class Info {
        Info iNextInfo;
        private String iNameKey;
        public final long iPeriodStart;
        public final DateTimeZone iZoneRef;
        private int iStandardOffset;
        private int iOffset = Integer.MIN_VALUE;

        public String getNameKey(long arg0) {
            if (this.iNextInfo == null || arg0 < this.iNextInfo.iPeriodStart) {
                if (this.iNameKey == null) {
                    this.iNameKey = this.iZoneRef.getNameKey(this.iPeriodStart);
                }
                return this.iNameKey;
            }
            return this.iNextInfo.getNameKey(arg0);
        }

        public int getOffset(long arg0) {
            if (this.iNextInfo == null || arg0 < this.iNextInfo.iPeriodStart) {
                if (this.iOffset == Integer.MIN_VALUE) {
                    this.iOffset = this.iZoneRef.getOffset(this.iPeriodStart);
                }
                return this.iOffset;
            }
            return this.iNextInfo.getOffset(arg0);
        }

        Info(DateTimeZone a2, long a3) {
            Info a4;
            a4.iStandardOffset = Integer.MIN_VALUE;
            a4.iPeriodStart = a3;
            a4.iZoneRef = a2;
        }

        public int getStandardOffset(long arg0) {
            if (this.iNextInfo == null || arg0 < this.iNextInfo.iPeriodStart) {
                if (this.iStandardOffset == Integer.MIN_VALUE) {
                    this.iStandardOffset = this.iZoneRef.getStandardOffset(this.iPeriodStart);
                }
                return this.iStandardOffset;
            }
            return this.iNextInfo.getStandardOffset(arg0);
        }
    }
}

