/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimeParserInternalParser;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.DateTimePrinterInternalPrinter;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.InternalParser;
import org.joda.time.format.InternalParserDateTimeParser;
import org.joda.time.format.InternalPrinter;
import org.joda.time.format.InternalPrinterDateTimePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeFormatterBuilder {
    private Object iFormatter;
    private ArrayList<Object> iElementPairs = new ArrayList();

    public DateTimeFormatterBuilder append(DateTimeParser arg0) {
        this.checkParser(arg0);
        return this.append0(null, DateTimeParserInternalParser.of(arg0));
    }

    public DateTimeFormatterBuilder appendClockhourOfHalfday(int arg0) {
        return this.appendDecimal(DateTimeFieldType.clockhourOfHalfday(), arg0, 2);
    }

    public DateTimeFormatterBuilder appendFractionOfSecond(int arg0, int arg1) {
        return this.appendFraction(DateTimeFieldType.secondOfDay(), arg0, arg1);
    }

    private boolean isParser(Object a2) {
        if (a2 instanceof InternalParser) {
            if (a2 instanceof Composite) {
                return ((Composite)a2).isParser();
            }
            return true;
        }
        return false;
    }

    public DateTimeFormatterBuilder appendFixedSignedDecimal(DateTimeFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (arg1 <= 0) {
            throw new IllegalArgumentException("Illegal number of digits: " + arg1);
        }
        return this.append0(new FixedNumber(arg0, arg1, true));
    }

    public DateTimeParser toParser() {
        Object object = this.getFormatter();
        if (this.isParser(object)) {
            InternalParser internalParser = (InternalParser)object;
            return InternalParserDateTimeParser.of(internalParser);
        }
        throw new UnsupportedOperationException("Parsing is not supported");
    }

    public DateTimeFormatterBuilder appendHourOfDay(int arg0) {
        return this.appendDecimal(DateTimeFieldType.hourOfDay(), arg0, 2);
    }

    public DateTimeFormatterBuilder appendWeekyear(int arg0, int arg1) {
        return this.appendSignedDecimal(DateTimeFieldType.weekyear(), arg0, arg1);
    }

    public DateTimeFormatterBuilder appendMonthOfYear(int arg0) {
        return this.appendDecimal(DateTimeFieldType.monthOfYear(), arg0, 2);
    }

    public DateTimePrinter toPrinter() {
        Object object = this.getFormatter();
        if (this.isPrinter(object)) {
            InternalPrinter internalPrinter = (InternalPrinter)object;
            return InternalPrinterDateTimePrinter.of(internalPrinter);
        }
        throw new UnsupportedOperationException("Printing is not supported");
    }

    private DateTimeFormatterBuilder append0(Object a2) {
        DateTimeFormatterBuilder a3;
        a3.iFormatter = null;
        a3.iElementPairs.add(a2);
        a3.iElementPairs.add(a2);
        return a3;
    }

    public DateTimeFormatterBuilder appendPattern(String arg0) {
        DateTimeFormat.appendPatternTo(this, arg0);
        return this;
    }

    private DateTimeFormatterBuilder append0(InternalPrinter a2, InternalParser a3) {
        DateTimeFormatterBuilder a4;
        a4.iFormatter = null;
        a4.iElementPairs.add(a2);
        a4.iElementPairs.add(a3);
        return a4;
    }

    static int csCompare(CharSequence a2, int a3, String a4) {
        int n = Math.min(a2.length() - a3, a4.length());
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = a4.charAt(i2) - a2.charAt(a3 + i2);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public DateTimeFormatterBuilder appendDayOfYear(int arg0) {
        return this.appendDecimal(DateTimeFieldType.dayOfYear(), arg0, 3);
    }

    public DateTimeFormatterBuilder appendFractionOfDay(int arg0, int arg1) {
        return this.appendFraction(DateTimeFieldType.dayOfYear(), arg0, arg1);
    }

    public DateTimeFormatterBuilder appendMonthOfYearText() {
        return this.appendText(DateTimeFieldType.monthOfYear());
    }

    public DateTimeFormatterBuilder appendYearOfEra(int arg0, int arg1) {
        return this.appendDecimal(DateTimeFieldType.yearOfEra(), arg0, arg1);
    }

    public DateTimeFormatterBuilder appendSecondOfMinute(int arg0) {
        return this.appendDecimal(DateTimeFieldType.secondOfMinute(), arg0, 2);
    }

    public DateTimeFormatterBuilder appendTwoDigitYear(int arg0, boolean arg1) {
        return this.append0(new TwoDigitYear(DateTimeFieldType.year(), arg0, arg1));
    }

    public DateTimeFormatterBuilder appendHalfdayOfDayText() {
        return this.appendText(DateTimeFieldType.halfdayOfDay());
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("No formatter supplied");
        }
        return this.append0(arg0.getPrinter0(), arg0.getParser0());
    }

    public DateTimeFormatterBuilder appendTwoDigitYear(int arg0) {
        return this.appendTwoDigitYear(arg0, false);
    }

    public DateTimeFormatterBuilder appendShortText(DateTimeFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(arg0, true));
    }

    public boolean canBuildParser() {
        return this.isParser(this.getFormatter());
    }

    public DateTimeFormatterBuilder appendYearOfCentury(int arg0, int arg1) {
        return this.appendDecimal(DateTimeFieldType.yearOfCentury(), arg0, arg1);
    }

    public DateTimeFormatterBuilder appendLiteral(char arg0) {
        return this.append0(new CharacterLiteral(arg0));
    }

    public DateTimeFormatterBuilder appendTimeZoneOffset(String arg0, String arg1, boolean arg2, int arg3, int arg4) {
        return this.append0(new TimeZoneOffset(arg0, arg1, arg2, arg3, arg4));
    }

    public DateTimeFormatterBuilder appendSignedDecimal(DateTimeFieldType arg0, int arg1, int arg2) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (arg2 < arg1) {
            arg2 = arg1;
        }
        if (arg1 < 0 || arg2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (arg1 <= 1) {
            return this.append0(new UnpaddedNumber(arg0, arg2, true));
        }
        return this.append0(new PaddedNumber(arg0, arg2, true, arg1));
    }

    public DateTimeFormatterBuilder appendTwoDigitWeekyear(int arg0, boolean arg1) {
        return this.append0(new TwoDigitYear(DateTimeFieldType.weekyear(), arg0, arg1));
    }

    private Object getFormatter() {
        DateTimeFormatterBuilder a2;
        Object object = a2.iFormatter;
        if (object == null) {
            if (a2.iElementPairs.size() == 2) {
                Object object2 = a2.iElementPairs.get(0);
                Object object3 = a2.iElementPairs.get(1);
                if (object2 != null) {
                    if (object2 == object3 || object3 == null) {
                        object = object2;
                    }
                } else {
                    object = object3;
                }
            }
            if (object == null) {
                object = new Composite(a2.iElementPairs);
            }
            a2.iFormatter = object;
        }
        return object;
    }

    static void appendUnknownString(Appendable a2, int a3) throws IOException {
        int n = a3;
        while (--n >= 0) {
            a2.append('\ufffd');
        }
    }

    public DateTimeFormatterBuilder appendCenturyOfEra(int arg0, int arg1) {
        return this.appendSignedDecimal(DateTimeFieldType.centuryOfEra(), arg0, arg1);
    }

    public DateTimeFormatterBuilder appendDayOfWeek(int arg0) {
        return this.appendDecimal(DateTimeFieldType.dayOfWeek(), arg0, 1);
    }

    public void clear() {
        this.iFormatter = null;
        this.iElementPairs.clear();
    }

    public boolean canBuildFormatter() {
        return this.isFormatter(this.getFormatter());
    }

    public DateTimeFormatterBuilder appendTimeZoneId() {
        return this.append0(TimeZoneId.INSTANCE, TimeZoneId.INSTANCE);
    }

    public DateTimeFormatterBuilder appendMillisOfDay(int arg0) {
        return this.appendDecimal(DateTimeFieldType.millisOfDay(), arg0, 8);
    }

    public DateTimeFormatterBuilder appendTwoDigitWeekyear(int arg0) {
        return this.appendTwoDigitWeekyear(arg0, false);
    }

    public DateTimeFormatterBuilder appendDecimal(DateTimeFieldType arg0, int arg1, int arg2) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (arg2 < arg1) {
            arg2 = arg1;
        }
        if (arg1 < 0 || arg2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (arg1 <= 1) {
            return this.append0(new UnpaddedNumber(arg0, arg2, false));
        }
        return this.append0(new PaddedNumber(arg0, arg2, false, arg1));
    }

    public DateTimeFormatterBuilder appendFractionOfMinute(int arg0, int arg1) {
        return this.appendFraction(DateTimeFieldType.minuteOfDay(), arg0, arg1);
    }

    public DateTimeFormatterBuilder appendTimeZoneName(Map<String, DateTimeZone> arg0) {
        TimeZoneName timeZoneName = new TimeZoneName(0, arg0);
        return this.append0(timeZoneName, timeZoneName);
    }

    public DateTimeFormatterBuilder appendTimeZoneShortName() {
        return this.append0(new TimeZoneName(1, null), null);
    }

    public DateTimeFormatterBuilder appendEraText() {
        return this.appendText(DateTimeFieldType.era());
    }

    private boolean isPrinter(Object a2) {
        if (a2 instanceof InternalPrinter) {
            if (a2 instanceof Composite) {
                return ((Composite)a2).isPrinter();
            }
            return true;
        }
        return false;
    }

    public DateTimeFormatterBuilder appendText(DateTimeFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(arg0, false));
    }

    public DateTimeFormatterBuilder appendDayOfWeekShortText() {
        return this.appendShortText(DateTimeFieldType.dayOfWeek());
    }

    public DateTimeFormatterBuilder appendTimeZoneShortName(Map<String, DateTimeZone> arg0) {
        TimeZoneName timeZoneName = new TimeZoneName(1, arg0);
        return this.append0(timeZoneName, timeZoneName);
    }

    public DateTimeFormatterBuilder appendMinuteOfHour(int arg0) {
        return this.appendDecimal(DateTimeFieldType.minuteOfHour(), arg0, 2);
    }

    static boolean csStartsWith(CharSequence a2, int a3, String a4) {
        int n = a4.length();
        if (a2.length() - a3 < n) {
            return false;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            if (a2.charAt(a3 + i2) == a4.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public boolean canBuildPrinter() {
        return this.isPrinter(this.getFormatter());
    }

    public DateTimeFormatterBuilder appendYear(int arg0, int arg1) {
        return this.appendSignedDecimal(DateTimeFieldType.year(), arg0, arg1);
    }

    public DateTimeFormatterBuilder appendFraction(DateTimeFieldType arg0, int arg1, int arg2) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (arg2 < arg1) {
            arg2 = arg1;
        }
        if (arg1 < 0 || arg2 <= 0) {
            throw new IllegalArgumentException();
        }
        return this.append0(new Fraction(arg0, arg1, arg2));
    }

    public DateTimeFormatterBuilder appendSecondOfDay(int arg0) {
        return this.appendDecimal(DateTimeFieldType.secondOfDay(), arg0, 5);
    }

    public DateTimeFormatterBuilder appendMillisOfSecond(int arg0) {
        return this.appendDecimal(DateTimeFieldType.millisOfSecond(), arg0, 3);
    }

    static boolean csStartsWithIgnoreCase(CharSequence a2, int a3, String a4) {
        int n = a4.length();
        if (a2.length() - a3 < n) {
            return false;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            char c2;
            char c3;
            char c4;
            char c5 = a2.charAt(a3 + i2);
            if (c5 == (c4 = a4.charAt(i2)) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeParser arg0) {
        this.checkParser(arg0);
        InternalParser[] internalParserArray = new InternalParser[]{DateTimeParserInternalParser.of(arg0), null};
        return this.append0(null, new MatchingParser(internalParserArray));
    }

    public DateTimeFormatterBuilder appendTimeZoneOffset(String arg0, boolean arg1, int arg2, int arg3) {
        return this.append0(new TimeZoneOffset(arg0, arg0, arg1, arg2, arg3));
    }

    public DateTimeFormatterBuilder appendTimeZoneName() {
        return this.append0(new TimeZoneName(0, null), null);
    }

    public DateTimeFormatterBuilder appendMonthOfYearShortText() {
        return this.appendShortText(DateTimeFieldType.monthOfYear());
    }

    public DateTimeFormatterBuilder appendClockhourOfDay(int arg0) {
        return this.appendDecimal(DateTimeFieldType.clockhourOfDay(), arg0, 2);
    }

    public DateTimeFormatterBuilder appendWeekOfWeekyear(int arg0) {
        return this.appendDecimal(DateTimeFieldType.weekOfWeekyear(), arg0, 2);
    }

    private void checkParser(DateTimeParser a2) {
        if (a2 == null) {
            throw new IllegalArgumentException("No parser supplied");
        }
    }

    public DateTimeFormatterBuilder append(DateTimePrinter arg0) {
        this.checkPrinter(arg0);
        return this.append0(DateTimePrinterInternalPrinter.of(arg0), null);
    }

    private boolean isFormatter(Object a2) {
        DateTimeFormatterBuilder a3;
        return a3.isPrinter(a2) || a3.isParser(a2);
    }

    public DateTimeFormatterBuilder appendDayOfMonth(int arg0) {
        return this.appendDecimal(DateTimeFieldType.dayOfMonth(), arg0, 2);
    }

    public DateTimeFormatterBuilder append(DateTimePrinter arg0, DateTimeParser[] arg1) {
        int n;
        if (arg0 != null) {
            this.checkPrinter(arg0);
        }
        if (arg1 == null) {
            throw new IllegalArgumentException("No parsers supplied");
        }
        int n2 = arg1.length;
        if (n2 == 1) {
            if (arg1[0] == null) {
                throw new IllegalArgumentException("No parser supplied");
            }
            return this.append0(DateTimePrinterInternalPrinter.of(arg0), DateTimeParserInternalParser.of(arg1[0]));
        }
        InternalParser[] internalParserArray = new InternalParser[n2];
        for (n = 0; n < n2 - 1; ++n) {
            internalParserArray[n] = DateTimeParserInternalParser.of(arg1[n]);
            if (internalParserArray[n] != null) continue;
            throw new IllegalArgumentException("Incomplete parser array");
        }
        internalParserArray[n] = DateTimeParserInternalParser.of(arg1[n]);
        return this.append0(DateTimePrinterInternalPrinter.of(arg0), new MatchingParser(internalParserArray));
    }

    public DateTimeFormatterBuilder append(DateTimePrinter arg0, DateTimeParser arg1) {
        this.checkPrinter(arg0);
        this.checkParser(arg1);
        return this.append0(DateTimePrinterInternalPrinter.of(arg0), DateTimeParserInternalParser.of(arg1));
    }

    public DateTimeFormatterBuilder appendFractionOfHour(int arg0, int arg1) {
        return this.appendFraction(DateTimeFieldType.hourOfDay(), arg0, arg1);
    }

    public DateTimeFormatterBuilder appendHourOfHalfday(int arg0) {
        return this.appendDecimal(DateTimeFieldType.hourOfHalfday(), arg0, 2);
    }

    private void checkPrinter(DateTimePrinter a2) {
        if (a2 == null) {
            throw new IllegalArgumentException("No printer supplied");
        }
    }

    public DateTimeFormatterBuilder appendLiteral(String arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        switch (arg0.length()) {
            case 0: {
                return this;
            }
            case 1: {
                return this.append0(new CharacterLiteral(arg0.charAt(0)));
            }
        }
        return this.append0(new StringLiteral(arg0));
    }

    public DateTimeFormatterBuilder appendMinuteOfDay(int arg0) {
        return this.appendDecimal(DateTimeFieldType.minuteOfDay(), arg0, 4);
    }

    public DateTimeFormatter toFormatter() {
        Object object = this.getFormatter();
        InternalPrinter internalPrinter = null;
        if (this.isPrinter(object)) {
            internalPrinter = (InternalPrinter)object;
        }
        InternalParser internalParser = null;
        if (this.isParser(object)) {
            internalParser = (InternalParser)object;
        }
        if (internalPrinter != null || internalParser != null) {
            return new DateTimeFormatter(internalPrinter, internalParser);
        }
        throw new UnsupportedOperationException("Both printing and parsing not supported");
    }

    public DateTimeFormatterBuilder appendFixedDecimal(DateTimeFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (arg1 <= 0) {
            throw new IllegalArgumentException("Illegal number of digits: " + arg1);
        }
        return this.append0(new FixedNumber(arg0, arg1, false));
    }

    public DateTimeFormatterBuilder appendDayOfWeekText() {
        return this.appendText(DateTimeFieldType.dayOfWeek());
    }

    static class MatchingParser
    implements InternalParser {
        private final InternalParser[] iParsers;
        private final int iParsedLengthEstimate;

        MatchingParser(InternalParser[] a2) {
            MatchingParser a3;
            a3.iParsers = a2;
            int n = 0;
            int n2 = a2.length;
            while (--n2 >= 0) {
                int n3;
                InternalParser internalParser = a2[n2];
                if (internalParser == null || (n3 = internalParser.estimateParsedLength()) <= n) continue;
                n = n3;
            }
            a3.iParsedLengthEstimate = n;
        }

        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            InternalParser[] internalParserArray = this.iParsers;
            int n = internalParserArray.length;
            Object object = arg0.saveState();
            boolean bl = false;
            int n2 = arg2;
            Object object2 = null;
            int n3 = arg2;
            for (int i2 = 0; i2 < n; ++i2) {
                InternalParser internalParser = internalParserArray[i2];
                if (internalParser == null) {
                    if (n2 <= arg2) {
                        return arg2;
                    }
                    bl = true;
                    break;
                }
                int n4 = internalParser.parseInto(arg0, arg1, arg2);
                if (n4 >= arg2) {
                    if (n4 > n2) {
                        if (n4 >= arg1.length() || i2 + 1 >= n || internalParserArray[i2 + 1] == null) {
                            return n4;
                        }
                        n2 = n4;
                        object2 = arg0.saveState();
                    }
                } else if (n4 < 0 && (n4 ^= 0xFFFFFFFF) > n3) {
                    n3 = n4;
                }
                arg0.restoreState(object);
            }
            if (n2 > arg2 || n2 == arg2 && bl) {
                if (object2 != null) {
                    arg0.restoreState(object2);
                }
                return n2;
            }
            return ~n3;
        }

        public int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Composite
    implements InternalPrinter,
    InternalParser {
        private final int iParsedLengthEstimate;
        private final InternalParser[] iParsers;
        private final int iPrintedLengthEstimate;
        private final InternalPrinter[] iPrinters;

        @Override
        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            InternalParser[] internalParserArray = this.iParsers;
            if (internalParserArray == null) {
                throw new UnsupportedOperationException();
            }
            int n = internalParserArray.length;
            for (int i2 = 0; i2 < n && arg2 >= 0; ++i2) {
                arg2 = internalParserArray[i2].parseInto(arg0, arg1, arg2);
            }
            return arg2;
        }

        Composite(List<Object> a2) {
            Object object;
            int n;
            int n2;
            int n3;
            Composite a3;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            a3.decompose(a2, arrayList, arrayList2);
            if (arrayList.contains(null) || arrayList.isEmpty()) {
                a3.iPrinters = null;
                a3.iPrintedLengthEstimate = 0;
            } else {
                n3 = arrayList.size();
                a3.iPrinters = new InternalPrinter[n3];
                n2 = 0;
                for (n = 0; n < n3; ++n) {
                    object = (InternalPrinter)arrayList.get(n);
                    n2 += object.estimatePrintedLength();
                    a3.iPrinters[n] = object;
                }
                a3.iPrintedLengthEstimate = n2;
            }
            if (arrayList2.contains(null) || arrayList2.isEmpty()) {
                a3.iParsers = null;
                a3.iParsedLengthEstimate = 0;
            } else {
                n3 = arrayList2.size();
                a3.iParsers = new InternalParser[n3];
                n2 = 0;
                for (n = 0; n < n3; ++n) {
                    object = (InternalParser)arrayList2.get(n);
                    n2 += object.estimateParsedLength();
                    a3.iParsers[n] = object;
                }
                a3.iParsedLengthEstimate = n2;
            }
        }

        @Override
        public int estimatePrintedLength() {
            return this.iPrintedLengthEstimate;
        }

        private void decompose(List<Object> a2, List<Object> a3, List<Object> a4) {
            int n = a2.size();
            for (int i2 = 0; i2 < n; i2 += 2) {
                Composite a5;
                Object object = a2.get(i2);
                if (object instanceof Composite) {
                    a5.addArrayToList(a3, ((Composite)object).iPrinters);
                } else {
                    a3.add(object);
                }
                object = a2.get(i2 + 1);
                if (object instanceof Composite) {
                    a5.addArrayToList(a4, ((Composite)object).iParsers);
                    continue;
                }
                a4.add(object);
            }
        }

        @Override
        public void printTo(Appendable arg0, long arg1, Chronology arg2, int arg3, DateTimeZone arg4, Locale arg5) throws IOException {
            InternalPrinter[] internalPrinterArray = this.iPrinters;
            if (internalPrinterArray == null) {
                throw new UnsupportedOperationException();
            }
            if (arg5 == null) {
                arg5 = Locale.getDefault();
            }
            int n = internalPrinterArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                internalPrinterArray[i2].printTo(arg0, arg1, arg2, arg3, arg4, arg5);
            }
        }

        @Override
        public void printTo(Appendable arg0, ReadablePartial arg1, Locale arg2) throws IOException {
            InternalPrinter[] internalPrinterArray = this.iPrinters;
            if (internalPrinterArray == null) {
                throw new UnsupportedOperationException();
            }
            if (arg2 == null) {
                arg2 = Locale.getDefault();
            }
            int n = internalPrinterArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                internalPrinterArray[i2].printTo(arg0, arg1, arg2);
            }
        }

        boolean isPrinter() {
            Composite a2;
            return a2.iPrinters != null;
        }

        boolean isParser() {
            Composite a2;
            return a2.iParsers != null;
        }

        @Override
        public int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        private void addArrayToList(List<Object> a2, Object[] a3) {
            if (a3 != null) {
                for (int i2 = 0; i2 < a3.length; ++i2) {
                    a2.add(a3[i2]);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TimeZoneId implements InternalPrinter,
    InternalParser
    {
        INSTANCE;

        private static final List<String> ALL_IDS = new ArrayList<String>(DateTimeZone.getAvailableIDs());
        static final int MAX_LENGTH;

        @Override
        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            int n;
            String string;
            String string2 = null;
            for (int i2 = n = TimeZoneId.prefixedStartPosition(arg1, arg2); i2 < ALL_IDS.size() && DateTimeFormatterBuilder.csStartsWith(arg1, arg2, string = ALL_IDS.get(i2)); ++i2) {
                if (string2 != null && string.length() <= string2.length()) continue;
                string2 = string;
            }
            if (string2 != null) {
                arg0.setZone(DateTimeZone.forID(string2));
                return arg2 + string2.length();
            }
            return ~arg2;
        }

        static {
            Collections.sort(ALL_IDS);
            int n = 0;
            for (String string : ALL_IDS) {
                n = Math.max(n, string.length());
            }
            MAX_LENGTH = n;
        }

        @Override
        public int estimatePrintedLength() {
            return MAX_LENGTH;
        }

        private TimeZoneId() {
            TimeZoneId a4;
        }

        @Override
        public void printTo(Appendable arg0, ReadablePartial arg1, Locale arg2) throws IOException {
        }

        private static int prefixedStartPosition(CharSequence a2, int a3) {
            int n = 0;
            int n2 = ALL_IDS.size() - 1;
            while (n <= n2) {
                int n3 = n + n2 >>> 1;
                String string = ALL_IDS.get(n3);
                int n4 = DateTimeFormatterBuilder.csCompare(a2, a3, string);
                if (n4 > 0) {
                    n2 = n3 - 1;
                    continue;
                }
                if (n4 < 0) {
                    n = n3 + 1;
                    continue;
                }
                return n3;
            }
            return n;
        }

        @Override
        public int estimateParsedLength() {
            return MAX_LENGTH;
        }

        @Override
        public void printTo(Appendable arg0, long arg1, Chronology arg2, int arg3, DateTimeZone arg4, Locale arg5) throws IOException {
            arg0.append(arg4 != null ? arg4.getID() : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TimeZoneName
    implements InternalPrinter,
    InternalParser {
        static final int SHORT_NAME = 1;
        private final int iType;
        private final Map<String, DateTimeZone> iParseLookup;
        static final int LONG_NAME = 0;

        private String print(long a2, DateTimeZone a3, Locale a4) {
            TimeZoneName a5;
            if (a3 == null) {
                return "";
            }
            switch (a5.iType) {
                case 0: {
                    return a3.getName(a2, a4);
                }
                case 1: {
                    return a3.getShortName(a2, a4);
                }
            }
            return "";
        }

        @Override
        public void printTo(Appendable arg0, long arg1, Chronology arg2, int arg3, DateTimeZone arg4, Locale arg5) throws IOException {
            arg0.append(this.print(arg1 - (long)arg3, arg4, arg5));
        }

        @Override
        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            Map<String, DateTimeZone> map = this.iParseLookup;
            map = map != null ? map : DateTimeUtils.getDefaultTimeZoneNames();
            String string = null;
            for (String string2 : map.keySet()) {
                if (!DateTimeFormatterBuilder.csStartsWith(arg1, arg2, string2) || string != null && string2.length() <= string.length()) continue;
                string = string2;
            }
            if (string != null) {
                arg0.setZone(map.get(string));
                return arg2 + string.length();
            }
            return ~arg2;
        }

        @Override
        public void printTo(Appendable arg0, ReadablePartial arg1, Locale arg2) throws IOException {
        }

        @Override
        public int estimatePrintedLength() {
            return this.iType == 1 ? 4 : 20;
        }

        @Override
        public int estimateParsedLength() {
            return this.iType == 1 ? 4 : 20;
        }

        TimeZoneName(int a2, Map<String, DateTimeZone> a3) {
            TimeZoneName a4;
            a4.iType = a2;
            a4.iParseLookup = a3;
        }
    }

    static class TimeZoneOffset
    implements InternalPrinter,
    InternalParser {
        private final String iZeroOffsetPrintText;
        private final boolean iShowSeparators;
        private final int iMaxFields;
        private final String iZeroOffsetParseText;
        private final int iMinFields;

        private int digitCount(CharSequence a2, int a3, int a4) {
            char c2;
            int n = Math.min(a2.length() - a3, a4);
            a4 = 0;
            while (n > 0 && (c2 = a2.charAt(a3 + a4)) >= '0' && c2 <= '9') {
                ++a4;
                --n;
            }
            return a4;
        }

        public void printTo(Appendable arg0, long arg1, Chronology arg2, int arg3, DateTimeZone arg4, Locale arg5) throws IOException {
            if (arg4 == null) {
                return;
            }
            if (arg3 == 0 && this.iZeroOffsetPrintText != null) {
                arg0.append(this.iZeroOffsetPrintText);
                return;
            }
            if (arg3 >= 0) {
                arg0.append('+');
            } else {
                arg0.append('-');
                arg3 = -arg3;
            }
            int n = arg3 / 3600000;
            FormatUtils.appendPaddedInteger(arg0, n, 2);
            if (this.iMaxFields == 1) {
                return;
            }
            if ((arg3 -= n * 3600000) == 0 && this.iMinFields <= 1) {
                return;
            }
            int n2 = arg3 / 60000;
            if (this.iShowSeparators) {
                arg0.append(':');
            }
            FormatUtils.appendPaddedInteger(arg0, n2, 2);
            if (this.iMaxFields == 2) {
                return;
            }
            if ((arg3 -= n2 * 60000) == 0 && this.iMinFields <= 2) {
                return;
            }
            int n3 = arg3 / 1000;
            if (this.iShowSeparators) {
                arg0.append(':');
            }
            FormatUtils.appendPaddedInteger(arg0, n3, 2);
            if (this.iMaxFields == 3) {
                return;
            }
            if ((arg3 -= n3 * 1000) == 0 && this.iMinFields <= 3) {
                return;
            }
            if (this.iShowSeparators) {
                arg0.append('.');
            }
            FormatUtils.appendPaddedInteger(arg0, arg3, 3);
        }

        public int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            int n;
            char c2;
            block24: {
                int n2;
                boolean bl;
                block28: {
                    int n3;
                    block27: {
                        block26: {
                            char c3;
                            block25: {
                                n3 = arg1.length() - arg2;
                                if (this.iZeroOffsetParseText != null) {
                                    if (this.iZeroOffsetParseText.length() == 0) {
                                        if (n3 <= 0 || (c2 = arg1.charAt(arg2)) != '-' && c2 != '+') {
                                            arg0.setOffset((Integer)0);
                                            return arg2;
                                        }
                                    } else if (DateTimeFormatterBuilder.csStartsWithIgnoreCase(arg1, arg2, this.iZeroOffsetParseText)) {
                                        arg0.setOffset((Integer)0);
                                        return arg2 + this.iZeroOffsetParseText.length();
                                    }
                                }
                                if (n3 <= 1) {
                                    return ~arg2;
                                }
                                c3 = arg1.charAt(arg2);
                                if (c3 == '-') {
                                    c2 = '\u0001';
                                } else if (c3 == '+') {
                                    c2 = '\u0000';
                                } else {
                                    return ~arg2;
                                }
                                --n3;
                                if (this.digitCount(arg1, ++arg2, 2) < 2) {
                                    return ~arg2;
                                }
                                int n4 = FormatUtils.parseTwoDigits(arg1, arg2);
                                if (n4 > 23) {
                                    return ~arg2;
                                }
                                n = n4 * 3600000;
                                arg2 += 2;
                                if ((n3 -= 2) <= 0) break block24;
                                c3 = arg1.charAt(arg2);
                                if (c3 != ':') break block25;
                                bl = true;
                                --n3;
                                ++arg2;
                                break block26;
                            }
                            if (c3 < '0' || c3 > '9') break block24;
                            bl = false;
                        }
                        n2 = this.digitCount(arg1, arg2, 2);
                        if (n2 == 0 && !bl) break block24;
                        if (n2 < 2) {
                            return ~arg2;
                        }
                        int n5 = FormatUtils.parseTwoDigits(arg1, arg2);
                        if (n5 > 59) {
                            return ~arg2;
                        }
                        n += n5 * 60000;
                        arg2 += 2;
                        if ((n3 -= 2) <= 0) break block24;
                        if (!bl) break block27;
                        if (arg1.charAt(arg2) != ':') break block24;
                        --n3;
                        ++arg2;
                    }
                    if ((n2 = this.digitCount(arg1, arg2, 2)) == 0 && !bl) break block24;
                    if (n2 < 2) {
                        return ~arg2;
                    }
                    int n6 = FormatUtils.parseTwoDigits(arg1, arg2);
                    if (n6 > 59) {
                        return ~arg2;
                    }
                    n += n6 * 1000;
                    arg2 += 2;
                    if ((n3 -= 2) <= 0) break block24;
                    if (!bl) break block28;
                    if (arg1.charAt(arg2) != '.' && arg1.charAt(arg2) != ',') break block24;
                    --n3;
                    ++arg2;
                }
                if ((n2 = this.digitCount(arg1, arg2, 3)) != 0 || bl) {
                    if (n2 < 1) {
                        return ~arg2;
                    }
                    n += (arg1.charAt(arg2++) - 48) * 100;
                    if (n2 > 1) {
                        n += (arg1.charAt(arg2++) - 48) * 10;
                        if (n2 > 2) {
                            n += arg1.charAt(arg2++) - 48;
                        }
                    }
                }
            }
            arg0.setOffset((Integer)(c2 != '\u0000' ? -n : n));
            return arg2;
        }

        TimeZoneOffset(String a2, String a3, boolean a4, int a5, int a6) {
            TimeZoneOffset a7;
            a7.iZeroOffsetPrintText = a2;
            a7.iZeroOffsetParseText = a3;
            a7.iShowSeparators = a4;
            if (a5 <= 0 || a6 < a5) {
                throw new IllegalArgumentException();
            }
            if (a5 > 4) {
                a5 = 4;
                a6 = 4;
            }
            a7.iMinFields = a5;
            a7.iMaxFields = a6;
        }

        public void printTo(Appendable arg0, ReadablePartial arg1, Locale arg2) throws IOException {
        }

        public int estimatePrintedLength() {
            int n = 1 + this.iMinFields << 1;
            if (this.iShowSeparators) {
                n += this.iMinFields - 1;
            }
            if (this.iZeroOffsetPrintText != null && this.iZeroOffsetPrintText.length() > n) {
                n = this.iZeroOffsetPrintText.length();
            }
            return n;
        }
    }

    static class Fraction
    implements InternalPrinter,
    InternalParser {
        protected int iMaxDigits;
        private final DateTimeFieldType iFieldType;
        protected int iMinDigits;

        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            char c2;
            DateTimeField dateTimeField = this.iFieldType.getField(arg0.getChronology());
            int n = Math.min(this.iMaxDigits, arg1.length() - arg2);
            long l2 = 0L;
            long l3 = dateTimeField.getDurationField().getUnitMillis() * 10L;
            int n2 = 0;
            while (n2 < n && (c2 = arg1.charAt(arg2 + n2)) >= '0' && c2 <= '9') {
                ++n2;
                long l4 = l3 / 10L;
                l2 += (long)(c2 - 48) * l4;
                l3 = l4;
            }
            l2 /= 10L;
            if (n2 == 0) {
                return ~arg2;
            }
            if (l2 > Integer.MAX_VALUE) {
                return ~arg2;
            }
            PreciseDateTimeField preciseDateTimeField = new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), MillisDurationField.INSTANCE, dateTimeField.getDurationField());
            arg0.saveField(preciseDateTimeField, (int)l2);
            return arg2 + n2;
        }

        public int estimateParsedLength() {
            return this.iMaxDigits;
        }

        public void printTo(Appendable arg0, long arg1, Chronology arg2, int arg3, DateTimeZone arg4, Locale arg5) throws IOException {
            this.printTo(arg0, arg1, arg2);
        }

        private long[] getFractionData(long a2, DateTimeField a3) {
            long l2;
            Fraction a4;
            long l3 = a3.getDurationField().getUnitMillis();
            int n = a4.iMaxDigits;
            while (true) {
                switch (n) {
                    default: {
                        l2 = 1L;
                        break;
                    }
                    case 1: {
                        l2 = 10L;
                        break;
                    }
                    case 2: {
                        l2 = 100L;
                        break;
                    }
                    case 3: {
                        l2 = 1000L;
                        break;
                    }
                    case 4: {
                        l2 = 10000L;
                        break;
                    }
                    case 5: {
                        l2 = 100000L;
                        break;
                    }
                    case 6: {
                        l2 = 1000000L;
                        break;
                    }
                    case 7: {
                        l2 = 10000000L;
                        break;
                    }
                    case 8: {
                        l2 = 100000000L;
                        break;
                    }
                    case 9: {
                        l2 = 1000000000L;
                        break;
                    }
                    case 10: {
                        l2 = 10000000000L;
                        break;
                    }
                    case 11: {
                        l2 = 100000000000L;
                        break;
                    }
                    case 12: {
                        l2 = 1000000000000L;
                        break;
                    }
                    case 13: {
                        l2 = 10000000000000L;
                        break;
                    }
                    case 14: {
                        l2 = 100000000000000L;
                        break;
                    }
                    case 15: {
                        l2 = 1000000000000000L;
                        break;
                    }
                    case 16: {
                        l2 = 10000000000000000L;
                        break;
                    }
                    case 17: {
                        l2 = 100000000000000000L;
                        break;
                    }
                    case 18: {
                        l2 = 1000000000000000000L;
                    }
                }
                if (l3 * l2 / l2 == l3) break;
                --n;
            }
            return new long[]{a2 * l2 / l3, n};
        }

        protected void printTo(Appendable arg0, long arg1, Chronology arg2) throws IOException {
            int n;
            long l2;
            DateTimeField dateTimeField = this.iFieldType.getField(arg2);
            int n2 = this.iMinDigits;
            try {
                l2 = dateTimeField.remainder(arg1);
            }
            catch (RuntimeException runtimeException) {
                DateTimeFormatterBuilder.appendUnknownString(arg0, n2);
                return;
            }
            if (l2 == 0L) {
                while (--n2 >= 0) {
                    arg0.append('0');
                }
                return;
            }
            long[] lArray = this.getFractionData(l2, dateTimeField);
            long l3 = lArray[0];
            int n3 = (int)lArray[1];
            String string = (l3 & Integer.MAX_VALUE) == l3 ? Integer.toString((int)l3) : Long.toString(l3);
            int n4 = string.length();
            for (n = n3; n4 < n; --n) {
                arg0.append('0');
                --n2;
            }
            if (n2 < n) {
                while (n2 < n && n4 > 1 && string.charAt(n4 - 1) == '0') {
                    --n;
                    --n4;
                }
                if (n4 < string.length()) {
                    for (int i2 = 0; i2 < n4; ++i2) {
                        arg0.append(string.charAt(i2));
                    }
                    return;
                }
            }
            arg0.append(string);
        }

        protected Fraction(DateTimeFieldType arg0, int arg1, int arg2) {
            this.iFieldType = arg0;
            if (arg2 > 18) {
                arg2 = 18;
            }
            this.iMinDigits = arg1;
            this.iMaxDigits = arg2;
        }

        public int estimatePrintedLength() {
            return this.iMaxDigits;
        }

        public void printTo(Appendable arg0, ReadablePartial arg1, Locale arg2) throws IOException {
            long l2 = arg1.getChronology().set(arg1, 0L);
            this.printTo(arg0, l2, arg1.getChronology());
        }
    }

    static class TextField
    implements InternalPrinter,
    InternalParser {
        private static Map<Locale, Map<DateTimeFieldType, Object[]>> cParseCache = new ConcurrentHashMap<Locale, Map<DateTimeFieldType, Object[]>>();
        private final boolean iShort;
        private final DateTimeFieldType iFieldType;

        private String print(long a2, Chronology a3, Locale a4) {
            TextField a5;
            DateTimeField dateTimeField = a5.iFieldType.getField(a3);
            if (a5.iShort) {
                return dateTimeField.getAsShortText(a2, a4);
            }
            return dateTimeField.getAsText(a2, a4);
        }

        TextField(DateTimeFieldType a2, boolean a3) {
            TextField a4;
            a4.iFieldType = a2;
            a4.iShort = a3;
        }

        public int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        private String print(ReadablePartial a2, Locale a3) {
            TextField a4;
            if (a2.isSupported(a4.iFieldType)) {
                DateTimeField dateTimeField = a4.iFieldType.getField(a2.getChronology());
                if (a4.iShort) {
                    return dateTimeField.getAsShortText(a2, a3);
                }
                return dateTimeField.getAsText(a2, a3);
            }
            return "\ufffd";
        }

        public int estimatePrintedLength() {
            return this.iShort ? 6 : 20;
        }

        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            int n;
            Object[] objectArray;
            Locale locale = arg0.getLocale();
            Map<String, Boolean> map = null;
            int n2 = 0;
            Map<DateTimeFieldType, Object[]> map2 = cParseCache.get(locale);
            if (map2 == null) {
                map2 = new ConcurrentHashMap<DateTimeFieldType, Object[]>();
                cParseCache.put(locale, map2);
            }
            if ((objectArray = map2.get(this.iFieldType)) == null) {
                map = new ConcurrentHashMap(32);
                MutableDateTime mutableDateTime = new MutableDateTime(0L, DateTimeZone.UTC);
                MutableDateTime.Property property = mutableDateTime.property(this.iFieldType);
                int n3 = property.getMinimumValueOverall();
                int n4 = property.getMaximumValueOverall();
                if (n4 - n3 > 32) {
                    return ~arg2;
                }
                n2 = property.getMaximumTextLength(locale);
                for (int i2 = n3; i2 <= n4; ++i2) {
                    property.set(i2);
                    map.put(property.getAsShortText(locale), Boolean.TRUE);
                    map.put(property.getAsShortText(locale).toLowerCase(locale), Boolean.TRUE);
                    map.put(property.getAsShortText(locale).toUpperCase(locale), Boolean.TRUE);
                    map.put(property.getAsText(locale), Boolean.TRUE);
                    map.put(property.getAsText(locale).toLowerCase(locale), Boolean.TRUE);
                    map.put(property.getAsText(locale).toUpperCase(locale), Boolean.TRUE);
                }
                if ("en".equals(locale.getLanguage()) && this.iFieldType == DateTimeFieldType.era()) {
                    map.put("BCE", Boolean.TRUE);
                    map.put("bce", Boolean.TRUE);
                    map.put("CE", Boolean.TRUE);
                    map.put("ce", Boolean.TRUE);
                    n2 = 3;
                }
                objectArray = new Object[]{map, n2};
                map2.put(this.iFieldType, objectArray);
            } else {
                map = (Map)objectArray[0];
                n2 = (Integer)objectArray[1];
            }
            for (int i3 = n = Math.min(arg1.length(), arg2 + n2); i3 > arg2; --i3) {
                String string = ((Object)arg1.subSequence(arg2, i3)).toString();
                if (!map.containsKey(string)) continue;
                arg0.saveField(this.iFieldType, string, locale);
                return i3;
            }
            return ~arg2;
        }

        public void printTo(Appendable arg0, ReadablePartial arg1, Locale arg2) throws IOException {
            try {
                arg0.append(this.print(arg1, arg2));
            }
            catch (RuntimeException runtimeException) {
                arg0.append('\ufffd');
            }
        }

        public void printTo(Appendable arg0, long arg1, Chronology arg2, int arg3, DateTimeZone arg4, Locale arg5) throws IOException {
            try {
                arg0.append(this.print(arg1, arg2, arg5));
            }
            catch (RuntimeException runtimeException) {
                arg0.append('\ufffd');
            }
        }
    }

    static class TwoDigitYear
    implements InternalPrinter,
    InternalParser {
        private final DateTimeFieldType iType;
        private final boolean iLenientParse;
        private final int iPivot;

        public void printTo(Appendable arg0, long arg1, Chronology arg2, int arg3, DateTimeZone arg4, Locale arg5) throws IOException {
            int n = this.getTwoDigitYear(arg1, arg2);
            if (n < 0) {
                arg0.append('\ufffd');
                arg0.append('\ufffd');
            } else {
                FormatUtils.appendPaddedInteger(arg0, n, 2);
            }
        }

        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            int n;
            int n2;
            char c2;
            int n3;
            int n4 = arg1.length() - arg2;
            if (!this.iLenientParse) {
                if ((n4 = Math.min(2, n4)) < 2) {
                    return ~arg2;
                }
            } else {
                n3 = 0;
                c2 = '\u0000';
                n2 = 0;
                while (n2 < n4) {
                    n = arg1.charAt(arg2 + n2);
                    if (n2 == 0 && (n == 45 || n == 43)) {
                        n3 = 1;
                        char c3 = c2 = n == 45 ? (char)'\u0001' : '\u0000';
                        if (c2 != '\u0000') {
                            ++n2;
                            continue;
                        }
                        ++arg2;
                        --n4;
                        continue;
                    }
                    if (n < 48 || n > 57) break;
                    ++n2;
                }
                if (n2 == 0) {
                    return ~arg2;
                }
                if (n3 != 0 || n2 != 2) {
                    if (n2 >= 9) {
                        n = Integer.parseInt(((Object)arg1.subSequence(arg2, arg2 += n2)).toString());
                    } else {
                        int n5 = arg2;
                        if (c2 != '\u0000') {
                            ++n5;
                        }
                        try {
                            n = arg1.charAt(n5++) - 48;
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            return ~arg2;
                        }
                        arg2 += n2;
                        while (n5 < arg2) {
                            n = (n << 3) + (n << 1) + arg1.charAt(n5++) - 48;
                        }
                        if (c2 != '\u0000') {
                            n = -n;
                        }
                    }
                    arg0.saveField(this.iType, n);
                    return arg2;
                }
            }
            if ((c2 = arg1.charAt(arg2)) < '0' || c2 > '9') {
                return ~arg2;
            }
            n3 = c2 - 48;
            c2 = arg1.charAt(arg2 + 1);
            if (c2 < '0' || c2 > '9') {
                return ~arg2;
            }
            n3 = (n3 << 3) + (n3 << 1) + c2 - 48;
            n2 = this.iPivot;
            if (arg0.getPivotYear() != null) {
                n2 = arg0.getPivotYear();
            }
            int n6 = (n = n2 - 50) >= 0 ? n % 100 : 99 + (n + 1) % 100;
            arg0.saveField(this.iType, n3 += n + (n3 < n6 ? 100 : 0) - n6);
            return arg2 + 2;
        }

        public int estimatePrintedLength() {
            return 2;
        }

        public void printTo(Appendable arg0, ReadablePartial arg1, Locale arg2) throws IOException {
            int n = this.getTwoDigitYear(arg1);
            if (n < 0) {
                arg0.append('\ufffd');
                arg0.append('\ufffd');
            } else {
                FormatUtils.appendPaddedInteger(arg0, n, 2);
            }
        }

        private int getTwoDigitYear(ReadablePartial a2) {
            TwoDigitYear a3;
            if (a2.isSupported(a3.iType)) {
                try {
                    int n = a2.get(a3.iType);
                    if (n < 0) {
                        n = -n;
                    }
                    return n % 100;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return -1;
        }

        public int estimateParsedLength() {
            return this.iLenientParse ? 4 : 2;
        }

        private int getTwoDigitYear(long a2, Chronology a3) {
            try {
                TwoDigitYear a4;
                int n = a4.iType.getField(a3).get(a2);
                if (n < 0) {
                    n = -n;
                }
                return n % 100;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }

        TwoDigitYear(DateTimeFieldType a2, int a3, boolean a4) {
            TwoDigitYear a5;
            a5.iType = a2;
            a5.iPivot = a3;
            a5.iLenientParse = a4;
        }
    }

    static class FixedNumber
    extends PaddedNumber {
        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            int n = super.parseInto(arg0, arg1, arg2);
            if (n < 0) {
                return n;
            }
            int n2 = arg2 + this.iMaxParsedDigits;
            if (n != n2) {
                char c2;
                if (this.iSigned && ((c2 = arg1.charAt(arg2)) == '-' || c2 == '+')) {
                    ++n2;
                }
                if (n > n2) {
                    return ~(n2 + 1);
                }
                if (n < n2) {
                    return ~n;
                }
            }
            return n;
        }

        protected FixedNumber(DateTimeFieldType arg0, int arg1, boolean arg2) {
            super(arg0, arg1, arg2, arg1);
        }
    }

    static class PaddedNumber
    extends NumberFormatter {
        protected final int iMinPrintedDigits;

        public void printTo(Appendable arg0, ReadablePartial arg1, Locale arg2) throws IOException {
            if (arg1.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.appendPaddedInteger(arg0, arg1.get(this.iFieldType), this.iMinPrintedDigits);
                }
                catch (RuntimeException runtimeException) {
                    DateTimeFormatterBuilder.appendUnknownString(arg0, this.iMinPrintedDigits);
                }
            } else {
                DateTimeFormatterBuilder.appendUnknownString(arg0, this.iMinPrintedDigits);
            }
        }

        public void printTo(Appendable arg0, long arg1, Chronology arg2, int arg3, DateTimeZone arg4, Locale arg5) throws IOException {
            try {
                DateTimeField dateTimeField = this.iFieldType.getField(arg2);
                FormatUtils.appendPaddedInteger(arg0, dateTimeField.get(arg1), this.iMinPrintedDigits);
            }
            catch (RuntimeException runtimeException) {
                DateTimeFormatterBuilder.appendUnknownString(arg0, this.iMinPrintedDigits);
            }
        }

        public int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        protected PaddedNumber(DateTimeFieldType arg0, int arg1, boolean arg2, int arg3) {
            super(arg0, arg1, arg2);
            this.iMinPrintedDigits = arg3;
        }
    }

    static class UnpaddedNumber
    extends NumberFormatter {
        public void printTo(Appendable arg0, long arg1, Chronology arg2, int arg3, DateTimeZone arg4, Locale arg5) throws IOException {
            try {
                DateTimeField dateTimeField = this.iFieldType.getField(arg2);
                FormatUtils.appendUnpaddedInteger(arg0, dateTimeField.get(arg1));
            }
            catch (RuntimeException runtimeException) {
                arg0.append('\ufffd');
            }
        }

        protected UnpaddedNumber(DateTimeFieldType arg0, int arg1, boolean arg2) {
            super(arg0, arg1, arg2);
        }

        public int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        public void printTo(Appendable arg0, ReadablePartial arg1, Locale arg2) throws IOException {
            if (arg1.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.appendUnpaddedInteger(arg0, arg1.get(this.iFieldType));
                }
                catch (RuntimeException runtimeException) {
                    arg0.append('\ufffd');
                }
            } else {
                arg0.append('\ufffd');
            }
        }
    }

    static abstract class NumberFormatter
    implements InternalPrinter,
    InternalParser {
        protected final DateTimeFieldType iFieldType;
        protected final boolean iSigned;
        protected final int iMaxParsedDigits;

        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            int n;
            int n2 = Math.min(this.iMaxParsedDigits, arg1.length() - arg2);
            boolean bl = false;
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < n2) {
                n = arg1.charAt(arg2 + n3);
                if (n3 == 0 && (n == 45 || n == 43) && this.iSigned) {
                    bl = n == 45;
                    boolean bl3 = bl2 = n == 43;
                    if (n3 + 1 >= n2) break;
                    char c2 = arg1.charAt(arg2 + n3 + 1);
                    n = c2;
                    if (c2 < '0' || n > 57) break;
                    ++n3;
                    n2 = Math.min(n2 + 1, arg1.length() - arg2);
                    continue;
                }
                if (n < 48 || n > 57) break;
                ++n3;
            }
            if (n3 == 0) {
                return ~arg2;
            }
            if (n3 >= 9) {
                n = bl2 ? Integer.parseInt(((Object)arg1.subSequence(arg2 + 1, arg2 += n3)).toString()) : Integer.parseInt(((Object)arg1.subSequence(arg2, arg2 += n3)).toString());
            } else {
                int n4 = arg2;
                if (bl || bl2) {
                    ++n4;
                }
                try {
                    n = arg1.charAt(n4++) - 48;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return ~arg2;
                }
                arg2 += n3;
                while (n4 < arg2) {
                    n = (n << 3) + (n << 1) + arg1.charAt(n4++) - 48;
                }
                if (bl) {
                    n = -n;
                }
            }
            arg0.saveField(this.iFieldType, n);
            return arg2;
        }

        NumberFormatter(DateTimeFieldType a2, int a3, boolean a4) {
            NumberFormatter a5;
            a5.iFieldType = a2;
            a5.iMaxParsedDigits = a3;
            a5.iSigned = a4;
        }

        public int estimateParsedLength() {
            return this.iMaxParsedDigits;
        }
    }

    static class StringLiteral
    implements InternalPrinter,
    InternalParser {
        private final String iValue;

        public int estimatePrintedLength() {
            return this.iValue.length();
        }

        StringLiteral(String a2) {
            StringLiteral a3;
            a3.iValue = a2;
        }

        public void printTo(Appendable arg0, long arg1, Chronology arg2, int arg3, DateTimeZone arg4, Locale arg5) throws IOException {
            arg0.append(this.iValue);
        }

        public int estimateParsedLength() {
            return this.iValue.length();
        }

        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            if (DateTimeFormatterBuilder.csStartsWithIgnoreCase(arg1, arg2, this.iValue)) {
                return arg2 + this.iValue.length();
            }
            return ~arg2;
        }

        public void printTo(Appendable arg0, ReadablePartial arg1, Locale arg2) throws IOException {
            arg0.append(this.iValue);
        }
    }

    static class CharacterLiteral
    implements InternalPrinter,
    InternalParser {
        private final char iValue;

        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            char c2;
            if (arg2 >= arg1.length()) {
                return ~arg2;
            }
            char c3 = arg1.charAt(arg2);
            if (c3 != (c2 = this.iValue) && (c3 = Character.toUpperCase(c3)) != (c2 = Character.toUpperCase(c2)) && (c3 = Character.toLowerCase(c3)) != (c2 = Character.toLowerCase(c2))) {
                return ~arg2;
            }
            return arg2 + 1;
        }

        public int estimateParsedLength() {
            return 1;
        }

        public int estimatePrintedLength() {
            return 1;
        }

        public void printTo(Appendable arg0, long arg1, Chronology arg2, int arg3, DateTimeZone arg4, Locale arg5) throws IOException {
            arg0.append(this.iValue);
        }

        CharacterLiteral(char a2) {
            CharacterLiteral a3;
            a3.iValue = a2;
        }

        public void printTo(Appendable arg0, ReadablePartial arg1, Locale arg2) throws IOException {
            arg0.append(this.iValue);
        }
    }
}

