/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ScaledDurationField;

public class RemainderDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 5708241235177666790L;
    final int iDivisor;
    final DurationField iRangeField;
    final DurationField iDurationField;

    public RemainderDateTimeField(DividedDateTimeField arg0) {
        this(arg0, arg0.getType());
    }

    public long addWrapField(long arg0, int arg1) {
        return this.set(arg0, FieldUtils.getWrappedValue(this.get(arg0), arg1, 0, this.iDivisor - 1));
    }

    public int get(long arg0) {
        int n = this.getWrappedField().get(arg0);
        if (n >= 0) {
            return n % this.iDivisor;
        }
        return this.iDivisor - 1 + (n + 1) % this.iDivisor;
    }

    public int getMaximumValue() {
        return this.iDivisor - 1;
    }

    public DurationField getDurationField() {
        return this.iDurationField;
    }

    public long roundCeiling(long arg0) {
        return this.getWrappedField().roundCeiling(arg0);
    }

    public long remainder(long arg0) {
        return this.getWrappedField().remainder(arg0);
    }

    public int getMinimumValue() {
        return 0;
    }

    public DurationField getRangeDurationField() {
        return this.iRangeField;
    }

    public long set(long arg0, int arg1) {
        FieldUtils.verifyValueBounds(this, arg1, 0, this.iDivisor - 1);
        int n = this.getDivided(this.getWrappedField().get(arg0));
        return this.getWrappedField().set(arg0, n * this.iDivisor + arg1);
    }

    public RemainderDateTimeField(DividedDateTimeField arg0, DateTimeFieldType arg1) {
        this(arg0, arg0.getWrappedField().getDurationField(), arg1);
    }

    private int getDivided(int a2) {
        RemainderDateTimeField a3;
        if (a2 >= 0) {
            return a2 / a3.iDivisor;
        }
        return (a2 + 1) / a3.iDivisor - 1;
    }

    public RemainderDateTimeField(DateTimeField arg0, DurationField arg1, DateTimeFieldType arg2, int arg3) {
        super(arg0, arg2);
        if (arg3 < 2) {
            throw new IllegalArgumentException("The divisor must be at least 2");
        }
        this.iRangeField = arg1;
        this.iDurationField = arg0.getDurationField();
        this.iDivisor = arg3;
    }

    public RemainderDateTimeField(DividedDateTimeField arg0, DurationField arg1, DateTimeFieldType arg2) {
        super(arg0.getWrappedField(), arg2);
        this.iDivisor = arg0.iDivisor;
        this.iDurationField = arg1;
        this.iRangeField = arg0.iDurationField;
    }

    public RemainderDateTimeField(DateTimeField arg0, DateTimeFieldType arg1, int arg2) {
        super(arg0, arg1);
        if (arg2 < 2) {
            throw new IllegalArgumentException("The divisor must be at least 2");
        }
        DurationField durationField = arg0.getDurationField();
        this.iRangeField = durationField == null ? null : new ScaledDurationField(durationField, arg1.getRangeDurationType(), arg2);
        this.iDurationField = arg0.getDurationField();
        this.iDivisor = arg2;
    }

    public long roundHalfCeiling(long arg0) {
        return this.getWrappedField().roundHalfCeiling(arg0);
    }

    public long roundHalfEven(long arg0) {
        return this.getWrappedField().roundHalfEven(arg0);
    }

    public int getDivisor() {
        return this.iDivisor;
    }

    public long roundHalfFloor(long arg0) {
        return this.getWrappedField().roundHalfFloor(arg0);
    }

    public long roundFloor(long arg0) {
        return this.getWrappedField().roundFloor(arg0);
    }
}

