/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.RemainderDateTimeField;
import org.joda.time.field.ScaledDurationField;

public class DividedDateTimeField
extends DecoratedDateTimeField {
    private final int iMax;
    private static final long serialVersionUID = 8318475124230605365L;
    final int iDivisor;
    final DurationField iRangeDurationField;
    final DurationField iDurationField;
    private final int iMin;

    public long getDifferenceAsLong(long arg0, long arg1) {
        return this.getWrappedField().getDifferenceAsLong(arg0, arg1) / (long)this.iDivisor;
    }

    private int getRemainder(int a2) {
        DividedDateTimeField a3;
        if (a2 >= 0) {
            return a2 % a3.iDivisor;
        }
        return a3.iDivisor - 1 + (a2 + 1) % a3.iDivisor;
    }

    public long roundFloor(long arg0) {
        DateTimeField dateTimeField = this.getWrappedField();
        return dateTimeField.roundFloor(dateTimeField.set(arg0, this.get(arg0) * this.iDivisor));
    }

    public DurationField getRangeDurationField() {
        if (this.iRangeDurationField != null) {
            return this.iRangeDurationField;
        }
        return super.getRangeDurationField();
    }

    public DurationField getDurationField() {
        return this.iDurationField;
    }

    public int getMinimumValue() {
        return this.iMin;
    }

    public DividedDateTimeField(DateTimeField arg0, DurationField arg1, DateTimeFieldType arg2, int arg3) {
        super(arg0, arg2);
        if (arg3 < 2) {
            throw new IllegalArgumentException("The divisor must be at least 2");
        }
        DurationField durationField = arg0.getDurationField();
        this.iDurationField = durationField == null ? null : new ScaledDurationField(durationField, arg2.getDurationType(), arg3);
        this.iRangeDurationField = arg1;
        this.iDivisor = arg3;
        int n = arg0.getMinimumValue();
        int n2 = n >= 0 ? n / arg3 : (n + 1) / arg3 - 1;
        int n3 = arg0.getMaximumValue();
        int n4 = n3 >= 0 ? n3 / arg3 : (n3 + 1) / arg3 - 1;
        this.iMin = n2;
        this.iMax = n4;
    }

    public int getDifference(long arg0, long arg1) {
        return this.getWrappedField().getDifference(arg0, arg1) / this.iDivisor;
    }

    public DividedDateTimeField(DateTimeField arg0, DateTimeFieldType arg1, int arg2) {
        this(arg0, arg0.getRangeDurationField(), arg1, arg2);
    }

    public long addWrapField(long arg0, int arg1) {
        return this.set(arg0, FieldUtils.getWrappedValue(this.get(arg0), arg1, this.iMin, this.iMax));
    }

    public long add(long arg0, int arg1) {
        return this.getWrappedField().add(arg0, arg1 * this.iDivisor);
    }

    public DividedDateTimeField(RemainderDateTimeField arg0, DurationField arg1, DateTimeFieldType arg2) {
        super(arg0.getWrappedField(), arg2);
        int n = this.iDivisor = arg0.iDivisor;
        this.iDurationField = arg0.iRangeField;
        this.iRangeDurationField = arg1;
        DateTimeField dateTimeField = this.getWrappedField();
        int n2 = dateTimeField.getMinimumValue();
        int n3 = n2 >= 0 ? n2 / n : (n2 + 1) / n - 1;
        int n4 = dateTimeField.getMaximumValue();
        int n5 = n4 >= 0 ? n4 / n : (n4 + 1) / n - 1;
        this.iMin = n3;
        this.iMax = n5;
    }

    public long set(long arg0, int arg1) {
        FieldUtils.verifyValueBounds(this, arg1, this.iMin, this.iMax);
        int n = this.getRemainder(this.getWrappedField().get(arg0));
        return this.getWrappedField().set(arg0, arg1 * this.iDivisor + n);
    }

    public DividedDateTimeField(RemainderDateTimeField arg0, DateTimeFieldType arg1) {
        this(arg0, null, arg1);
    }

    public int getDivisor() {
        return this.iDivisor;
    }

    public int get(long arg0) {
        int n = this.getWrappedField().get(arg0);
        if (n >= 0) {
            return n / this.iDivisor;
        }
        return (n + 1) / this.iDivisor - 1;
    }

    public long remainder(long arg0) {
        return this.set(arg0, this.get(this.getWrappedField().remainder(arg0)));
    }

    public int getMaximumValue() {
        return this.iMax;
    }

    public long add(long arg0, long arg1) {
        return this.getWrappedField().add(arg0, arg1 * (long)this.iDivisor);
    }
}

