/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.FieldUtils;

public abstract class BaseDurationField
extends DurationField
implements Serializable {
    private static final long serialVersionUID = -2554245107589433218L;
    private final DurationFieldType iType;

    public final DurationFieldType getType() {
        return this.iType;
    }

    public final boolean isSupported() {
        return true;
    }

    public final String getName() {
        return this.iType.getName();
    }

    public long getMillis(int arg0) {
        return (long)arg0 * this.getUnitMillis();
    }

    public long getMillis(long arg0) {
        return FieldUtils.safeMultiply(arg0, this.getUnitMillis());
    }

    public int compareTo(DurationField arg0) {
        long l2 = arg0.getUnitMillis();
        long l3 = this.getUnitMillis();
        if (l3 == l2) {
            return 0;
        }
        if (l3 < l2) {
            return -1;
        }
        return 1;
    }

    public int getValue(long arg0, long arg1) {
        return FieldUtils.safeToInt(this.getValueAsLong(arg0, arg1));
    }

    public String toString() {
        return "DurationField[" + this.getName() + ']';
    }

    public int getDifference(long arg0, long arg1) {
        return FieldUtils.safeToInt(this.getDifferenceAsLong(arg0, arg1));
    }

    protected BaseDurationField(DurationFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.iType = arg0;
    }

    public int getValue(long arg0) {
        return FieldUtils.safeToInt(this.getValueAsLong(arg0));
    }

    public long getValueAsLong(long arg0) {
        return arg0 / this.getUnitMillis();
    }
}

