/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadWritableInterval;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadableInterval;
import org.joda.time.convert.AbstractConverter;
import org.joda.time.convert.DurationConverter;
import org.joda.time.convert.IntervalConverter;
import org.joda.time.convert.PeriodConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReadableIntervalConverter
extends AbstractConverter
implements IntervalConverter,
DurationConverter,
PeriodConverter {
    static final ReadableIntervalConverter INSTANCE = new ReadableIntervalConverter();

    @Override
    public Class<?> getSupportedType() {
        return ReadableInterval.class;
    }

    @Override
    public boolean isReadableInterval(Object arg0, Chronology arg1) {
        return true;
    }

    @Override
    public void setInto(ReadWritableInterval arg0, Object arg1, Chronology arg2) {
        ReadableInterval readableInterval = (ReadableInterval)arg1;
        arg0.setInterval(readableInterval);
        if (arg2 != null) {
            arg0.setChronology(arg2);
        } else {
            arg0.setChronology(readableInterval.getChronology());
        }
    }

    @Override
    public long getDurationMillis(Object arg0) {
        return ((ReadableInterval)arg0).toDurationMillis();
    }

    protected ReadableIntervalConverter() {
    }

    @Override
    public void setInto(ReadWritablePeriod arg0, Object arg1, Chronology arg2) {
        ReadableInterval readableInterval = (ReadableInterval)arg1;
        arg2 = arg2 != null ? arg2 : DateTimeUtils.getIntervalChronology(readableInterval);
        long l2 = readableInterval.getStartMillis();
        long l3 = readableInterval.getEndMillis();
        int[] nArray = arg2.get(arg0, l2, l3);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arg0.setValue(i2, nArray[i2]);
        }
    }
}

