/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.IllegalInstantException;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.BaseDurationField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZonedChronology
extends AssembledChronology {
    private static final long NEAR_ZERO = 604800000L;
    private static final long serialVersionUID = -1079258847191166848L;

    private ZonedChronology(Chronology a2, DateTimeZone a3) {
        super(a2, a3);
        ZonedChronology a4;
    }

    private DurationField convertField(DurationField a2, HashMap<Object, Object> a3) {
        ZonedChronology a4;
        if (a2 == null || !a2.isSupported()) {
            return a2;
        }
        if (a3.containsKey(a2)) {
            return (DurationField)a3.get(a2);
        }
        ZonedDurationField zonedDurationField = new ZonedDurationField(a2, a4.getZone());
        a3.put(a2, zonedDurationField);
        return zonedDurationField;
    }

    @Override
    protected void assemble(AssembledChronology.Fields arg0) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        arg0.eras = this.convertField(arg0.eras, hashMap);
        arg0.centuries = this.convertField(arg0.centuries, hashMap);
        arg0.years = this.convertField(arg0.years, hashMap);
        arg0.months = this.convertField(arg0.months, hashMap);
        arg0.weekyears = this.convertField(arg0.weekyears, hashMap);
        arg0.weeks = this.convertField(arg0.weeks, hashMap);
        arg0.days = this.convertField(arg0.days, hashMap);
        arg0.halfdays = this.convertField(arg0.halfdays, hashMap);
        arg0.hours = this.convertField(arg0.hours, hashMap);
        arg0.minutes = this.convertField(arg0.minutes, hashMap);
        arg0.seconds = this.convertField(arg0.seconds, hashMap);
        arg0.millis = this.convertField(arg0.millis, hashMap);
        arg0.year = this.convertField(arg0.year, hashMap);
        arg0.yearOfEra = this.convertField(arg0.yearOfEra, hashMap);
        arg0.yearOfCentury = this.convertField(arg0.yearOfCentury, hashMap);
        arg0.centuryOfEra = this.convertField(arg0.centuryOfEra, hashMap);
        arg0.era = this.convertField(arg0.era, hashMap);
        arg0.dayOfWeek = this.convertField(arg0.dayOfWeek, hashMap);
        arg0.dayOfMonth = this.convertField(arg0.dayOfMonth, hashMap);
        arg0.dayOfYear = this.convertField(arg0.dayOfYear, hashMap);
        arg0.monthOfYear = this.convertField(arg0.monthOfYear, hashMap);
        arg0.weekOfWeekyear = this.convertField(arg0.weekOfWeekyear, hashMap);
        arg0.weekyear = this.convertField(arg0.weekyear, hashMap);
        arg0.weekyearOfCentury = this.convertField(arg0.weekyearOfCentury, hashMap);
        arg0.millisOfSecond = this.convertField(arg0.millisOfSecond, hashMap);
        arg0.millisOfDay = this.convertField(arg0.millisOfDay, hashMap);
        arg0.secondOfMinute = this.convertField(arg0.secondOfMinute, hashMap);
        arg0.secondOfDay = this.convertField(arg0.secondOfDay, hashMap);
        arg0.minuteOfHour = this.convertField(arg0.minuteOfHour, hashMap);
        arg0.minuteOfDay = this.convertField(arg0.minuteOfDay, hashMap);
        arg0.hourOfDay = this.convertField(arg0.hourOfDay, hashMap);
        arg0.hourOfHalfday = this.convertField(arg0.hourOfHalfday, hashMap);
        arg0.clockhourOfDay = this.convertField(arg0.clockhourOfDay, hashMap);
        arg0.clockhourOfHalfday = this.convertField(arg0.clockhourOfHalfday, hashMap);
        arg0.halfdayOfDay = this.convertField(arg0.halfdayOfDay, hashMap);
    }

    public static ZonedChronology getInstance(Chronology arg0, DateTimeZone arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        if ((arg0 = arg0.withUTC()) == null) {
            throw new IllegalArgumentException("UTC chronology must not be null");
        }
        if (arg1 == null) {
            throw new IllegalArgumentException("DateTimeZone must not be null");
        }
        return new ZonedChronology(arg0, arg1);
    }

    private DateTimeField convertField(DateTimeField a2, HashMap<Object, Object> a3) {
        ZonedChronology a4;
        if (a2 == null || !a2.isSupported()) {
            return a2;
        }
        if (a3.containsKey(a2)) {
            return (DateTimeField)a3.get(a2);
        }
        ZonedDateTimeField zonedDateTimeField = new ZonedDateTimeField(a2, a4.getZone(), a4.convertField(a2.getDurationField(), a3), a4.convertField(a2.getRangeDurationField(), a3), a4.convertField(a2.getLeapDurationField(), a3));
        a3.put(a2, zonedDateTimeField);
        return zonedDateTimeField;
    }

    @Override
    public long getDateTimeMillis(int arg0, int arg1, int arg2, int arg3) throws IllegalArgumentException {
        return this.localToUTC(this.getBase().getDateTimeMillis(arg0, arg1, arg2, arg3));
    }

    private long localToUTC(long a2) {
        ZonedChronology a3;
        if (a2 == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        if (a2 == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        DateTimeZone dateTimeZone = a3.getZone();
        int n = dateTimeZone.getOffsetFromLocal(a2);
        long l2 = a2 - (long)n;
        if (a2 > 604800000L && l2 < 0L) {
            return Long.MAX_VALUE;
        }
        if (a2 < -604800000L && l2 > 0L) {
            return Long.MIN_VALUE;
        }
        int n2 = dateTimeZone.getOffset(l2);
        if (n != n2) {
            throw new IllegalInstantException(a2, dateTimeZone.getID());
        }
        return l2;
    }

    @Override
    public long getDateTimeMillis(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) throws IllegalArgumentException {
        return this.localToUTC(this.getBase().getDateTimeMillis(arg0, arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public int hashCode() {
        return 326565 + this.getZone().hashCode() * 11 + this.getBase().hashCode() * 7;
    }

    @Override
    public String toString() {
        return "ZonedChronology[" + this.getBase() + ", " + this.getZone().getID() + ']';
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof ZonedChronology)) {
            return false;
        }
        ZonedChronology zonedChronology = (ZonedChronology)arg0;
        return this.getBase().equals(zonedChronology.getBase()) && this.getZone().equals(zonedChronology.getZone());
    }

    @Override
    public long getDateTimeMillis(long arg0, int arg1, int arg2, int arg3, int arg4) throws IllegalArgumentException {
        return this.localToUTC(this.getBase().getDateTimeMillis(arg0 + (long)this.getZone().getOffset(arg0), arg1, arg2, arg3, arg4));
    }

    @Override
    public DateTimeZone getZone() {
        return (DateTimeZone)this.getParam();
    }

    @Override
    public Chronology withZone(DateTimeZone arg0) {
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if (arg0 == this.getParam()) {
            return this;
        }
        if (arg0 == DateTimeZone.UTC) {
            return this.getBase();
        }
        return new ZonedChronology(this.getBase(), arg0);
    }

    static boolean useTimeArithmetic(DurationField a2) {
        return a2 != null && a2.getUnitMillis() < 43200000L;
    }

    @Override
    public Chronology withUTC() {
        return this.getBase();
    }

    static final class ZonedDateTimeField
    extends BaseDateTimeField {
        final DurationField iRangeDurationField;
        final DateTimeField iField;
        final boolean iTimeField;
        private static final long serialVersionUID = -3968986277775529794L;
        final DateTimeZone iZone;
        final DurationField iLeapDurationField;
        final DurationField iDurationField;

        public final DurationField getLeapDurationField() {
            return this.iLeapDurationField;
        }

        public int getLeapAmount(long arg0) {
            long l2 = this.iZone.convertUTCToLocal(arg0);
            return this.iField.getLeapAmount(l2);
        }

        public boolean isLeap(long arg0) {
            long l2 = this.iZone.convertUTCToLocal(arg0);
            return this.iField.isLeap(l2);
        }

        public long add(long arg0, long arg1) {
            if (this.iTimeField) {
                int n = this.getOffsetToAdd(arg0);
                long l2 = this.iField.add(arg0 + (long)n, arg1);
                return l2 - (long)n;
            }
            long l3 = this.iZone.convertUTCToLocal(arg0);
            l3 = this.iField.add(l3, arg1);
            return this.iZone.convertLocalToUTC(l3, false, arg0);
        }

        public int getMinimumValue(ReadablePartial arg0, int[] arg1) {
            return this.iField.getMinimumValue(arg0, arg1);
        }

        public String getAsShortText(int arg0, Locale arg1) {
            return this.iField.getAsShortText(arg0, arg1);
        }

        public long set(long arg0, String arg1, Locale arg2) {
            long l2 = this.iZone.convertUTCToLocal(arg0);
            l2 = this.iField.set(l2, arg1, arg2);
            return this.iZone.convertLocalToUTC(l2, false, arg0);
        }

        public int getMinimumValue() {
            return this.iField.getMinimumValue();
        }

        ZonedDateTimeField(DateTimeField a2, DateTimeZone a3, DurationField a4, DurationField a5, DurationField a6) {
            super(a2.getType());
            ZonedDateTimeField a7;
            if (!a2.isSupported()) {
                throw new IllegalArgumentException();
            }
            a7.iField = a2;
            a7.iZone = a3;
            a7.iDurationField = a4;
            a7.iTimeField = ZonedChronology.useTimeArithmetic(a4);
            a7.iRangeDurationField = a5;
            a7.iLeapDurationField = a6;
        }

        private int getOffsetToAdd(long a2) {
            ZonedDateTimeField a3;
            int n = a3.iZone.getOffset(a2);
            long l2 = a2 + (long)n;
            if ((a2 ^ l2) < 0L && (a2 ^ (long)n) >= 0L) {
                throw new ArithmeticException("Adding time zone offset caused overflow");
            }
            return n;
        }

        public long roundCeiling(long arg0) {
            if (this.iTimeField) {
                int n = this.getOffsetToAdd(arg0);
                arg0 = this.iField.roundCeiling(arg0 + (long)n);
                return arg0 - (long)n;
            }
            long l2 = this.iZone.convertUTCToLocal(arg0);
            l2 = this.iField.roundCeiling(l2);
            return this.iZone.convertLocalToUTC(l2, false, arg0);
        }

        public long roundFloor(long arg0) {
            if (this.iTimeField) {
                int n = this.getOffsetToAdd(arg0);
                arg0 = this.iField.roundFloor(arg0 + (long)n);
                return arg0 - (long)n;
            }
            long l2 = this.iZone.convertUTCToLocal(arg0);
            l2 = this.iField.roundFloor(l2);
            return this.iZone.convertLocalToUTC(l2, false, arg0);
        }

        public int getMaximumTextLength(Locale arg0) {
            return this.iField.getMaximumTextLength(arg0);
        }

        public int get(long arg0) {
            long l2 = this.iZone.convertUTCToLocal(arg0);
            return this.iField.get(l2);
        }

        public final DurationField getDurationField() {
            return this.iDurationField;
        }

        public int getDifference(long arg0, long arg1) {
            int n = this.getOffsetToAdd(arg1);
            return this.iField.getDifference(arg0 + (long)(this.iTimeField ? n : this.getOffsetToAdd(arg0)), arg1 + (long)n);
        }

        public final DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        public String getAsShortText(long arg0, Locale arg1) {
            long l2 = this.iZone.convertUTCToLocal(arg0);
            return this.iField.getAsShortText(l2, arg1);
        }

        public String getAsText(int arg0, Locale arg1) {
            return this.iField.getAsText(arg0, arg1);
        }

        public long remainder(long arg0) {
            long l2 = this.iZone.convertUTCToLocal(arg0);
            return this.iField.remainder(l2);
        }

        public int getMaximumValue(ReadablePartial arg0) {
            return this.iField.getMaximumValue(arg0);
        }

        public int getMaximumValue(ReadablePartial arg0, int[] arg1) {
            return this.iField.getMaximumValue(arg0, arg1);
        }

        public String getAsText(long arg0, Locale arg1) {
            long l2 = this.iZone.convertUTCToLocal(arg0);
            return this.iField.getAsText(l2, arg1);
        }

        public long getDifferenceAsLong(long arg0, long arg1) {
            int n = this.getOffsetToAdd(arg1);
            return this.iField.getDifferenceAsLong(arg0 + (long)(this.iTimeField ? n : this.getOffsetToAdd(arg0)), arg1 + (long)n);
        }

        public long addWrapField(long arg0, int arg1) {
            if (this.iTimeField) {
                int n = this.getOffsetToAdd(arg0);
                long l2 = this.iField.addWrapField(arg0 + (long)n, arg1);
                return l2 - (long)n;
            }
            long l3 = this.iZone.convertUTCToLocal(arg0);
            l3 = this.iField.addWrapField(l3, arg1);
            return this.iZone.convertLocalToUTC(l3, false, arg0);
        }

        public int getMinimumValue(ReadablePartial arg0) {
            return this.iField.getMinimumValue(arg0);
        }

        public int getMaximumValue(long arg0) {
            long l2 = this.iZone.convertUTCToLocal(arg0);
            return this.iField.getMaximumValue(l2);
        }

        public int hashCode() {
            return this.iField.hashCode() ^ this.iZone.hashCode();
        }

        public long add(long arg0, int arg1) {
            if (this.iTimeField) {
                int n = this.getOffsetToAdd(arg0);
                long l2 = this.iField.add(arg0 + (long)n, arg1);
                return l2 - (long)n;
            }
            long l3 = this.iZone.convertUTCToLocal(arg0);
            l3 = this.iField.add(l3, arg1);
            return this.iZone.convertLocalToUTC(l3, false, arg0);
        }

        public int getMaximumShortTextLength(Locale arg0) {
            return this.iField.getMaximumShortTextLength(arg0);
        }

        public boolean isLenient() {
            return this.iField.isLenient();
        }

        public boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 instanceof ZonedDateTimeField) {
                ZonedDateTimeField zonedDateTimeField = (ZonedDateTimeField)arg0;
                return this.iField.equals(zonedDateTimeField.iField) && this.iZone.equals(zonedDateTimeField.iZone) && this.iDurationField.equals(zonedDateTimeField.iDurationField) && this.iRangeDurationField.equals(zonedDateTimeField.iRangeDurationField);
            }
            return false;
        }

        public int getMaximumValue() {
            return this.iField.getMaximumValue();
        }

        public long set(long arg0, int arg1) {
            long l2 = this.iZone.convertUTCToLocal(arg0);
            long l3 = this.iZone.convertLocalToUTC(l2 = this.iField.set(l2, arg1), false, arg0);
            if (this.get(l3) != arg1) {
                IllegalInstantException illegalInstantException = new IllegalInstantException(l2, this.iZone.getID());
                IllegalFieldValueException illegalFieldValueException = new IllegalFieldValueException(this.iField.getType(), arg1, illegalInstantException.getMessage());
                illegalFieldValueException.initCause(illegalInstantException);
                throw illegalFieldValueException;
            }
            return l3;
        }

        public int getMinimumValue(long arg0) {
            long l2 = this.iZone.convertUTCToLocal(arg0);
            return this.iField.getMinimumValue(l2);
        }
    }

    static class ZonedDurationField
    extends BaseDurationField {
        final DateTimeZone iZone;
        final DurationField iField;
        final boolean iTimeField;
        private static final long serialVersionUID = -485345310999208286L;

        public long getUnitMillis() {
            return this.iField.getUnitMillis();
        }

        public long add(long arg0, long arg1) {
            int n = this.getOffsetToAdd(arg0);
            arg0 = this.iField.add(arg0 + (long)n, arg1);
            return arg0 - (long)(this.iTimeField ? n : this.getOffsetFromLocalToSubtract(arg0));
        }

        private long addOffset(long a2) {
            ZonedDurationField a3;
            return a3.iZone.convertUTCToLocal(a2);
        }

        public long getValueAsLong(long arg0, long arg1) {
            return this.iField.getValueAsLong(arg0, this.addOffset(arg1));
        }

        public int hashCode() {
            return this.iField.hashCode() ^ this.iZone.hashCode();
        }

        private int getOffsetFromLocalToSubtract(long a2) {
            ZonedDurationField a3;
            int n = a3.iZone.getOffsetFromLocal(a2);
            long l2 = a2 - (long)n;
            if ((a2 ^ l2) < 0L && (a2 ^ (long)n) < 0L) {
                throw new ArithmeticException("Subtracting time zone offset caused overflow");
            }
            return n;
        }

        public boolean isPrecise() {
            return this.iTimeField ? this.iField.isPrecise() : this.iField.isPrecise() && this.iZone.isFixed();
        }

        public long getMillis(long arg0, long arg1) {
            return this.iField.getMillis(arg0, this.addOffset(arg1));
        }

        private int getOffsetToAdd(long a2) {
            ZonedDurationField a3;
            int n = a3.iZone.getOffset(a2);
            long l2 = a2 + (long)n;
            if ((a2 ^ l2) < 0L && (a2 ^ (long)n) >= 0L) {
                throw new ArithmeticException("Adding time zone offset caused overflow");
            }
            return n;
        }

        public long getDifferenceAsLong(long arg0, long arg1) {
            int n = this.getOffsetToAdd(arg1);
            return this.iField.getDifferenceAsLong(arg0 + (long)(this.iTimeField ? n : this.getOffsetToAdd(arg0)), arg1 + (long)n);
        }

        public long add(long arg0, int arg1) {
            int n = this.getOffsetToAdd(arg0);
            arg0 = this.iField.add(arg0 + (long)n, arg1);
            return arg0 - (long)(this.iTimeField ? n : this.getOffsetFromLocalToSubtract(arg0));
        }

        public int getValue(long arg0, long arg1) {
            return this.iField.getValue(arg0, this.addOffset(arg1));
        }

        public long getMillis(int arg0, long arg1) {
            return this.iField.getMillis(arg0, this.addOffset(arg1));
        }

        ZonedDurationField(DurationField a2, DateTimeZone a3) {
            super(a2.getType());
            ZonedDurationField a4;
            if (!a2.isSupported()) {
                throw new IllegalArgumentException();
            }
            a4.iField = a2;
            a4.iTimeField = ZonedChronology.useTimeArithmetic(a2);
            a4.iZone = a3;
        }

        public boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 instanceof ZonedDurationField) {
                ZonedDurationField zonedDurationField = (ZonedDurationField)arg0;
                return this.iField.equals(zonedDurationField.iField) && this.iZone.equals(zonedDurationField.iZone);
            }
            return false;
        }

        public int getDifference(long arg0, long arg1) {
            int n = this.getOffsetToAdd(arg1);
            return this.iField.getDifference(arg0 + (long)(this.iTimeField ? n : this.getOffsetToAdd(arg0)), arg1 + (long)n);
        }
    }
}

