/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicGJChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.SkipDateTimeField;

public final class JulianChronology
extends BasicGJChronology {
    private static final int MIN_YEAR = -292269054;
    private static final JulianChronology INSTANCE_UTC;
    private static final long MILLIS_PER_MONTH = 2629800000L;
    private static final int MAX_YEAR = 292272992;
    private static final long MILLIS_PER_YEAR = 31557600000L;
    private static final ConcurrentHashMap<DateTimeZone, JulianChronology[]> cCache;
    private static final long serialVersionUID = -8731039522547897247L;

    int getMaxYear() {
        return 292272992;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JulianChronology getInstance(DateTimeZone arg0, int arg1) {
        JulianChronology julianChronology;
        JulianChronology[] julianChronologyArray;
        JulianChronology[] julianChronologyArray2;
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if ((julianChronologyArray2 = cCache.get(arg0)) == null && (julianChronologyArray = cCache.putIfAbsent(arg0, julianChronologyArray2 = new JulianChronology[7])) != null) {
            julianChronologyArray2 = julianChronologyArray;
        }
        try {
            julianChronology = julianChronologyArray2[arg1 - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid min days in first week: " + arg1);
        }
        if (julianChronology != null) return julianChronology;
        julianChronologyArray = julianChronologyArray2;
        synchronized (julianChronologyArray2) {
            julianChronology = julianChronologyArray2[arg1 - 1];
            if (julianChronology != null) return julianChronology;
            if (arg0 == DateTimeZone.UTC) {
                julianChronology = new JulianChronology(null, null, arg1);
            } else {
                julianChronology = JulianChronology.getInstance(DateTimeZone.UTC, arg1);
                julianChronology = new JulianChronology(ZonedChronology.getInstance(julianChronology, arg0), null, arg1);
            }
            julianChronologyArray2[arg1 - 1] = julianChronology;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return julianChronology;
        }
    }

    public static JulianChronology getInstance() {
        return JulianChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static JulianChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    long getAverageMillisPerYear() {
        return 31557600000L;
    }

    long getDateMidnightMillis(int a2, int a3, int a4) throws IllegalArgumentException {
        JulianChronology a5;
        return super.getDateMidnightMillis(JulianChronology.adjustYearForSet(a2), a3, a4);
    }

    long calculateFirstDayOfYearMillis(int a2) {
        int n;
        int n2 = a2 - 1968;
        if (n2 <= 0) {
            n = n2 + 3 >> 2;
        } else {
            JulianChronology a3;
            n = n2 >> 2;
            if (!a3.isLeapYear(a2)) {
                ++n;
            }
        }
        long l2 = ((long)n2 * 365L + (long)n) * 86400000L;
        return l2 - 62035200000L;
    }

    long getApproxMillisAtEpochDividedByTwo() {
        return 31083663600000L;
    }

    long getAverageMillisPerYearDividedByTwo() {
        return 15778800000L;
    }

    public static JulianChronology getInstance(DateTimeZone arg0) {
        return JulianChronology.getInstance(arg0, 4);
    }

    long getAverageMillisPerMonth() {
        return 2629800000L;
    }

    JulianChronology(Chronology a2, Object a3, int a4) {
        super(a2, a3, a4);
        JulianChronology a5;
    }

    public Chronology withZone(DateTimeZone arg0) {
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if (arg0 == this.getZone()) {
            return this;
        }
        return JulianChronology.getInstance(arg0);
    }

    private Object readResolve() {
        JulianChronology a2;
        Chronology chronology = a2.getBase();
        int n = a2.getMinimumDaysInFirstWeek();
        n = n == 0 ? 4 : n;
        return chronology == null ? JulianChronology.getInstance(DateTimeZone.UTC, n) : JulianChronology.getInstance(chronology.getZone(), n);
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    protected void assemble(AssembledChronology.Fields arg0) {
        if (this.getBase() == null) {
            super.assemble(arg0);
            arg0.year = new SkipDateTimeField(this, arg0.year);
            arg0.weekyear = new SkipDateTimeField(this, arg0.weekyear);
        }
    }

    boolean isLeapYear(int a2) {
        return (a2 & 3) == 0;
    }

    int getMinYear() {
        return -292269054;
    }

    static {
        cCache = new ConcurrentHashMap();
        INSTANCE_UTC = JulianChronology.getInstance(DateTimeZone.UTC);
    }

    static int adjustYearForSet(int a2) {
        if (a2 <= 0) {
            if (a2 == 0) {
                throw new IllegalFieldValueException(DateTimeFieldType.year(), (Number)a2, null, null);
            }
            ++a2;
        }
        return a2;
    }
}

