/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.chrono.ISOYearOfEraDateTimeField;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.RemainderDateTimeField;

public final class ISOChronology
extends AssembledChronology {
    private static final long serialVersionUID = -6212696554273812441L;
    private static final ISOChronology INSTANCE_UTC;
    private static final ConcurrentHashMap<DateTimeZone, ISOChronology> cCache;

    public static ISOChronology getInstance() {
        return ISOChronology.getInstance(DateTimeZone.getDefault());
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof ISOChronology) {
            ISOChronology iSOChronology = (ISOChronology)arg0;
            return this.getZone().equals(iSOChronology.getZone());
        }
        return false;
    }

    static {
        cCache = new ConcurrentHashMap();
        INSTANCE_UTC = new ISOChronology(GregorianChronology.getInstanceUTC());
        cCache.put(DateTimeZone.UTC, INSTANCE_UTC);
    }

    private ISOChronology(Chronology a2) {
        super(a2, null);
        ISOChronology a3;
    }

    public int hashCode() {
        return "ISO".hashCode() * 11 + this.getZone().hashCode();
    }

    public static ISOChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static ISOChronology getInstance(DateTimeZone arg0) {
        ISOChronology iSOChronology;
        ISOChronology iSOChronology2;
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if ((iSOChronology2 = cCache.get(arg0)) == null && (iSOChronology = cCache.putIfAbsent(arg0, iSOChronology2 = new ISOChronology(ZonedChronology.getInstance(INSTANCE_UTC, arg0)))) != null) {
            iSOChronology2 = iSOChronology;
        }
        return iSOChronology2;
    }

    public Chronology withZone(DateTimeZone arg0) {
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if (arg0 == this.getZone()) {
            return this;
        }
        return ISOChronology.getInstance(arg0);
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public String toString() {
        String string = "ISOChronology";
        DateTimeZone dateTimeZone = this.getZone();
        if (dateTimeZone != null) {
            string = string + '[' + dateTimeZone.getID() + ']';
        }
        return string;
    }

    private Object writeReplace() {
        ISOChronology a2;
        return new Stub(a2.getZone());
    }

    protected void assemble(AssembledChronology.Fields arg0) {
        if (this.getBase().getZone() == DateTimeZone.UTC) {
            arg0.centuryOfEra = new DividedDateTimeField(ISOYearOfEraDateTimeField.INSTANCE, DateTimeFieldType.centuryOfEra(), 100);
            arg0.centuries = arg0.centuryOfEra.getDurationField();
            arg0.yearOfCentury = new RemainderDateTimeField((DividedDateTimeField)arg0.centuryOfEra, DateTimeFieldType.yearOfCentury());
            arg0.weekyearOfCentury = new RemainderDateTimeField((DividedDateTimeField)arg0.centuryOfEra, arg0.weekyears, DateTimeFieldType.weekyearOfCentury());
        }
    }

    private static final class Stub
    implements Serializable {
        private static final long serialVersionUID = -6212696554273812441L;
        private transient DateTimeZone iZone;

        Stub(DateTimeZone a2) {
            Stub a3;
            a3.iZone = a2;
        }

        private Object readResolve() {
            Stub a2;
            return ISOChronology.getInstance(a2.iZone);
        }

        private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
            a.iZone = (DateTimeZone)a2.readObject();
        }

        private void writeObject(ObjectOutputStream a2) throws IOException {
            Stub a3;
            a2.writeObject(a3.iZone);
        }
    }
}

