/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.text.DateFormatSymbols;
import java.util.Locale;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.IllegalFieldValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GJLocaleSymbols {
    private final String[] iDaysOfWeek;
    private final int iMaxMonthLength;
    private final String[] iShortDaysOfWeek;
    private final TreeMap<String, Integer> iParseMonths;
    private final String[] iHalfday;
    private final TreeMap<String, Integer> iParseEras;
    private final int iMaxDayOfWeekLength;
    private final int iMaxHalfdayLength;
    private final int iMaxShortMonthLength;
    private final int iMaxEraLength;
    private final String[] iShortMonths;
    private final String[] iEras;
    private final String[] iMonths;
    private static ConcurrentMap<Locale, GJLocaleSymbols> cCache = new ConcurrentHashMap<Locale, GJLocaleSymbols>();
    private final TreeMap<String, Integer> iParseDaysOfWeek;
    private final int iMaxShortDayOfWeekLength;

    private static int maxLength(String[] a2) {
        int n = 0;
        int n2 = a2.length;
        while (--n2 >= 0) {
            int n3;
            String string = a2[n2];
            if (string == null || (n3 = string.length()) <= n) continue;
            n = n3;
        }
        return n;
    }

    public String dayOfWeekValueToText(int arg0) {
        return this.iDaysOfWeek[arg0];
    }

    public int getEraMaxTextLength() {
        return this.iMaxEraLength;
    }

    public String dayOfWeekValueToShortText(int arg0) {
        return this.iShortDaysOfWeek[arg0];
    }

    public String eraValueToText(int arg0) {
        return this.iEras[arg0];
    }

    public int getDayOfWeekMaxShortTextLength() {
        return this.iMaxShortDayOfWeekLength;
    }

    private static String[] realignDaysOfWeek(String[] a2) {
        String[] stringArray = new String[8];
        for (int i2 = 1; i2 < 8; ++i2) {
            stringArray[i2] = a2[i2 < 7 ? i2 + 1 : 1];
        }
        return stringArray;
    }

    public int getHalfdayMaxTextLength() {
        return this.iMaxHalfdayLength;
    }

    public int dayOfWeekTextToValue(String arg0) {
        Integer n = this.iParseDaysOfWeek.get(arg0);
        if (n != null) {
            return n;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.dayOfWeek(), arg0);
    }

    private GJLocaleSymbols(Locale a2) {
        GJLocaleSymbols a3;
        DateFormatSymbols dateFormatSymbols = DateTimeUtils.getDateFormatSymbols(a2);
        a3.iEras = dateFormatSymbols.getEras();
        a3.iDaysOfWeek = GJLocaleSymbols.realignDaysOfWeek(dateFormatSymbols.getWeekdays());
        a3.iShortDaysOfWeek = GJLocaleSymbols.realignDaysOfWeek(dateFormatSymbols.getShortWeekdays());
        a3.iMonths = GJLocaleSymbols.realignMonths(dateFormatSymbols.getMonths());
        a3.iShortMonths = GJLocaleSymbols.realignMonths(dateFormatSymbols.getShortMonths());
        a3.iHalfday = dateFormatSymbols.getAmPmStrings();
        Integer[] integerArray = new Integer[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            integerArray[i2] = i2;
        }
        a3.iParseEras = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(a3.iParseEras, a3.iEras, integerArray);
        if ("en".equals(a2.getLanguage())) {
            a3.iParseEras.put("BCE", integerArray[0]);
            a3.iParseEras.put("CE", integerArray[1]);
        }
        a3.iParseDaysOfWeek = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(a3.iParseDaysOfWeek, a3.iDaysOfWeek, integerArray);
        GJLocaleSymbols.addSymbols(a3.iParseDaysOfWeek, a3.iShortDaysOfWeek, integerArray);
        GJLocaleSymbols.addNumerals(a3.iParseDaysOfWeek, 1, 7, integerArray);
        a3.iParseMonths = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(a3.iParseMonths, a3.iMonths, integerArray);
        GJLocaleSymbols.addSymbols(a3.iParseMonths, a3.iShortMonths, integerArray);
        GJLocaleSymbols.addNumerals(a3.iParseMonths, 1, 12, integerArray);
        a3.iMaxEraLength = GJLocaleSymbols.maxLength(a3.iEras);
        a3.iMaxDayOfWeekLength = GJLocaleSymbols.maxLength(a3.iDaysOfWeek);
        a3.iMaxShortDayOfWeekLength = GJLocaleSymbols.maxLength(a3.iShortDaysOfWeek);
        a3.iMaxMonthLength = GJLocaleSymbols.maxLength(a3.iMonths);
        a3.iMaxShortMonthLength = GJLocaleSymbols.maxLength(a3.iShortMonths);
        a3.iMaxHalfdayLength = GJLocaleSymbols.maxLength(a3.iHalfday);
    }

    public String monthOfYearValueToText(int arg0) {
        return this.iMonths[arg0];
    }

    private static void addSymbols(TreeMap<String, Integer> a2, String[] a3, Integer[] a4) {
        int n = a3.length;
        while (--n >= 0) {
            String string = a3[n];
            if (string == null) continue;
            a2.put(string, a4[n]);
        }
    }

    public int monthOfYearTextToValue(String arg0) {
        Integer n = this.iParseMonths.get(arg0);
        if (n != null) {
            return n;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.monthOfYear(), arg0);
    }

    public int halfdayTextToValue(String arg0) {
        String[] stringArray = this.iHalfday;
        int n = stringArray.length;
        while (--n >= 0) {
            if (!stringArray[n].equalsIgnoreCase(arg0)) continue;
            return n;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.halfdayOfDay(), arg0);
    }

    public int getMonthMaxShortTextLength() {
        return this.iMaxShortMonthLength;
    }

    public String halfdayValueToText(int arg0) {
        return this.iHalfday[arg0];
    }

    public int getDayOfWeekMaxTextLength() {
        return this.iMaxDayOfWeekLength;
    }

    public int eraTextToValue(String arg0) {
        Integer n = this.iParseEras.get(arg0);
        if (n != null) {
            return n;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.era(), arg0);
    }

    static GJLocaleSymbols forLocale(Locale a2) {
        GJLocaleSymbols gJLocaleSymbols;
        GJLocaleSymbols gJLocaleSymbols2;
        if (a2 == null) {
            a2 = Locale.getDefault();
        }
        if ((gJLocaleSymbols2 = (GJLocaleSymbols)cCache.get(a2)) == null && (gJLocaleSymbols = cCache.putIfAbsent(a2, gJLocaleSymbols2 = new GJLocaleSymbols(a2))) != null) {
            gJLocaleSymbols2 = gJLocaleSymbols;
        }
        return gJLocaleSymbols2;
    }

    private static void addNumerals(TreeMap<String, Integer> a2, int a3, int a4, Integer[] a5) {
        for (int i2 = a3; i2 <= a4; ++i2) {
            a2.put(String.valueOf(i2).intern(), a5[i2]);
        }
    }

    private static String[] realignMonths(String[] a2) {
        String[] stringArray = new String[13];
        for (int i2 = 1; i2 < 13; ++i2) {
            stringArray[i2] = a2[i2 - 1];
        }
        return stringArray;
    }

    public String monthOfYearValueToShortText(int arg0) {
        return this.iShortMonths[arg0];
    }

    public int getMonthMaxTextLength() {
        return this.iMaxMonthLength;
    }
}

