/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ImpreciseDateTimeField;

class BasicYearDateTimeField
extends ImpreciseDateTimeField {
    private static final long serialVersionUID = -98628754872287L;
    protected final BasicChronology iChronology;

    public long add(long arg0, int arg1) {
        if (arg1 == 0) {
            return arg0;
        }
        int n = this.get(arg0);
        int n2 = FieldUtils.safeAdd(n, arg1);
        return this.set(arg0, n2);
    }

    public int getMinimumValue() {
        return this.iChronology.getMinYear();
    }

    private Object readResolve() {
        BasicYearDateTimeField a2;
        return a2.iChronology.year();
    }

    public DurationField getLeapDurationField() {
        return this.iChronology.days();
    }

    public DurationField getRangeDurationField() {
        return null;
    }

    public boolean isLenient() {
        return false;
    }

    public int getMaximumValue() {
        return this.iChronology.getMaxYear();
    }

    public long roundCeiling(long arg0) {
        int n = this.get(arg0);
        long l2 = this.iChronology.getYearMillis(n);
        if (arg0 != l2) {
            arg0 = this.iChronology.getYearMillis(n + 1);
        }
        return arg0;
    }

    public long getDifferenceAsLong(long arg0, long arg1) {
        if (arg0 < arg1) {
            return -this.iChronology.getYearDifference(arg1, arg0);
        }
        return this.iChronology.getYearDifference(arg0, arg1);
    }

    public long roundFloor(long arg0) {
        return this.iChronology.getYearMillis(this.get(arg0));
    }

    public long addWrapField(long arg0, int arg1) {
        if (arg1 == 0) {
            return arg0;
        }
        int n = this.iChronology.getYear(arg0);
        int n2 = FieldUtils.getWrappedValue(n, arg1, this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        return this.set(arg0, n2);
    }

    public long remainder(long arg0) {
        return arg0 - this.roundFloor(arg0);
    }

    BasicYearDateTimeField(BasicChronology a2) {
        super(DateTimeFieldType.year(), a2.getAverageMillisPerYear());
        BasicYearDateTimeField a3;
        a3.iChronology = a2;
    }

    public int get(long arg0) {
        return this.iChronology.getYear(arg0);
    }

    public long add(long arg0, long arg1) {
        return this.add(arg0, FieldUtils.safeToInt(arg1));
    }

    public long set(long arg0, int arg1) {
        FieldUtils.verifyValueBounds(this, arg1, this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        return this.iChronology.setYear(arg0, arg1);
    }

    public boolean isLeap(long arg0) {
        return this.iChronology.isLeapYear(this.get(arg0));
    }

    public int getLeapAmount(long arg0) {
        if (this.iChronology.isLeapYear(this.get(arg0))) {
            return 1;
        }
        return 0;
    }

    public long setExtended(long arg0, int arg1) {
        FieldUtils.verifyValueBounds(this, arg1, this.iChronology.getMinYear() - 1, this.iChronology.getMaxYear() + 1);
        return this.iChronology.setYear(arg0, arg1);
    }
}

