/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.Chronology;
import org.joda.time.chrono.BasicChronology;

abstract class BasicFixedMonthChronology
extends BasicChronology {
    private static final long serialVersionUID = 261387371998L;
    static final long MILLIS_PER_YEAR = 31557600000L;
    static final long MILLIS_PER_MONTH = 2592000000L;
    static final int MONTH_LENGTH = 30;

    int getDaysInMonthMax(int a2) {
        return a2 != 13 ? 30 : 6;
    }

    long getYearDifference(long a2, long a3) {
        BasicFixedMonthChronology a4;
        int n = a4.getYear(a2);
        int n2 = a4.getYear(a3);
        long l2 = a2 - a4.getYearMillis(n);
        long l3 = a3 - a4.getYearMillis(n2);
        int n3 = n - n2;
        if (l2 < l3) {
            --n3;
        }
        return n3;
    }

    long getAverageMillisPerYearDividedByTwo() {
        return 15778800000L;
    }

    BasicFixedMonthChronology(Chronology a2, Object a3, int a4) {
        super(a2, a3, a4);
        BasicFixedMonthChronology a5;
    }

    int getMonthOfYear(long a2, int a3) {
        BasicFixedMonthChronology a4;
        long l2 = (a2 - a4.getYearMillis(a3)) / 2592000000L;
        return (int)l2 + 1;
    }

    boolean isLeapYear(int a2) {
        return (a2 & 3) == 3;
    }

    long getTotalMillisByYearMonth(int a2, int a3) {
        return (long)(a3 - 1) * 2592000000L;
    }

    long getAverageMillisPerMonth() {
        return 2592000000L;
    }

    int getDaysInYearMonth(int a2, int a3) {
        BasicFixedMonthChronology a4;
        return a3 != 13 ? 30 : (a4.isLeapYear(a2) ? 6 : 5);
    }

    int getMonthOfYear(long a2) {
        BasicFixedMonthChronology a3;
        return (a3.getDayOfYear(a2) - 1) / 30 + 1;
    }

    int getDayOfMonth(long a2) {
        BasicFixedMonthChronology a3;
        return (a3.getDayOfYear(a2) - 1) % 30 + 1;
    }

    long setYear(long a2, int a3) {
        BasicFixedMonthChronology a4;
        int n = a4.getYear(a2);
        int n2 = a4.getDayOfYear(a2, n);
        int n3 = a4.getMillisOfDay(a2);
        if (n2 > 365 && !a4.isLeapYear(a3)) {
            --n2;
        }
        a2 = a4.getYearMonthDayMillis(a3, 1, n2);
        return a2 += (long)n3;
    }

    int getDaysInMonthMax() {
        return 30;
    }

    int getMaxMonth() {
        return 13;
    }

    long getAverageMillisPerYear() {
        return 31557600000L;
    }
}

