/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.util.Date;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class AbstractInstant
implements ReadableInstant {
    public DateTime toDateTime(DateTimeZone arg0) {
        Chronology chronology = DateTimeUtils.getChronology(this.getChronology());
        chronology = chronology.withZone(arg0);
        return new DateTime(this.getMillis(), chronology);
    }

    public int compareTo(ReadableInstant arg0) {
        if (this == arg0) {
            return 0;
        }
        long l2 = arg0.getMillis();
        long l3 = this.getMillis();
        if (l3 == l2) {
            return 0;
        }
        if (l3 < l2) {
            return -1;
        }
        return 1;
    }

    public DateTimeZone getZone() {
        return this.getChronology().getZone();
    }

    public boolean isEqual(long arg0) {
        return this.getMillis() == arg0;
    }

    public boolean isEqualNow() {
        return this.isEqual(DateTimeUtils.currentTimeMillis());
    }

    public Instant toInstant() {
        return new Instant(this.getMillis());
    }

    public int get(DateTimeFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        return arg0.getField(this.getChronology()).get(this.getMillis());
    }

    public boolean isBeforeNow() {
        return this.isBefore(DateTimeUtils.currentTimeMillis());
    }

    public boolean isSupported(DateTimeFieldType arg0) {
        if (arg0 == null) {
            return false;
        }
        return arg0.getField(this.getChronology()).isSupported();
    }

    public String toString(DateTimeFormatter arg0) {
        if (arg0 == null) {
            return this.toString();
        }
        return arg0.print(this);
    }

    public boolean isAfter(ReadableInstant arg0) {
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        return this.isAfter(l2);
    }

    public boolean isBefore(long arg0) {
        return this.getMillis() < arg0;
    }

    public boolean isBefore(ReadableInstant arg0) {
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        return this.isBefore(l2);
    }

    public Date toDate() {
        return new Date(this.getMillis());
    }

    public DateTime toDateTimeISO() {
        return new DateTime(this.getMillis(), (Chronology)ISOChronology.getInstance(this.getZone()));
    }

    public MutableDateTime toMutableDateTime(DateTimeZone arg0) {
        Chronology chronology = DateTimeUtils.getChronology(this.getChronology());
        chronology = chronology.withZone(arg0);
        return new MutableDateTime(this.getMillis(), chronology);
    }

    public MutableDateTime toMutableDateTimeISO() {
        return new MutableDateTime(this.getMillis(), (Chronology)ISOChronology.getInstance(this.getZone()));
    }

    public boolean isEqual(ReadableInstant arg0) {
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        return this.isEqual(l2);
    }

    @ToString
    public String toString() {
        return ISODateTimeFormat.dateTime().print(this);
    }

    public MutableDateTime toMutableDateTime() {
        return new MutableDateTime(this.getMillis(), this.getZone());
    }

    public DateTime toDateTime(Chronology arg0) {
        return new DateTime(this.getMillis(), arg0);
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof ReadableInstant)) {
            return false;
        }
        ReadableInstant readableInstant = (ReadableInstant)arg0;
        return this.getMillis() == readableInstant.getMillis() && FieldUtils.equals(this.getChronology(), readableInstant.getChronology());
    }

    public boolean isAfterNow() {
        return this.isAfter(DateTimeUtils.currentTimeMillis());
    }

    public boolean isAfter(long arg0) {
        return this.getMillis() > arg0;
    }

    protected AbstractInstant() {
    }

    public int get(DateTimeField arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The DateTimeField must not be null");
        }
        return arg0.get(this.getMillis());
    }

    public int hashCode() {
        return (int)(this.getMillis() ^ this.getMillis() >>> 32) + this.getChronology().hashCode();
    }

    public DateTime toDateTime() {
        return new DateTime(this.getMillis(), this.getZone());
    }

    public MutableDateTime toMutableDateTime(Chronology arg0) {
        return new MutableDateTime(this.getMillis(), arg0);
    }
}

