/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseInterval;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Interval
extends BaseInterval
implements ReadableInterval,
Serializable {
    private static final long serialVersionUID = 4922451897541386752L;

    public Interval withStartMillis(long arg0) {
        if (arg0 == this.getStartMillis()) {
            return this;
        }
        return new Interval(arg0, this.getEndMillis(), this.getChronology());
    }

    public Interval(long arg0, long arg1, Chronology arg2) {
        super(arg0, arg1, arg2);
    }

    public Interval(long arg0, long arg1) {
        super(arg0, arg1, null);
    }

    public Interval withDurationBeforeEnd(ReadableDuration arg0) {
        long l2 = DateTimeUtils.getDurationMillis(arg0);
        if (l2 == this.toDurationMillis()) {
            return this;
        }
        Chronology chronology = this.getChronology();
        long l3 = this.getEndMillis();
        long l4 = chronology.add(l3, l2, -1);
        return new Interval(l4, l3, chronology);
    }

    public Interval toInterval() {
        return this;
    }

    public Interval withDurationAfterStart(ReadableDuration arg0) {
        long l2 = DateTimeUtils.getDurationMillis(arg0);
        if (l2 == this.toDurationMillis()) {
            return this;
        }
        Chronology chronology = this.getChronology();
        long l3 = this.getStartMillis();
        long l4 = chronology.add(l3, l2, 1);
        return new Interval(l3, l4, chronology);
    }

    public Interval(Object arg0) {
        super(arg0, null);
    }

    public boolean abuts(ReadableInterval arg0) {
        if (arg0 == null) {
            long l2 = DateTimeUtils.currentTimeMillis();
            return this.getStartMillis() == l2 || this.getEndMillis() == l2;
        }
        return arg0.getEndMillis() == this.getStartMillis() || this.getEndMillis() == arg0.getStartMillis();
    }

    public Interval(ReadablePeriod arg0, ReadableInstant arg1) {
        super(arg0, arg1);
    }

    public Interval withPeriodBeforeEnd(ReadablePeriod arg0) {
        if (arg0 == null) {
            return this.withDurationBeforeEnd(null);
        }
        Chronology chronology = this.getChronology();
        long l2 = this.getEndMillis();
        long l3 = chronology.add(arg0, l2, -1);
        return new Interval(l3, l2, chronology);
    }

    public Interval withPeriodAfterStart(ReadablePeriod arg0) {
        if (arg0 == null) {
            return this.withDurationAfterStart(null);
        }
        Chronology chronology = this.getChronology();
        long l2 = this.getStartMillis();
        long l3 = chronology.add(arg0, l2, 1);
        return new Interval(l2, l3, chronology);
    }

    public Interval(Object arg0, Chronology arg1) {
        super(arg0, arg1);
    }

    public Interval withChronology(Chronology arg0) {
        if (this.getChronology() == arg0) {
            return this;
        }
        return new Interval(this.getStartMillis(), this.getEndMillis(), arg0);
    }

    public Interval withEnd(ReadableInstant arg0) {
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        return this.withEndMillis(l2);
    }

    public Interval gap(ReadableInterval arg0) {
        arg0 = DateTimeUtils.getReadableInterval(arg0);
        long l2 = arg0.getStartMillis();
        long l3 = arg0.getEndMillis();
        long l4 = this.getStartMillis();
        long l5 = this.getEndMillis();
        if (l4 > l3) {
            return new Interval(l3, l4, this.getChronology());
        }
        if (l2 > l5) {
            return new Interval(l5, l2, this.getChronology());
        }
        return null;
    }

    public static Interval parse(String arg0) {
        return new Interval(arg0);
    }

    public Interval withStart(ReadableInstant arg0) {
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        return this.withStartMillis(l2);
    }

    public Interval withEndMillis(long arg0) {
        if (arg0 == this.getEndMillis()) {
            return this;
        }
        return new Interval(this.getStartMillis(), arg0, this.getChronology());
    }

    public Interval(long arg0, long arg1, DateTimeZone arg2) {
        super(arg0, arg1, ISOChronology.getInstance(arg2));
    }

    public Interval(ReadableInstant arg0, ReadablePeriod arg1) {
        super(arg0, arg1);
    }

    public Interval(ReadableInstant arg0, ReadableDuration arg1) {
        super(arg0, arg1);
    }

    public static Interval parseWithOffset(String arg0) {
        int n = arg0.indexOf(47);
        if (n < 0) {
            throw new IllegalArgumentException("Format requires a '/' separator: " + arg0);
        }
        String string = arg0.substring(0, n);
        if (string.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + arg0);
        }
        String string2 = arg0.substring(n + 1);
        if (string2.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + arg0);
        }
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeParser().withOffsetParsed();
        PeriodFormatter periodFormatter = ISOPeriodFormat.standard();
        DateTime dateTime = null;
        Period period = null;
        char c2 = string.charAt(0);
        if (c2 == 'P' || c2 == 'p') {
            period = periodFormatter.withParseType(PeriodType.standard()).parsePeriod(string);
        } else {
            dateTime = dateTimeFormatter.parseDateTime(string);
        }
        c2 = string2.charAt(0);
        if (c2 == 'P' || c2 == 'p') {
            if (period != null) {
                throw new IllegalArgumentException("Interval composed of two durations: " + arg0);
            }
            period = periodFormatter.withParseType(PeriodType.standard()).parsePeriod(string2);
            return new Interval((ReadableInstant)dateTime, period);
        }
        DateTime dateTime2 = dateTimeFormatter.parseDateTime(string2);
        if (period != null) {
            return new Interval(period, (ReadableInstant)dateTime2);
        }
        return new Interval((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
    }

    public Interval(ReadableDuration arg0, ReadableInstant arg1) {
        super(arg0, arg1);
    }

    public Interval overlap(ReadableInterval arg0) {
        if (!this.overlaps(arg0 = DateTimeUtils.getReadableInterval(arg0))) {
            return null;
        }
        long l2 = Math.max(this.getStartMillis(), arg0.getStartMillis());
        long l3 = Math.min(this.getEndMillis(), arg0.getEndMillis());
        return new Interval(l2, l3, this.getChronology());
    }

    public Interval(ReadableInstant arg0, ReadableInstant arg1) {
        super(arg0, arg1);
    }
}

