/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.IllegalInstantException;
import org.joda.time.JodaTimePermission;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.UTCDateTimeZone;
import org.joda.time.chrono.BaseChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.FormatUtils;
import org.joda.time.tz.DefaultNameProvider;
import org.joda.time.tz.FixedDateTimeZone;
import org.joda.time.tz.NameProvider;
import org.joda.time.tz.Provider;
import org.joda.time.tz.UTCProvider;
import org.joda.time.tz.ZoneInfoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateTimeZone
implements Serializable {
    private static final AtomicReference<DateTimeZone> cDefault;
    private static final AtomicReference<Provider> cProvider;
    private static final long serialVersionUID = 5546345482340108586L;
    public static final DateTimeZone UTC;
    private static final AtomicReference<NameProvider> cNameProvider;
    private static final int MAX_MILLIS = 86399999;
    private final String iID;

    private static String getConvertedId(String a2) {
        return LazyInit.CONVERSION_MAP.get(a2);
    }

    @ToString
    public final String getID() {
        return this.iID;
    }

    public abstract boolean isFixed();

    public final int getOffset(ReadableInstant arg0) {
        if (arg0 == null) {
            return this.getOffset(DateTimeUtils.currentTimeMillis());
        }
        return this.getOffset(arg0.getMillis());
    }

    public static void setProvider(Provider arg0) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setProvider"));
        }
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefaultProvider();
        } else {
            DateTimeZone.validateProvider(arg0);
        }
        cProvider.set(arg0);
    }

    private static NameProvider getDefaultNameProvider() {
        NameProvider nameProvider;
        block5: {
            nameProvider = null;
            try {
                String string = System.getProperty("org.joda.time.DateTimeZone.NameProvider");
                if (string == null) break block5;
                try {
                    nameProvider = (NameProvider)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (nameProvider == null) {
            nameProvider = new DefaultNameProvider();
        }
        return nameProvider;
    }

    public static DateTimeZone forOffsetHoursMinutes(int arg0, int arg1) throws IllegalArgumentException {
        if (arg0 == 0 && arg1 == 0) {
            return UTC;
        }
        if (arg0 < -23 || arg0 > 23) {
            throw new IllegalArgumentException("Hours out of range: " + arg0);
        }
        if (arg1 < -59 || arg1 > 59) {
            throw new IllegalArgumentException("Minutes out of range: " + arg1);
        }
        if (arg0 > 0 && arg1 < 0) {
            throw new IllegalArgumentException("Positive hours must not have negative minutes: " + arg1);
        }
        int n = 0;
        try {
            int n2 = arg0 * 60;
            arg1 = n2 < 0 ? n2 - Math.abs(arg1) : n2 + arg1;
            n = FieldUtils.safeMultiply(arg1, 60000);
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("Offset is too large");
        }
        return DateTimeZone.forOffsetMillis(n);
    }

    private static DateTimeZone fixedOffsetZone(String a2, int a3) {
        if (a3 == 0) {
            return UTC;
        }
        return new FixedDateTimeZone(a2, null, a3, a3);
    }

    public abstract boolean equals(Object var1);

    public long convertLocalToUTC(long arg0, boolean arg1) {
        long l2;
        int n;
        int n2 = this.getOffset(arg0);
        if (n2 != (n = this.getOffset(arg0 - (long)n2)) && (arg1 || n2 < 0)) {
            long l3;
            l2 = this.nextTransition(arg0 - (long)n2);
            if (l2 == arg0 - (long)n2) {
                l2 = Long.MAX_VALUE;
            }
            if ((l3 = this.nextTransition(arg0 - (long)n)) == arg0 - (long)n) {
                l3 = Long.MAX_VALUE;
            }
            if (l2 != l3) {
                if (arg1) {
                    throw new IllegalInstantException(arg0, this.getID());
                }
                n = n2;
            }
        }
        if ((arg0 ^ (l2 = arg0 - (long)n)) < 0L && (arg0 ^ (long)n) < 0L) {
            throw new ArithmeticException("Subtracting time zone offset caused overflow");
        }
        return l2;
    }

    private static Provider getDefaultProvider() {
        Object object;
        try {
            object = System.getProperty("org.joda.time.DateTimeZone.Provider");
            if (object != null) {
                try {
                    Provider provider = (Provider)Class.forName((String)object).newInstance();
                    return DateTimeZone.validateProvider(provider);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            object = System.getProperty("org.joda.time.DateTimeZone.Folder");
            if (object != null) {
                try {
                    ZoneInfoProvider zoneInfoProvider = new ZoneInfoProvider(new File((String)object));
                    return DateTimeZone.validateProvider(zoneInfoProvider);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            object = new ZoneInfoProvider("org/joda/time/tz/data");
            return DateTimeZone.validateProvider((Provider)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new UTCProvider();
        }
    }

    static {
        UTC = UTCDateTimeZone.INSTANCE;
        cProvider = new AtomicReference();
        cNameProvider = new AtomicReference();
        cDefault = new AtomicReference();
    }

    public long getMillisKeepLocal(DateTimeZone arg0, long arg1) {
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefault();
        }
        if (arg0 == this) {
            return arg1;
        }
        long l2 = this.convertUTCToLocal(arg1);
        return arg0.convertLocalToUTC(l2, false, arg1);
    }

    protected DateTimeZone(String arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Id must not be null");
        }
        this.iID = arg0;
    }

    private static int parseOffset(String a2) {
        return -((int)LazyInit.OFFSET_FORMATTER.parseMillis(a2));
    }

    private static Provider validateProvider(Provider a2) {
        Set<String> set = a2.getAvailableIDs();
        if (set == null || set.size() == 0) {
            throw new IllegalArgumentException("The provider doesn't have any available ids");
        }
        if (!set.contains("UTC")) {
            throw new IllegalArgumentException("The provider doesn't support UTC");
        }
        if (!UTC.equals(a2.getZone("UTC"))) {
            throw new IllegalArgumentException("Invalid UTC zone provided");
        }
        return a2;
    }

    public static DateTimeZone forOffsetMillis(int arg0) {
        if (arg0 < -86399999 || arg0 > 86399999) {
            throw new IllegalArgumentException("Millis out of range: " + arg0);
        }
        String string = DateTimeZone.printOffset(arg0);
        return DateTimeZone.fixedOffsetZone(string, arg0);
    }

    public long adjustOffset(long arg0, boolean arg1) {
        long l2;
        long l3 = arg0 - 10800000L;
        long l4 = arg0 + 10800000L;
        long l5 = this.getOffset(l3);
        if (l5 <= (l2 = (long)this.getOffset(l4))) {
            return arg0;
        }
        long l6 = l5 - l2;
        long l7 = this.nextTransition(l3);
        long l8 = l7 - l6;
        long l9 = l7 + l6;
        if (arg0 < l8 || arg0 >= l9) {
            return arg0;
        }
        long l10 = arg0 - l8;
        if (l10 >= l6) {
            return arg1 ? arg0 : arg0 - l6;
        }
        return arg1 ? arg0 + l6 : arg0;
    }

    public long convertLocalToUTC(long arg0, boolean arg1, long arg2) {
        int n = this.getOffset(arg2);
        long l2 = arg0 - (long)n;
        int n2 = this.getOffset(l2);
        if (n2 == n) {
            return l2;
        }
        return this.convertLocalToUTC(arg0, arg1);
    }

    public int getOffsetFromLocal(long arg0) {
        int n;
        int n2;
        long l2;
        long l3;
        int n3;
        int n4 = this.getOffset(arg0);
        if (n4 != (n3 = this.getOffset(l3 = arg0 - (long)n4))) {
            if (n4 - n3 < 0) {
                long l4;
                long l5 = this.nextTransition(l3);
                if (l5 == arg0 - (long)n4) {
                    l5 = Long.MAX_VALUE;
                }
                if ((l4 = this.nextTransition(arg0 - (long)n3)) == arg0 - (long)n3) {
                    l4 = Long.MAX_VALUE;
                }
                if (l5 != l4) {
                    return n4;
                }
            }
        } else if (n4 >= 0 && (l2 = this.previousTransition(l3)) < l3 && l3 - l2 <= (long)(n2 = (n = this.getOffset(l2)) - n4)) {
            return n;
        }
        return n3;
    }

    public String getName(long arg0, Locale arg1) {
        String string;
        if (arg1 == null) {
            arg1 = Locale.getDefault();
        }
        if ((string = this.getNameKey(arg0)) == null) {
            return this.iID;
        }
        NameProvider nameProvider = DateTimeZone.getNameProvider();
        String string2 = nameProvider instanceof DefaultNameProvider ? ((DefaultNameProvider)nameProvider).getName(arg1, this.iID, string, this.isStandardOffset(arg0)) : nameProvider.getName(arg1, this.iID, string);
        if (string2 != null) {
            return string2;
        }
        return DateTimeZone.printOffset(this.getOffset(arg0));
    }

    public final String getShortName(long arg0) {
        return this.getShortName(arg0, null);
    }

    public abstract long nextTransition(long var1);

    public static DateTimeZone forTimeZone(TimeZone arg0) {
        if (arg0 == null) {
            return DateTimeZone.getDefault();
        }
        String string = arg0.getID();
        if (string == null) {
            throw new IllegalArgumentException("The TimeZone id must not be null");
        }
        if (string.equals("UTC")) {
            return UTC;
        }
        DateTimeZone dateTimeZone = null;
        String string2 = DateTimeZone.getConvertedId(string);
        Provider provider = DateTimeZone.getProvider();
        if (string2 != null) {
            dateTimeZone = provider.getZone(string2);
        }
        if (dateTimeZone == null) {
            dateTimeZone = provider.getZone(string);
        }
        if (dateTimeZone != null) {
            return dateTimeZone;
        }
        if (string2 == null && ((string2 = string).startsWith("GMT+") || string2.startsWith("GMT-"))) {
            int n = DateTimeZone.parseOffset(string2 = string2.substring(3));
            if ((long)n == 0L) {
                return UTC;
            }
            string2 = DateTimeZone.printOffset(n);
            return DateTimeZone.fixedOffsetZone(string2, n);
        }
        throw new IllegalArgumentException("The datetime zone id '" + string + "' is not recognised");
    }

    public abstract int getOffset(long var1);

    public String getShortName(long arg0, Locale arg1) {
        String string;
        if (arg1 == null) {
            arg1 = Locale.getDefault();
        }
        if ((string = this.getNameKey(arg0)) == null) {
            return this.iID;
        }
        NameProvider nameProvider = DateTimeZone.getNameProvider();
        String string2 = nameProvider instanceof DefaultNameProvider ? ((DefaultNameProvider)nameProvider).getShortName(arg1, this.iID, string, this.isStandardOffset(arg0)) : nameProvider.getShortName(arg1, this.iID, string);
        if (string2 != null) {
            return string2;
        }
        return DateTimeZone.printOffset(this.getOffset(arg0));
    }

    public abstract long previousTransition(long var1);

    public String toString() {
        return this.getID();
    }

    public static DateTimeZone getDefault() {
        DateTimeZone dateTimeZone = cDefault.get();
        if (dateTimeZone == null) {
            try {
                try {
                    String string = System.getProperty("user.timezone");
                    if (string != null) {
                        dateTimeZone = DateTimeZone.forID(string);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (dateTimeZone == null) {
                    dateTimeZone = DateTimeZone.forTimeZone(TimeZone.getDefault());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (dateTimeZone == null) {
                dateTimeZone = UTC;
            }
            if (!cDefault.compareAndSet(null, dateTimeZone)) {
                dateTimeZone = cDefault.get();
            }
        }
        return dateTimeZone;
    }

    public static Provider getProvider() {
        Provider provider = cProvider.get();
        if (provider == null && !cProvider.compareAndSet(null, provider = DateTimeZone.getDefaultProvider())) {
            provider = cProvider.get();
        }
        return provider;
    }

    public boolean isLocalDateTimeGap(LocalDateTime arg0) {
        if (this.isFixed()) {
            return false;
        }
        try {
            arg0.toDateTime(this);
            return false;
        }
        catch (IllegalInstantException illegalInstantException) {
            return true;
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Stub(this.iID);
    }

    public final String getName(long arg0) {
        return this.getName(arg0, null);
    }

    public static Set<String> getAvailableIDs() {
        return DateTimeZone.getProvider().getAvailableIDs();
    }

    public long convertUTCToLocal(long arg0) {
        int n = this.getOffset(arg0);
        long l2 = arg0 + (long)n;
        if ((arg0 ^ l2) < 0L && (arg0 ^ (long)n) >= 0L) {
            throw new ArithmeticException("Adding time zone offset caused overflow");
        }
        return l2;
    }

    public TimeZone toTimeZone() {
        return TimeZone.getTimeZone(this.iID);
    }

    public static void setNameProvider(NameProvider arg0) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setNameProvider"));
        }
        if (arg0 == null) {
            arg0 = DateTimeZone.getDefaultNameProvider();
        }
        cNameProvider.set(arg0);
    }

    public static NameProvider getNameProvider() {
        NameProvider nameProvider = cNameProvider.get();
        if (nameProvider == null && !cNameProvider.compareAndSet(null, nameProvider = DateTimeZone.getDefaultNameProvider())) {
            nameProvider = cNameProvider.get();
        }
        return nameProvider;
    }

    public boolean isStandardOffset(long arg0) {
        return this.getOffset(arg0) == this.getStandardOffset(arg0);
    }

    public abstract String getNameKey(long var1);

    private static String printOffset(int a2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (a2 >= 0) {
            stringBuffer.append('+');
        } else {
            stringBuffer.append('-');
            a2 = -a2;
        }
        int n = a2 / 3600000;
        FormatUtils.appendPaddedInteger(stringBuffer, n, 2);
        int n2 = (a2 -= n * 3600000) / 60000;
        stringBuffer.append(':');
        FormatUtils.appendPaddedInteger(stringBuffer, n2, 2);
        if ((a2 -= n2 * 60000) == 0) {
            return stringBuffer.toString();
        }
        int n3 = a2 / 1000;
        stringBuffer.append(':');
        FormatUtils.appendPaddedInteger(stringBuffer, n3, 2);
        if ((a2 -= n3 * 1000) == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append('.');
        FormatUtils.appendPaddedInteger(stringBuffer, a2, 3);
        return stringBuffer.toString();
    }

    @FromString
    public static DateTimeZone forID(String arg0) {
        if (arg0 == null) {
            return DateTimeZone.getDefault();
        }
        if (arg0.equals("UTC")) {
            return UTC;
        }
        DateTimeZone dateTimeZone = DateTimeZone.getProvider().getZone(arg0);
        if (dateTimeZone != null) {
            return dateTimeZone;
        }
        if (arg0.startsWith("+") || arg0.startsWith("-")) {
            int n = DateTimeZone.parseOffset(arg0);
            if ((long)n == 0L) {
                return UTC;
            }
            arg0 = DateTimeZone.printOffset(n);
            return DateTimeZone.fixedOffsetZone(arg0, n);
        }
        throw new IllegalArgumentException("The datetime zone id '" + arg0 + "' is not recognised");
    }

    public static void setDefault(DateTimeZone arg0) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setDefault"));
        }
        if (arg0 == null) {
            throw new IllegalArgumentException("The datetime zone must not be null");
        }
        cDefault.set(arg0);
    }

    public abstract int getStandardOffset(long var1);

    public static DateTimeZone forOffsetHours(int arg0) throws IllegalArgumentException {
        return DateTimeZone.forOffsetHoursMinutes(arg0, 0);
    }

    public int hashCode() {
        return 57 + this.getID().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LazyInit {
        static final DateTimeFormatter OFFSET_FORMATTER;
        static final Map<String, String> CONVERSION_MAP;

        private static DateTimeFormatter buildFormatter() {
            BaseChronology baseChronology = new BaseChronology(){
                private static final long serialVersionUID = -3128740902654445468L;

                public String toString() {
                    return this.getClass().getName();
                }

                public Chronology withUTC() {
                    return this;
                }
                {
                    1 a2;
                }

                public Chronology withZone(DateTimeZone arg0) {
                    return this;
                }

                public DateTimeZone getZone() {
                    return null;
                }
            };
            return new DateTimeFormatterBuilder().appendTimeZoneOffset(null, true, 2, 4).toFormatter().withChronology(baseChronology);
        }

        private static Map<String, String> buildMap() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("GMT", "UTC");
            hashMap.put("WET", "WET");
            hashMap.put("CET", "CET");
            hashMap.put("MET", "CET");
            hashMap.put("ECT", "CET");
            hashMap.put("EET", "EET");
            hashMap.put("MIT", "Pacific/Apia");
            hashMap.put("HST", "Pacific/Honolulu");
            hashMap.put("AST", "America/Anchorage");
            hashMap.put("PST", "America/Los_Angeles");
            hashMap.put("MST", "America/Denver");
            hashMap.put("PNT", "America/Phoenix");
            hashMap.put("CST", "America/Chicago");
            hashMap.put("EST", "America/New_York");
            hashMap.put("IET", "America/Indiana/Indianapolis");
            hashMap.put("PRT", "America/Puerto_Rico");
            hashMap.put("CNT", "America/St_Johns");
            hashMap.put("AGT", "America/Argentina/Buenos_Aires");
            hashMap.put("BET", "America/Sao_Paulo");
            hashMap.put("ART", "Africa/Cairo");
            hashMap.put("CAT", "Africa/Harare");
            hashMap.put("EAT", "Africa/Addis_Ababa");
            hashMap.put("NET", "Asia/Yerevan");
            hashMap.put("PLT", "Asia/Karachi");
            hashMap.put("IST", "Asia/Kolkata");
            hashMap.put("BST", "Asia/Dhaka");
            hashMap.put("VST", "Asia/Ho_Chi_Minh");
            hashMap.put("CTT", "Asia/Shanghai");
            hashMap.put("JST", "Asia/Tokyo");
            hashMap.put("ACT", "Australia/Darwin");
            hashMap.put("AET", "Australia/Sydney");
            hashMap.put("SST", "Pacific/Guadalcanal");
            hashMap.put("NST", "Pacific/Auckland");
            return Collections.unmodifiableMap(hashMap);
        }

        LazyInit() {
            LazyInit a2;
        }

        static {
            CONVERSION_MAP = LazyInit.buildMap();
            OFFSET_FORMATTER = LazyInit.buildFormatter();
        }
    }

    private static final class Stub
    implements Serializable {
        private static final long serialVersionUID = -6471952376487863581L;
        private transient String iID;

        private Object readResolve() throws ObjectStreamException {
            Stub a2;
            return DateTimeZone.forID(a2.iID);
        }

        Stub(String a2) {
            Stub a3;
            a3.iID = a2;
        }

        private void writeObject(ObjectOutputStream a2) throws IOException {
            Stub a3;
            a2.writeUTF(a3.iID);
        }

        private void readObject(ObjectInputStream a2) throws IOException {
            a.iID = a2.readUTF();
        }
    }
}

