/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;

public abstract class DateTimeFieldType
implements Serializable {
    static final byte MINUTE_OF_DAY = 18;
    static final byte SECOND_OF_MINUTE = 21;
    static final byte YEAR = 5;
    private static final DateTimeFieldType WEEKYEAR_OF_CENTURY_TYPE;
    private static final DateTimeFieldType ERA_TYPE;
    static final byte MONTH_OF_YEAR = 7;
    private static final DateTimeFieldType DAY_OF_WEEK_TYPE;
    private static final DateTimeFieldType HALFDAY_OF_DAY_TYPE;
    static final byte YEAR_OF_ERA = 2;
    private static final DateTimeFieldType YEAR_OF_CENTURY_TYPE;
    private static final DateTimeFieldType SECOND_OF_DAY_TYPE;
    static final byte HALFDAY_OF_DAY = 13;
    private static final DateTimeFieldType DAY_OF_MONTH_TYPE;
    static final byte HOUR_OF_DAY = 17;
    private static final DateTimeFieldType CLOCKHOUR_OF_HALFDAY_TYPE;
    static final byte YEAR_OF_CENTURY = 4;
    static final byte WEEKYEAR_OF_CENTURY = 9;
    static final byte MINUTE_OF_HOUR = 19;
    private final String iName;
    private static final DateTimeFieldType HOUR_OF_HALFDAY_TYPE;
    private static final DateTimeFieldType DAY_OF_YEAR_TYPE;
    static final byte CLOCKHOUR_OF_HALFDAY = 15;
    static final byte ERA = 1;
    private static final DateTimeFieldType CLOCKHOUR_OF_DAY_TYPE;
    private static final DateTimeFieldType MINUTE_OF_DAY_TYPE;
    private static final DateTimeFieldType WEEKYEAR_TYPE;
    private static final DateTimeFieldType WEEK_OF_WEEKYEAR_TYPE;
    private static final DateTimeFieldType MILLIS_OF_DAY_TYPE;
    static final byte MILLIS_OF_SECOND = 23;
    static final byte DAY_OF_MONTH = 8;
    private static final DateTimeFieldType YEAR_OF_ERA_TYPE;
    static final byte WEEKYEAR = 10;
    private static final DateTimeFieldType CENTURY_OF_ERA_TYPE;
    static final byte CLOCKHOUR_OF_DAY = 16;
    static final byte MILLIS_OF_DAY = 22;
    static final byte CENTURY_OF_ERA = 3;
    static final byte SECOND_OF_DAY = 20;
    private static final DateTimeFieldType YEAR_TYPE;
    static final byte DAY_OF_YEAR = 6;
    private static final DateTimeFieldType MINUTE_OF_HOUR_TYPE;
    private static final DateTimeFieldType HOUR_OF_DAY_TYPE;
    static final byte DAY_OF_WEEK = 12;
    private static final DateTimeFieldType MILLIS_OF_SECOND_TYPE;
    private static final DateTimeFieldType MONTH_OF_YEAR_TYPE;
    static final byte HOUR_OF_HALFDAY = 14;
    static final byte WEEK_OF_WEEKYEAR = 11;
    private static final long serialVersionUID = -42615285973990L;
    private static final DateTimeFieldType SECOND_OF_MINUTE_TYPE;

    public static DateTimeFieldType yearOfCentury() {
        return YEAR_OF_CENTURY_TYPE;
    }

    public String toString() {
        return this.getName();
    }

    public static DateTimeFieldType weekyearOfCentury() {
        return WEEKYEAR_OF_CENTURY_TYPE;
    }

    public static DateTimeFieldType halfdayOfDay() {
        return HALFDAY_OF_DAY_TYPE;
    }

    public static DateTimeFieldType hourOfDay() {
        return HOUR_OF_DAY_TYPE;
    }

    public static DateTimeFieldType dayOfYear() {
        return DAY_OF_YEAR_TYPE;
    }

    public static DateTimeFieldType dayOfMonth() {
        return DAY_OF_MONTH_TYPE;
    }

    public static DateTimeFieldType millisOfSecond() {
        return MILLIS_OF_SECOND_TYPE;
    }

    public static DateTimeFieldType era() {
        return ERA_TYPE;
    }

    public static DateTimeFieldType monthOfYear() {
        return MONTH_OF_YEAR_TYPE;
    }

    public static DateTimeFieldType year() {
        return YEAR_TYPE;
    }

    public static DateTimeFieldType yearOfEra() {
        return YEAR_OF_ERA_TYPE;
    }

    public static DateTimeFieldType centuryOfEra() {
        return CENTURY_OF_ERA_TYPE;
    }

    public static DateTimeFieldType dayOfWeek() {
        return DAY_OF_WEEK_TYPE;
    }

    protected DateTimeFieldType(String arg0) {
        this.iName = arg0;
    }

    public String getName() {
        return this.iName;
    }

    public static DateTimeFieldType weekOfWeekyear() {
        return WEEK_OF_WEEKYEAR_TYPE;
    }

    public boolean isSupported(Chronology arg0) {
        return this.getField(arg0).isSupported();
    }

    public static DateTimeFieldType clockhourOfDay() {
        return CLOCKHOUR_OF_DAY_TYPE;
    }

    public static DateTimeFieldType secondOfMinute() {
        return SECOND_OF_MINUTE_TYPE;
    }

    public static DateTimeFieldType minuteOfHour() {
        return MINUTE_OF_HOUR_TYPE;
    }

    public abstract DateTimeField getField(Chronology var1);

    public static DateTimeFieldType secondOfDay() {
        return SECOND_OF_DAY_TYPE;
    }

    public abstract DurationFieldType getDurationType();

    public static DateTimeFieldType weekyear() {
        return WEEKYEAR_TYPE;
    }

    public static DateTimeFieldType millisOfDay() {
        return MILLIS_OF_DAY_TYPE;
    }

    static {
        ERA_TYPE = new StandardDateTimeFieldType("era", 1, DurationFieldType.eras(), null);
        YEAR_OF_ERA_TYPE = new StandardDateTimeFieldType("yearOfEra", 2, DurationFieldType.years(), DurationFieldType.eras());
        CENTURY_OF_ERA_TYPE = new StandardDateTimeFieldType("centuryOfEra", 3, DurationFieldType.centuries(), DurationFieldType.eras());
        YEAR_OF_CENTURY_TYPE = new StandardDateTimeFieldType("yearOfCentury", 4, DurationFieldType.years(), DurationFieldType.centuries());
        YEAR_TYPE = new StandardDateTimeFieldType("year", 5, DurationFieldType.years(), null);
        DAY_OF_YEAR_TYPE = new StandardDateTimeFieldType("dayOfYear", 6, DurationFieldType.days(), DurationFieldType.years());
        MONTH_OF_YEAR_TYPE = new StandardDateTimeFieldType("monthOfYear", 7, DurationFieldType.months(), DurationFieldType.years());
        DAY_OF_MONTH_TYPE = new StandardDateTimeFieldType("dayOfMonth", 8, DurationFieldType.days(), DurationFieldType.months());
        WEEKYEAR_OF_CENTURY_TYPE = new StandardDateTimeFieldType("weekyearOfCentury", 9, DurationFieldType.weekyears(), DurationFieldType.centuries());
        WEEKYEAR_TYPE = new StandardDateTimeFieldType("weekyear", 10, DurationFieldType.weekyears(), null);
        WEEK_OF_WEEKYEAR_TYPE = new StandardDateTimeFieldType("weekOfWeekyear", 11, DurationFieldType.weeks(), DurationFieldType.weekyears());
        DAY_OF_WEEK_TYPE = new StandardDateTimeFieldType("dayOfWeek", 12, DurationFieldType.days(), DurationFieldType.weeks());
        HALFDAY_OF_DAY_TYPE = new StandardDateTimeFieldType("halfdayOfDay", 13, DurationFieldType.halfdays(), DurationFieldType.days());
        HOUR_OF_HALFDAY_TYPE = new StandardDateTimeFieldType("hourOfHalfday", 14, DurationFieldType.hours(), DurationFieldType.halfdays());
        CLOCKHOUR_OF_HALFDAY_TYPE = new StandardDateTimeFieldType("clockhourOfHalfday", 15, DurationFieldType.hours(), DurationFieldType.halfdays());
        CLOCKHOUR_OF_DAY_TYPE = new StandardDateTimeFieldType("clockhourOfDay", 16, DurationFieldType.hours(), DurationFieldType.days());
        HOUR_OF_DAY_TYPE = new StandardDateTimeFieldType("hourOfDay", 17, DurationFieldType.hours(), DurationFieldType.days());
        MINUTE_OF_DAY_TYPE = new StandardDateTimeFieldType("minuteOfDay", 18, DurationFieldType.minutes(), DurationFieldType.days());
        MINUTE_OF_HOUR_TYPE = new StandardDateTimeFieldType("minuteOfHour", 19, DurationFieldType.minutes(), DurationFieldType.hours());
        SECOND_OF_DAY_TYPE = new StandardDateTimeFieldType("secondOfDay", 20, DurationFieldType.seconds(), DurationFieldType.days());
        SECOND_OF_MINUTE_TYPE = new StandardDateTimeFieldType("secondOfMinute", 21, DurationFieldType.seconds(), DurationFieldType.minutes());
        MILLIS_OF_DAY_TYPE = new StandardDateTimeFieldType("millisOfDay", 22, DurationFieldType.millis(), DurationFieldType.days());
        MILLIS_OF_SECOND_TYPE = new StandardDateTimeFieldType("millisOfSecond", 23, DurationFieldType.millis(), DurationFieldType.seconds());
    }

    public static DateTimeFieldType clockhourOfHalfday() {
        return CLOCKHOUR_OF_HALFDAY_TYPE;
    }

    public static DateTimeFieldType hourOfHalfday() {
        return HOUR_OF_HALFDAY_TYPE;
    }

    public static DateTimeFieldType minuteOfDay() {
        return MINUTE_OF_DAY_TYPE;
    }

    public abstract DurationFieldType getRangeDurationType();

    private static class StandardDateTimeFieldType
    extends DateTimeFieldType {
        private final transient DurationFieldType iUnitType;
        private final byte iOrdinal;
        private final transient DurationFieldType iRangeType;
        private static final long serialVersionUID = -9937958251642L;

        public boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 instanceof StandardDateTimeFieldType) {
                return this.iOrdinal == ((StandardDateTimeFieldType)arg0).iOrdinal;
            }
            return false;
        }

        StandardDateTimeFieldType(String a2, byte a3, DurationFieldType a4, DurationFieldType a5) {
            super(a2);
            StandardDateTimeFieldType a6;
            a6.iOrdinal = a3;
            a6.iUnitType = a4;
            a6.iRangeType = a5;
        }

        private Object readResolve() {
            StandardDateTimeFieldType a2;
            switch (a2.iOrdinal) {
                case 1: {
                    return ERA_TYPE;
                }
                case 2: {
                    return YEAR_OF_ERA_TYPE;
                }
                case 3: {
                    return CENTURY_OF_ERA_TYPE;
                }
                case 4: {
                    return YEAR_OF_CENTURY_TYPE;
                }
                case 5: {
                    return YEAR_TYPE;
                }
                case 6: {
                    return DAY_OF_YEAR_TYPE;
                }
                case 7: {
                    return MONTH_OF_YEAR_TYPE;
                }
                case 8: {
                    return DAY_OF_MONTH_TYPE;
                }
                case 9: {
                    return WEEKYEAR_OF_CENTURY_TYPE;
                }
                case 10: {
                    return WEEKYEAR_TYPE;
                }
                case 11: {
                    return WEEK_OF_WEEKYEAR_TYPE;
                }
                case 12: {
                    return DAY_OF_WEEK_TYPE;
                }
                case 13: {
                    return HALFDAY_OF_DAY_TYPE;
                }
                case 14: {
                    return HOUR_OF_HALFDAY_TYPE;
                }
                case 15: {
                    return CLOCKHOUR_OF_HALFDAY_TYPE;
                }
                case 16: {
                    return CLOCKHOUR_OF_DAY_TYPE;
                }
                case 17: {
                    return HOUR_OF_DAY_TYPE;
                }
                case 18: {
                    return MINUTE_OF_DAY_TYPE;
                }
                case 19: {
                    return MINUTE_OF_HOUR_TYPE;
                }
                case 20: {
                    return SECOND_OF_DAY_TYPE;
                }
                case 21: {
                    return SECOND_OF_MINUTE_TYPE;
                }
                case 22: {
                    return MILLIS_OF_DAY_TYPE;
                }
                case 23: {
                    return MILLIS_OF_SECOND_TYPE;
                }
            }
            return a2;
        }

        public DurationFieldType getRangeDurationType() {
            return this.iRangeType;
        }

        public DateTimeField getField(Chronology arg0) {
            arg0 = DateTimeUtils.getChronology(arg0);
            switch (this.iOrdinal) {
                case 1: {
                    return arg0.era();
                }
                case 2: {
                    return arg0.yearOfEra();
                }
                case 3: {
                    return arg0.centuryOfEra();
                }
                case 4: {
                    return arg0.yearOfCentury();
                }
                case 5: {
                    return arg0.year();
                }
                case 6: {
                    return arg0.dayOfYear();
                }
                case 7: {
                    return arg0.monthOfYear();
                }
                case 8: {
                    return arg0.dayOfMonth();
                }
                case 9: {
                    return arg0.weekyearOfCentury();
                }
                case 10: {
                    return arg0.weekyear();
                }
                case 11: {
                    return arg0.weekOfWeekyear();
                }
                case 12: {
                    return arg0.dayOfWeek();
                }
                case 13: {
                    return arg0.halfdayOfDay();
                }
                case 14: {
                    return arg0.hourOfHalfday();
                }
                case 15: {
                    return arg0.clockhourOfHalfday();
                }
                case 16: {
                    return arg0.clockhourOfDay();
                }
                case 17: {
                    return arg0.hourOfDay();
                }
                case 18: {
                    return arg0.minuteOfDay();
                }
                case 19: {
                    return arg0.minuteOfHour();
                }
                case 20: {
                    return arg0.secondOfDay();
                }
                case 21: {
                    return arg0.secondOfMinute();
                }
                case 22: {
                    return arg0.millisOfDay();
                }
                case 23: {
                    return arg0.millisOfSecond();
                }
            }
            throw new InternalError();
        }

        public int hashCode() {
            return 1 << this.iOrdinal;
        }

        public DurationFieldType getDurationType() {
            return this.iUnitType;
        }
    }
}

