/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.linear.univariate.stationaryprocess.garch;

import dev.nm.analysis.function.FunctionOps;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.doublearray.DoubleArrayMath;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GARCHModel {
    private double[] void;
    private double[] if;
    private double new;

    public double a0() {
        return this.new;
    }

    public GARCHModel(GARCHModel that) {
        this.new = that.new;
        this.if = Arrays.copyOf(that.if, that.if.length);
        this.void = Arrays.copyOf(that.void, that.void.length);
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append(this.new);
        for (a2 = 0; a2 < this.if.length; ++a2) {
            a3.append(String.format("+ %f * e_{t-%d}", this.if[a2], a2 + 1));
        }
        for (a2 = 0; a2 < this.void.length; ++a2) {
            a3.append(String.format("+ %f * h_{t-%d}", this.void[a2], a2 + 1));
        }
        return a3.toString();
    }

    public int p() {
        return this.void.length;
    }

    public double[] beta() {
        return Arrays.copyOf(this.void, this.void.length);
    }

    public double[] alpha() {
        return Arrays.copyOf(this.if, this.if.length);
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }

    public GARCHModel(double a0, double[] a2, double[] b2) {
        int a3;
        ArgumentAssertion.assertPositive(a0, "a0");
        ArgumentAssertion.assertNonNegative(DoubleArrayMath.min(a2), "{a}");
        ArgumentAssertion.assertNonNegative(DoubleArrayMath.min(b2), "{b}");
        double a4 = 0.0;
        for (a3 = 0; a3 < a2.length; ++a3) {
            a4 += a2[a3];
        }
        for (a3 = 0; a3 < b2.length; ++a3) {
            a4 += b2[a3];
        }
        ArgumentAssertion.assertLessThan(a4, 1.0, "sum of alpha and beta (except for alpha0)");
        this.new = a0;
        this.if = Arrays.copyOf(a2, a2.length);
        this.void = Arrays.copyOf(b2, b2.length);
    }

    public double var() {
        int a2;
        double a3 = 1.0;
        for (a2 = 0; a2 < this.q(); ++a2) {
            a3 -= this.if[a2];
        }
        for (a2 = 0; a2 < this.p(); ++a2) {
            a3 -= this.void[a2];
        }
        ArgumentAssertion.assertTrue((a3 = this.new / a3) > 0.0, "invalid GARCH specification (except alpha0), sum of alpha and beta < 1; invalid variance", new Object[0]);
        return a3;
    }

    static {
        Package.validate("NMDEV_STAT");
    }

    public int q() {
        return this.if.length;
    }

    public double sigma2(double[] e2, double[] sigma2_lag) {
        double a2 = this.new + FunctionOps.dotProduct(this.if, e2) + FunctionOps.dotProduct(this.void, sigma2_lag);
        return a2;
    }
}

