/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.linear.multivariate.arima;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.timeseries.linear.multivariate.arima.VARIMAXModel;
import dev.nm.stat.timeseries.linear.multivariate.stationaryprocess.arma.VARMAModel;
import dev.nm.stat.timeseries.linear.univariate.arima.ARIMAModel;
import java.util.Arrays;

public class VARIMAModel
extends VARIMAXModel {
    public VARIMAModel(Vector mu, Matrix[] phi, int d2, Matrix[] theta, Matrix sigma) {
        super(mu, phi, d2, theta, null, sigma);
    }

    public VARIMAModel(ARIMAModel model) {
        super(model);
    }

    public VARIMAModel(VARIMAModel that) {
        super(that);
    }

    public VARMAModel getVARMA() {
        ImmutableMatrix[] a2 = this.phi();
        ImmutableMatrix[] a3 = this.theta();
        return new VARMAModel((Vector)this.mu(), (Matrix[])Arrays.copyOfRange(a2, 1, a2.length), (Matrix[])Arrays.copyOfRange(a3, 1, a3.length), (Matrix)this.sigma());
    }

    public VARIMAModel(Matrix[] phi, int d2, Matrix[] theta, Matrix sigma) {
        this(new DenseVector(DoubleUtils.rep(0.0, sigma.nRows())), phi, d2, theta, sigma);
    }

    public VARIMAModel(Vector mu, Matrix[] phi, int d2, Matrix[] theta) {
        this(mu, phi, d2, theta, (Matrix)new DenseMatrix(mu.size(), mu.size()).ONE());
    }

    public VARIMAModel(Matrix[] phi, int d2, Matrix[] theta) {
        this(phi, d2, theta, new DenseMatrix(phi != null ? phi[0].nRows() : theta[0].nRows(), phi != null ? phi[0].nRows() : theta[0].nRows()).ONE());
    }
}

