/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.rank.wilcoxon;

import dev.nm.misc.license.Package;
import dev.nm.number.big.BigIntegerUtils;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WilcoxonRankSumDistribution
implements ProbabilityDistribution {
    private double[][][] void;
    private final int if;
    private final int new;

    @Override
    public double mean() {
        return (double)(this.if * this.new) / 2.0;
    }

    @Override
    public double cdf(double x) {
        int a2 = (int)x + this.if * (this.if + 1) / 2;
        double a3 = 0.0;
        for (int a4 = 0; a4 <= WilcoxonRankSumDistribution.final(this.if, this.new); ++a4) {
            if (a4 > a2) continue;
            a3 += this.void[this.if][this.new][a4];
        }
        return a3;
    }

    public double pValue(double x) {
        double a2 = this.cdf(x);
        double a3 = this.rightOneSidedPvalue(x);
        double a4 = 2.0 * Math.min(a3, a2);
        return a4;
    }

    static {
        Package.validate("NMDEV_STAT");
    }

    public double rightOneSidedPvalue(double x) {
        int a2 = (int)x + this.if * (this.if + 1) / 2;
        double a3 = 0.0;
        for (int a4 = 0; a4 <= WilcoxonRankSumDistribution.final(this.if, this.new); ++a4) {
            if (a4 < a2) continue;
            a3 += this.void[this.if][this.new][a4];
        }
        return a3;
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double skew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double kurtosis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double quantile(double u) {
        int a2;
        double a3 = 0.0;
        int a4 = 0;
        for (a2 = 0; a2 <= this.if * this.new; ++a2) {
            int a5 = a2 + this.if * (this.if + 1) / 2;
            while (a4 <= a5 && a4 <= WilcoxonRankSumDistribution.final(this.if, this.new)) {
                a3 += this.void[this.if][this.new][a4];
                ++a4;
            }
            if (a3 > u) break;
        }
        return a2;
    }

    public WilcoxonRankSumDistribution(int M2, int N) {
        int a2;
        int a3;
        int a4;
        this.if = M2;
        this.new = N;
        this.void = new double[M2 + 1][N + 1][];
        for (a4 = 1; a4 <= N; ++a4) {
            this.void[0][a4] = new double[1];
            this.void[0][a4][0] = 1.0;
        }
        for (a4 = 1; a4 <= M2; ++a4) {
            a3 = WilcoxonRankSumDistribution.final(a4, 0);
            this.void[a4][0] = new double[a3 + 1];
            this.void[a4][0][a3] = 1.0;
        }
        for (a4 = 1; a4 <= M2; ++a4) {
            for (a3 = 1; a3 <= N; ++a3) {
                int a5 = WilcoxonRankSumDistribution.final(a4, a3);
                this.void[a4][a3] = new double[a5 + 1];
                for (a2 = a4 * (a4 + 1) / 2; a2 <= a5; ++a2) {
                    double a6 = a2 >= this.void[a4][a3 - 1].length ? 0.0 : this.void[a4][a3 - 1][a2];
                    double a7 = a2 - a4 - a3 >= 0 ? this.void[a4 - 1][a3][a2 - a4 - a3] : 0.0;
                    this.void[a4][a3][a2] = a6 + a7;
                }
            }
        }
        for (a4 = 1; a4 <= M2; ++a4) {
            for (a3 = 1; a3 <= N; ++a3) {
                BigInteger a8 = BigIntegerUtils.combination(a4 + a3, a4);
                a2 = 0;
                while (a2 < this.void[a4][a3].length) {
                    double[] dArray = this.void[a4][a3];
                    int n = a2++;
                    dArray[n] = dArray[n] / a8.doubleValue();
                }
            }
        }
    }

    private static int final(int a2, int a3) {
        return a2 * (a2 + 2 * a3 + 1) / 2;
    }

    @Override
    public double variance() {
        return (double)(this.if * this.new * (this.if + this.new + 1)) / 12.0;
    }

    @Override
    @Deprecated
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double density(double x) {
        return this.void[this.if][this.new][(int)x + this.if * (this.if + 1) / 2];
    }

    @Override
    @Deprecated
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

