/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.rank.wilcoxon;

import dev.nm.number.DoubleUtils;
import dev.nm.stat.descriptive.rank.Rank;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.test.HypothesisTest;
import dev.nm.stat.test.rank.wilcoxon.WilcoxonRankSumDistribution;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WilcoxonRankSum
extends HypothesisTest {
    private final double goto;
    private final int try;
    private final boolean float;
    private final int short;
    private final boolean enum;
    private double false;
    private final double void;
    private final WilcoxonRankSumDistribution if;
    private final ProbabilityDistribution new = new NormalDistribution(0.0, 1.0);

    @Override
    public String getNullHypothesis() {
        return "the means are equal (by offset mu)";
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2) {
        this(sample1, sample2, 0.0);
    }

    @Override
    public String getAlternativeHypothesis() {
        return "the means are different (not by mu)";
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2, double mu) {
        this(sample1, sample2, mu, sample1.length + sample2.length < 50, false);
    }

    public double leftOneSidedPvalue() {
        double a2 = this.statistics();
        double a3 = this.enum ? this.if.cdf(a2) : (this.float ? this.new.cdf((a2 - this.goto + 0.5) / this.void) : 1.0 - this.rightOneSidedPvalue());
        return a3;
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2, double mu, boolean isExact, boolean isCorrected) {
        super(sample1, sample2);
        int a2;
        int a3 = this.nObs();
        this.try = sample1.length;
        this.short = sample2.length;
        this.enum = isExact;
        this.float = isCorrected;
        double[] a4 = Arrays.copyOf(sample2, sample2.length);
        int a5 = 0;
        while (a5 < a4.length) {
            int n = a5++;
            a4[n] = a4[n] + mu;
        }
        double[] a22 = DoubleUtils.concat(sample1, a4);
        double[] a6 = new Rank(a22).ranks();
        int a7 = 0;
        int[] a8 = new int[this.try + this.short];
        int a9 = 1;
        double[] a10 = a22;
        Arrays.sort(a10);
        for (a2 = 1; a2 < this.try + this.short; ++a2) {
            a8[a9 - 1] = a10[a2 - 1] == a10[a2] ? a8[a9 - 1] + 1 : a8[a9 - 1];
            a9 = a10[a2 - 1] != a10[a2] ? a9 + 1 : a9;
        }
        for (a2 = 0; a2 < a9; ++a2) {
            a8[a2] = a8[a2] + 1;
            a7 = a7 + a8[a2] * a8[a2] * a8[a2] - a8[a2];
        }
        this.false = 0.0;
        for (a2 = 0; a2 < this.try; ++a2) {
            this.false += a6[a2];
        }
        this.if = new WilcoxonRankSumDistribution(this.try, this.short);
        this.goto = this.try * this.short / 2;
        this.void = Math.sqrt((double)(this.try * this.short) * ((double)a3 + 1.0 - (double)a7 / (double)((this.try + this.short) * (this.try + this.short - 1))) / 12.0);
    }

    public WilcoxonRankSum(double[] sample1, double[] sample2, double mu, boolean isExact) {
        this(sample1, sample2, mu, isExact, true);
    }

    public double rightOneSidedPvalue() {
        double a2;
        double a3 = this.statistics();
        if (this.enum) {
            a2 = this.if.rightOneSidedPvalue(a3);
        } else if (this.float) {
            a2 = WilcoxonRankSum.oneSidedPvalue(this.new, (a3 - this.goto - 0.5) / this.void);
        } else {
            double a4 = (a3 - this.goto) / this.void;
            a2 = WilcoxonRankSum.oneSidedPvalue(this.new, a4);
        }
        return a2;
    }

    @Override
    public double pValue() {
        double a2;
        double a3 = this.statistics();
        if (this.enum) {
            a2 = this.if.pValue(a3);
        } else if (this.float) {
            double a4 = a3 > this.goto ? 0.5 : -0.5;
            double a5 = (a3 - this.goto - a4) / this.void;
            double a6 = this.new.cdf(a5);
            a2 = 2.0 * Math.min(a6, 1.0 - a6);
        } else {
            a2 = 2.0 * Math.min(this.leftOneSidedPvalue(), this.rightOneSidedPvalue());
        }
        return a2;
    }

    @Override
    public double statistics() {
        double a2 = this.false - (double)(this.try * (this.try + 1) / 2);
        return a2;
    }
}

