/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.distribution.pearson;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.stat.distribution.univariate.ChiSquareDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.test.HypothesisTest;
import dev.nm.stat.test.distribution.pearson.FisherExactDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChiSquareIndependenceTest
extends HypothesisTest {
    private final ProbabilityDistribution if;
    private final double new;

    @Override
    public double pValue() {
        double a2 = ChiSquareIndependenceTest.oneSidedPvalue(this.if, this.new);
        return a2;
    }

    public ChiSquareIndependenceTest(Matrix sample) {
        this(sample, 0, Type.ASYMPTOTIC);
    }

    public static double pearsonStat(Matrix O, Matrix E2, boolean YatesContinuityCorrection) {
        int a2 = O.nRows();
        int a3 = O.nCols();
        double a4 = YatesContinuityCorrection ? 0.5 : 0.0;
        double a5 = 0.0;
        for (int a6 = 1; a6 <= a2; ++a6) {
            for (int a7 = 1; a7 <= a3; ++a7) {
                double a8 = O.get(a6, a7);
                double a9 = E2.get(a6, a7);
                double a10 = Math.abs(a8 - a9) - a4;
                a5 += a10 * a10 / a9;
            }
        }
        return a5;
    }

    @Override
    public String getNullHypothesis() {
        return "the two random variables in the contingency table are independent";
    }

    @Override
    public double statistics() {
        return this.new;
    }

    public static Matrix getExpectedContingencyTable(int[] rowSums, int[] colSums) {
        int a2 = rowSums.length;
        int a3 = colSums.length;
        int a4 = DoubleArrayMath.sum(rowSums);
        DenseMatrix a5 = new DenseMatrix(a2, a3);
        for (int a6 = 1; a6 <= a2; ++a6) {
            for (int a7 = 1; a7 <= a3; ++a7) {
                a5.set(a6, a7, (double)(rowSums[a6 - 1] * colSums[a7 - 1]) / (double)a4);
            }
        }
        return a5;
    }

    @Override
    public String getAlternativeHypothesis() {
        return "the two random variables in the contingency table are not independent";
    }

    public ChiSquareIndependenceTest(Matrix sample, int nSims, Type type) {
        super(new double[][]{MatrixUtils.to1DArray(sample)});
        int[] a2 = DoubleUtils.doubleArray2intArray(MatrixUtils.rowSums(sample));
        int[] a3 = DoubleUtils.doubleArray2intArray(MatrixUtils.colSums(sample));
        Matrix a4 = ChiSquareIndependenceTest.getExpectedContingencyTable(a2, a3);
        this.new = ChiSquareIndependenceTest.pearsonStat(sample, a4, type == Type.ASYMPTOTIC);
        if (type == Type.EXACT) {
            this.if = new FisherExactDistribution(a2, a3, nSims);
        } else {
            int a5 = (sample.nRows() - 1) * (sample.nCols() - 1);
            this.if = new ChiSquareDistribution(a5);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Type {
        ASYMPTOTIC,
        EXACT;


        private Type() {
            Type a2;
        }
    }
}

