/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear.glm.distribution;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.regression.linear.glm.distribution.GLMExponentialDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GLMBinomial
implements GLMExponentialDistribution {
    private final int new = 1;

    @Override
    public double variance(double mu) {
        return mu * (1.0 - mu);
    }

    @Override
    public double theta(double mu) {
        return Math.log(Math.abs(mu / (1.0 - mu)));
    }

    private double final(double a2, double a3) {
        return DoubleUtils.isZero(a2, 0.0) ? 0.0 : a2 * Math.log(Math.abs(a2 / a3));
    }

    @Override
    public double dispersion(Vector y, Vector mu, int nFactors) {
        return 1.0;
    }

    @Override
    public double AIC(Vector y, Vector mu, Vector weight, double prelogLike, double deviance, int nFactors) {
        double a2 = prelogLike;
        return 2.0 * ((double)nFactors - a2);
    }

    @Override
    public double deviance(double y, double mu) {
        return 2.0 * (this.final(y, mu) + this.final(1.0 - y, 1.0 - mu));
    }

    @Override
    public double cumulant(double theta) {
        return Math.log(1.0 + Math.exp(theta));
    }

    @Override
    public double overdispersion(Vector y, Vector mu, int nFactors) {
        int a2 = y.size();
        double a3 = 0.0;
        for (int a4 = 1; a4 <= a2; ++a4) {
            double a5 = y.get(a4) - mu.get(a4);
            a3 += a5 * a5 / this.variance(mu.get(a4));
        }
        return a3 /= (double)(a2 - nFactors);
    }
}

