/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.random.rng.univariate.uniform.linear;

import dev.nm.analysis.function.FunctionOps;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.random.rng.univariate.uniform.linear.LinearCongruentialGenerator;
import java.util.concurrent.atomic.AtomicLong;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Lehmer
implements LinearCongruentialGenerator {
    private final long enum;
    private final long false;
    private AtomicLong void = new AtomicLong();
    private final long if;
    private final long new;

    public Lehmer(long a2, long m2, long k2, long seed) {
        this(FunctionOps.modpow(a2, k2, m2), m2, seed);
    }

    public Lehmer(long a2, long m2, long seed) {
        ArgumentAssertion.assertPositive(a2, "a");
        ArgumentAssertion.assertPositive(m2, "m");
        this.new = a2;
        this.false = m2;
        this.if = m2 / a2;
        this.enum = m2 % a2;
        ArgumentAssertion.assertTrue(this.enum <= this.if, "the (a, m) combination is not valid; try a <= sqrt(m)", new Object[0]);
        this.seed(seed);
    }

    @Override
    public long nextLong() {
        long a2;
        long a3;
        do {
            a2 = a3 = this.void.get();
            long a4 = a2 / this.if;
            if ((a2 = this.new * (a2 - a4 * this.if) - a4 * this.enum) >= 0L) continue;
            a2 += this.false;
        } while (!this.void.compareAndSet(a3, a2));
        return a2;
    }

    @Override
    public double nextDouble() {
        return (double)this.nextLong() / (double)this.false;
    }

    @Override
    public long modulus() {
        return this.false;
    }

    @Override
    public int order() {
        return 1;
    }

    public Lehmer() {
        this(40014L, 2147483563L, 8682522807148012L + System.nanoTime());
    }

    @Override
    public void seed(long ... seeds) {
        this.void.set(seeds[0] % this.false);
    }
}

