/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.factor.factoranalysis;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Eigen;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearLessThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LowerBoundConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.UpperBoundConstraints;
import dev.nm.solver.multivariate.constrained.general.sqp.activeset.SQPActiveSetMinimizer;
import dev.nm.solver.multivariate.constrained.problem.ConstrainedOptimProblemImpl1;
import dev.nm.solver.multivariate.unconstrained.c2.NelderMeadMinimizer;
import dev.nm.solver.problem.C2OptimProblemImpl;
import dev.nm.stat.factor.factoranalysis.FactorAnalysis;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class FactorAnalysisMLE {
    private final ImmutableMatrix float;
    private final double short;
    final RealScalarFunction nL;
    private final int enum;
    private static final double false = 0.005;
    private final int void;
    private final Gradient if;
    private static final double new = 1.0E10;

    Vector estimate(Vector a2) {
        FactorAnalysisMLE a3;
        Vector a4 = a2;
        try {
            SQPActiveSetMinimizer a5 = new SQPActiveSetMinimizer(a3.short, a3.short, a3.enum);
            ConstrainedOptimProblemImpl1 a6 = new ConstrainedOptimProblemImpl1(a3.nL, null, (LinearLessThanConstraints)LinearConstraints.concat(new LinearConstraints[]{new LowerBoundConstraints(a3.nL, 0.005).toLessThanConstraints(), new UpperBoundConstraints(a3.nL, 1.0)}));
            SQPActiveSetMinimizer.Solution a7 = a5.solve(a6);
            a7.search((S[])new Vector[]{a4});
            a4 = (Vector)a7.minimizer();
        }
        catch (Exception a8) {
            RealScalarFunction a9 = new RealScalarFunction(){

                @Override
                public Double evaluate(Vector psi) {
                    double[] a2 = psi.toArray();
                    double a3 = DoubleArrayMath.min(a2);
                    if (a3 < 0.005) {
                        return 1.0E10;
                    }
                    double a4 = DoubleArrayMath.max(a2);
                    if (a4 > 1.0) {
                        return 1.0E10;
                    }
                    double a5 = (Double)FactorAnalysisMLE.this.nL.evaluate(psi);
                    return a5;
                }

                @Override
                public int dimensionOfRange() {
                    return FactorAnalysisMLE.this.nL.dimensionOfRange();
                }

                @Override
                public int dimensionOfDomain() {
                    return FactorAnalysisMLE.this.nL.dimensionOfDomain();
                }
                {
                    1 a3;
                }
            };
            C2OptimProblemImpl a10 = new C2OptimProblemImpl(a9);
            NelderMeadMinimizer a11 = new NelderMeadMinimizer(a3.short, a3.enum);
            NelderMeadMinimizer.Solution a12 = a11.solve(a10);
            a4 = a12.search(a4);
        }
        if (DoubleArrayMath.min(a4.toArray()) < 0.005 - a3.short) {
            throw new RuntimeException(String.format("invalid psi: %s", a4.toString()));
        }
        return a4;
    }

    FactorAnalysisMLE(Matrix a2, int a3, Gradient a4, double a5, int a6) {
        FactorAnalysisMLE a7;
        a7.float = new ImmutableMatrix(a2);
        a7.void = a3;
        a7.if = a4;
        a7.short = a5;
        a7.enum = a6;
        a7.nL = a7.new logLikelihood();
    }

    FactorAnalysisMLE(Matrix a2, int a3) {
        a4(a2, a3, Gradient.ANALYTICAL, PrecisionUtils.autoEpsilon(a2), 500);
        FactorAnalysisMLE a4;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class GradientFunction
    implements RealVectorFunction {
        private final int new;

        @Override
        public int dimensionOfDomain() {
            return this.new;
        }

        private GradientFunction() {
            GradientFunction a2;
            a2.new = a2.FactorAnalysisMLE.this.float.nRows();
        }

        @Override
        public Vector evaluate(Vector psi) {
            Matrix a2 = FactorAnalysis.getLoadings(psi, FactorAnalysisMLE.this.void, FactorAnalysisMLE.this.float);
            DiagonalMatrix a3 = new DiagonalMatrix(psi.toArray());
            Inverse a4 = new Inverse(a3);
            Matrix a5 = a2.multiply(a2.t()).add(a3).minus(FactorAnalysisMLE.this.float);
            a5 = a4.multiply(a5).multiply(a4);
            DenseVector a6 = new DenseVector(this.new);
            for (int a7 = 1; a7 <= this.new; ++a7) {
                a6.set(a7, a5.get(a7, a7));
            }
            return a6;
        }

        @Override
        public int dimensionOfRange() {
            return 1;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class logLikelihood
    extends AbstractRealScalarFunction {
        private final int new;

        @Override
        public Double evaluate(Vector psi) {
            double[] a2 = psi.toArray();
            DiagonalMatrix a3 = new DiagonalMatrix(DoubleUtils.foreach(a2, new AbstractUnivariateRealFunction(){

                @Override
                public double evaluate(double psi) {
                    return 1.0 / Math.sqrt(psi);
                }
                {
                    1 a3;
                }
            }));
            Matrix a4 = a3.multiply(FactorAnalysisMLE.this.float).multiply(a3);
            Eigen a5 = new Eigen(a4, Eigen.Method.QR_SYMMETRIC, FactorAnalysisMLE.this.short);
            double[] a6 = Arrays.copyOfRange(a5.getRealEigenvalues(), FactorAnalysisMLE.this.void, this.new);
            double a7 = 0.0;
            for (int a8 = 0; a8 < this.new - FactorAnalysisMLE.this.void; ++a8) {
                if (DoubleUtils.isZero(a6[a8], FactorAnalysisMLE.this.short)) {
                    return 1.0E10;
                }
                a7 += a6[a8] - Math.log(a6[a8]);
            }
            return a7 -= (double)(this.new - FactorAnalysisMLE.this.void);
        }

        private logLikelihood() {
            logLikelihood a2;
            super(a2.FactorAnalysisMLE.this.float.nRows());
            a2.new = a2.FactorAnalysisMLE.this.float.nRows();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static enum Gradient {
        ANALYTICAL,
        NUMERICAL;


        private Gradient() {
            Gradient a2;
        }
    }
}

