/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.univariate.fitting.acer.empirical;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.stat.descriptive.moment.Mean;
import dev.nm.stat.evt.evd.univariate.fitting.acer.empirical.ACERByCounting;
import dev.nm.stat.evt.evd.univariate.fitting.acer.empirical.ACERUtils;
import dev.nm.stat.evt.evd.univariate.fitting.acer.empirical.EmpiricalACER;
import dev.nm.stat.evt.evd.univariate.fitting.acer.empirical.EmpiricalACERStatistics;
import dev.nm.stat.evt.evd.univariate.fitting.acer.empirical.EpsilonStatisticsCalculator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EmpiricalACEREstimation {
    private final int false;
    private final boolean void;
    private final int if;
    private final EpsilonStatisticsCalculator new;

    public EmpiricalACEREstimation() {
        this(300, true, new EpsilonStatisticsCalculator(true, 0.95), 2);
    }

    private static double[][] final(double[][] a2) {
        double[][] a3 = new double[a2.length][];
        for (int a4 = 0; a4 < a2.length; ++a4) {
            a3[a4] = ACERUtils.extractPeaks(a2[a4]);
        }
        return a3;
    }

    public EmpiricalACEREstimation(int nLevels, boolean usePeaksOnly, EpsilonStatisticsCalculator statisticsCalculator, int kStepMemory) {
        ArgumentAssertion.assertPositive(kStepMemory, "k");
        this.false = nLevels;
        this.void = usePeaksOnly;
        this.new = statisticsCalculator;
        this.if = kStepMemory;
    }

    static {
        Package.validate("NMDEV_EVT");
    }

    public EmpiricalACER estimate(double[][] observations) {
        double[][] a2 = this.void ? EmpiricalACEREstimation.final(observations) : observations;
        double[] a3 = DoubleUtils.concat(a2);
        int a4 = a3.length;
        int a5 = observations.length;
        double a6 = DoubleArrayMath.min(a3);
        double a7 = DoubleArrayMath.max(a3);
        double a8 = (a7 - a6) / (double)(this.false - 1);
        double[] a9 = DoubleUtils.seq(a6, a7, a8);
        ACERByCounting a10 = new ACERByCounting(a9, this.if);
        double[][] a11 = a10.estimateForMultiPeriods(observations);
        EmpiricalACERStatistics a12 = this.new.compute(a2, a11, this.if);
        double a13 = new Mean(a3).value();
        double a14 = (double)a4 / (double)a5;
        EmpiricalACER a15 = new EmpiricalACER(a2, a9, a14, a13, a11, a12.getMean(), a12.getConfidenceInterval());
        return a15;
    }
}

