/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.univariate;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.evt.evd.univariate.UnivariateEVD;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MinimaDistribution
implements UnivariateEVD {
    private final ProbabilityDistribution if;
    private final int new;

    @Override
    public double variance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double skew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double mean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    @Override
    public double cdf(double x) {
        double a2 = 1.0 - this.if.cdf(x);
        return 1.0 - Math.pow(a2, this.new);
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double logDensity(double x) {
        double a2 = Math.log(this.if.density(x));
        if (Double.isInfinite(a2)) {
            return Double.NEGATIVE_INFINITY;
        }
        double a3 = (double)(this.new - 1) * Math.log(1.0 - this.if.cdf(x));
        double a4 = Math.log(this.new) + a2 + a3;
        return a4;
    }

    @Override
    public double kurtosis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        Package.validate("NMDEV_EVT");
    }

    public MinimaDistribution(ProbabilityDistribution dist, int nIIDs) {
        ArgumentAssertion.assertPositive(nIIDs, "number of samples");
        this.if = dist;
        this.new = nIIDs;
    }

    @Override
    public double quantile(double p) {
        ArgumentAssertion.assertRangeOpen(p, 0.0, 1.0, "probability p");
        double a2 = this.if.quantile(1.0 - Math.pow(1.0 - p, 1.0 / (double)this.new));
        return a2;
    }
}

