/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.univariate;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.evt.evd.univariate.UnivariateEVD;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GeneralizedParetoDistribution
implements UnivariateEVD {
    private final double void;
    private final double if;
    private final double new;

    public GeneralizedParetoDistribution(double location, double scale, double shape) {
        ArgumentAssertion.assertPositive(scale, "scale");
        this.new = location;
        this.if = scale;
        this.void = shape;
    }

    @Override
    public double quantile(double p) {
        ArgumentAssertion.assertRangeOpen(p, 0.0, 1.0, "probability p");
        if (this.void == 0.0) {
            return this.new - this.if * Math.log(1.0 - p);
        }
        return this.new + this.if * (Math.pow(1.0 - p, -this.void) - 1.0) / this.void;
    }

    static {
        Package.validate("NMDEV_EVT");
    }

    @Override
    public double logDensity(double x) {
        boolean a2;
        double a3 = (x - this.new) / this.if;
        boolean bl = a2 = a3 > 0.0 && 1.0 + this.void * a3 > 0.0 || a3 == Double.NaN;
        if (!a2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.void == 0.0) {
            return Math.log(1.0 / this.if) - a3;
        }
        return Math.log(1.0 / this.if) - (1.0 + 1.0 / this.void) * Math.log(1.0 + this.void * a3);
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double median() {
        return this.new + this.if * (Math.pow(2.0, this.void) - 1.0) / this.void;
    }

    @Override
    public double skew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double mean() {
        if (this.void < 1.0) {
            return this.new + this.if / (1.0 - this.void);
        }
        throw new RuntimeException("mean only exists if shape < 1");
    }

    @Override
    public double cdf(double x) {
        if (x < this.new) {
            return 0.0;
        }
        double a2 = (x - this.new) / this.if;
        if (this.void == 0.0) {
            return 1.0 - Math.exp(-a2);
        }
        double a3 = 1.0 + this.void * a2;
        if (this.void < 0.0 && a3 < 0.0) {
            return 1.0;
        }
        return 1.0 - Math.pow(a3, -1.0 / this.void);
    }

    public GeneralizedParetoDistribution() {
        this(0.0, 1.0, 0.0);
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double variance() {
        if (this.void < 0.5) {
            double a2 = 1.0 - this.void;
            double a3 = a2 - this.void;
            return this.if * this.if / (a2 * a2 * a3);
        }
        throw new RuntimeException("variance only exists if shape < 0.5");
    }

    @Override
    public double kurtosis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public GeneralizedParetoDistribution(double scale, double shape) {
        this(0.0, scale, shape);
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }
}

