/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.cluster;

import dev.nm.misc.license.Package;
import dev.nm.number.doublearray.DoubleArrayMath;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Clusters {
    private final int void;
    private final List<Cluster> if;
    private final double[] new;

    public Clusters(double[] observations, List<Cluster> clusters, int nExceedences) {
        this.new = observations;
        this.if = clusters;
        this.void = nExceedences;
    }

    public int getExceedenceCount() {
        return this.void;
    }

    static {
        Package.validate("NMDEV_EVT");
    }

    public double[] getClusterMaxima() {
        double[] a2 = new double[this.if.size()];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            Cluster a4 = this.if.get(a3);
            a2[a3] = DoubleArrayMath.max(Arrays.copyOfRange(this.new, a4.getBeginIndex(), a4.getEndIndex() + 1));
        }
        return a2;
    }

    public double getAverageClusterSize() {
        return (double)this.getExceedenceCount() / (double)this.getClusterCount();
    }

    public int getClusterCount() {
        return this.if.size();
    }

    public List<Cluster> getClusters() {
        return Collections.unmodifiableList(this.if);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Cluster {
        private final int if;
        private final int new;

        public int getBeginIndex() {
            return this.if;
        }

        public Cluster(int beginIndex, int endIndex) {
            this.if = beginIndex;
            this.new = endIndex;
        }

        public int getEndIndex() {
            return this.new;
        }

        public String toString() {
            return String.format("[%d,%d]", this.if, this.new);
        }
    }
}

