/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.dlm.univariate;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.random.rng.RNGUtils;
import dev.nm.stat.random.rng.univariate.normal.RandomStandardNormalGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObservationEquation {
    private final UnivariateRealFunction void;
    private final UnivariateRealFunction if;
    private final RandomStandardNormalGenerator new;

    public ObservationEquation(double F2, double V) {
        this(F2, V, RNGUtils.RNORM);
    }

    public double yt_var(int t, double var_t_tlag) {
        double a2 = this.F(t);
        double a3 = this.V(t);
        double a4 = a2 * var_t_tlag * a2 + a3;
        return a4;
    }

    public double yt_mean(int t, double xt) {
        double a2 = this.void.evaluate(t) * xt;
        return a2;
    }

    public ObservationEquation(UnivariateRealFunction F2, UnivariateRealFunction V, RandomStandardNormalGenerator rnorm) {
        ArgumentAssertion.assertTrue(F2.dimensionOfDomain() == V.dimensionOfDomain(), "the domain dimensions of F and V must match", new Object[0]);
        this.void = F2;
        this.if = V;
        this.new = rnorm;
    }

    public ObservationEquation(ObservationEquation that) {
        this(that.void, that.if);
    }

    public double F(int t) {
        return this.void.evaluate(t);
    }

    public double yt(int t, double xt) {
        double a2 = this.yt_mean(t, xt);
        double a3 = this.new.nextDouble() * Math.sqrt(this.if.evaluate(t));
        return a2 += a3;
    }

    public int dimension() {
        return 1;
    }

    public ObservationEquation(UnivariateRealFunction F2, UnivariateRealFunction V) {
        this(F2, V, RNGUtils.RNORM);
    }

    public ObservationEquation(final double F2, final double V, RandomStandardNormalGenerator rnorm) {
        this(new AbstractUnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double x) {
                return F2;
            }
        }, new AbstractUnivariateRealFunction(){
            {
                2 a2;
            }

            @Override
            public double evaluate(double x) {
                return V;
            }
        }, rnorm);
    }

    public double V(int t) {
        return this.if.evaluate(t);
    }
}

