/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.dlm.multivariate;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.dlm.multivariate.MultivariateObservationEquation;
import dev.nm.stat.dlm.multivariate.MultivariateStateEquation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateDLM {
    private final int short;
    private final MultivariateStateEquation enum;
    private final MultivariateObservationEquation false;
    private final ImmutableVector void;
    private final ImmutableMatrix if;
    private final int new;

    public MultivariateDLM(Vector m0, Matrix C0, MultivariateObservationEquation Yt, MultivariateStateEquation Xt) {
        ArgumentAssertion.assertTrue(m0 != null && C0 != null, "the distribution of the initial state x_0 ~ N(m0, C0) must be specified", new Object[0]);
        this.short = m0.size();
        this.new = Yt.dimension();
        this.void = new ImmutableVector(m0);
        ArgumentAssertion.assertTrue(C0.nRows() == this.short && C0.nCols() == this.short, "the dimension of C0 is p x p; p = the length of an observation", new Object[0]);
        this.if = new ImmutableMatrix(C0);
        ArgumentAssertion.assertTrue(Yt.dimension() == this.new, "the dimension of the observation equation is d, the same length as m0", new Object[0]);
        ArgumentAssertion.assertTrue(Yt.F(1).nCols() == this.short, "the dimension of F is d x p, i.e., the length of m0 * the length of an observation", new Object[0]);
        this.false = Yt;
        ArgumentAssertion.assertTrue(Xt.dimension() == this.short, "the dimension of the state equation is p; p = the length of an observation", new Object[0]);
        this.enum = Xt;
    }

    public ImmutableVector m0() {
        return this.void;
    }

    public int getStateDimension() {
        return this.short;
    }

    public MultivariateObservationEquation getObservationModel() {
        return this.false;
    }

    public MultivariateStateEquation getStateModel() {
        return this.enum;
    }

    public ImmutableMatrix C0() {
        return this.if;
    }

    public MultivariateDLM(MultivariateDLM that) {
        this(that.void, that.if, that.false, that.enum);
    }

    public int getObsDimension() {
        return this.new;
    }
}

