/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogNormalDistribution
implements ProbabilityDistribution {
    private final double void;
    private final NormalDistribution if;
    private final double new;

    @Override
    public double variance() {
        double a2 = this.void * this.void;
        double a3 = Math.exp(a2) - 1.0;
        return a3 *= Math.exp(2.0 * this.new + a2);
    }

    public LogNormalDistribution(double logMu, double logSigma) {
        ArgumentAssertion.assertPositive(logSigma, "logarithm of standard deviation");
        this.new = logMu;
        this.void = logSigma;
        this.if = new NormalDistribution(logMu, logSigma);
    }

    @Override
    public double entropy() {
        double a2 = 0.5;
        return a2 += 0.5 * Math.log(Math.PI * 2 * this.void * this.void) + this.new;
    }

    @Override
    public double mean() {
        double a2 = this.new + this.void * this.void / 2.0;
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double quantile(double u) {
        return Math.exp(this.if.quantile(u));
    }

    @Override
    public double skew() {
        double a2 = this.void * this.void;
        double a3 = Math.exp(a2);
        double a4 = a3 + 2.0;
        return a4 *= Math.sqrt(a3 - 1.0);
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double a2 = this.if.density(Math.log(x));
        return a2 /= x;
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return this.if.cdf(Math.log(x));
    }

    @Override
    public double moment(double s) {
        double a2 = s * this.new;
        a2 += 0.5 * s * s * this.void * this.void;
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double median() {
        return Math.exp(this.new);
    }

    @Override
    public double kurtosis() {
        double a2 = this.void * this.void;
        double a3 = Math.exp(4.0 * a2);
        a3 += 2.0 * Math.exp(3.0 * a2);
        a3 += 3.0 * Math.exp(2.0 * a2);
        return a3 -= 6.0;
    }
}

