/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.function.special.beta.BetaRegularized;
import dev.nm.analysis.function.special.beta.BetaRegularizedInverse;
import dev.nm.analysis.function.special.beta.LogBeta;
import dev.nm.analysis.function.special.gamma.Digamma;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BetaDistribution
implements ProbabilityDistribution {
    private final double short;
    private static final Digamma enum;
    private final double false;
    private static final LogBeta void;
    private final BetaRegularized if;
    private final BetaRegularizedInverse new;

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be >= 0";
        assert (x <= 1.0) : "x must be <= 1";
        return this.if.evaluate(x);
    }

    @Override
    @Deprecated
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double ccdf(double x) {
        return 1.0 - this.cdf(x);
    }

    @Override
    public double entropy() {
        double a2 = void.evaluate(this.short, this.false);
        a2 -= (this.short - 1.0) * enum.evaluate(this.short);
        a2 -= (this.false - 1.0) * enum.evaluate(this.false);
        return a2 += (this.short + this.false - 2.0) * enum.evaluate(this.short + this.false);
    }

    @Override
    public double skew() {
        double a2 = this.short + this.false;
        double a3 = 2.0 * (this.false - this.short) * Math.sqrt(a2 + 1.0);
        return a3 /= (a2 + 2.0) * Math.sqrt(this.short * this.false);
    }

    @Override
    public double kurtosis() {
        double a2 = 6.0;
        a2 *= this.short * this.short * this.short - this.short * this.short * (2.0 * this.false - 1.0) + this.false * this.false * (this.false + 1.0) - 2.0 * this.short * this.false * (this.false + 2.0);
        return a2 /= this.short * this.false * (this.short + this.false + 2.0) * (this.short + this.false + 3.0);
    }

    static {
        void = new LogBeta();
        enum = new Digamma();
    }

    @Override
    public double variance() {
        double a2 = this.short + this.false;
        double a3 = this.short * this.false;
        return a3 /= a2 * a2 * (a2 + 1.0);
    }

    public BetaDistribution(double alpha, double beta) {
        ArgumentAssertion.assertPositive(alpha, "alpha");
        ArgumentAssertion.assertPositive(beta, "beta");
        this.short = alpha;
        this.false = beta;
        this.if = new BetaRegularized(alpha, beta);
        this.new = new BetaRegularizedInverse(alpha, beta);
    }

    @Override
    public double quantile(double u) {
        double a2 = this.new.evaluate(u);
        return a2;
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("no closed form.");
    }

    @Override
    public double mean() {
        return this.short / (this.short + this.false);
    }

    @Override
    public double density(double x) {
        assert (x >= 0.0) : "x must be >= 0";
        assert (x <= 1.0) : "x must be <= 1";
        if (DoubleUtils.isZero(x, 0.0)) {
            if (this.short < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        double a2 = (this.short - 1.0) * Math.log(x) + (this.false - 1.0) * Math.log(1.0 - x) - void.evaluate(this.short, this.false);
        a2 = Math.exp(a2);
        return a2;
    }
}

