/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.descriptive.covariance;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.descriptive.Statistic;
import dev.nm.stat.descriptive.moment.Variance;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Covariance
implements Statistic {
    private Variance false;
    private double void = 0.0;
    private long if = 0L;
    private Variance new = new Variance();

    @Override
    public long N() {
        return this.if;
    }

    public String toString() {
        return String.format("covariance: %f; correlation: %f, N: %d", this.value(), this.correlation(), this.if);
    }

    public double correlation() {
        return this.value() / this.new.standardDeviation() / this.false.standardDeviation();
    }

    public Covariance(double[] data1, double[] data2) {
        this.false = new Variance();
        this.final(data1, data2);
    }

    @Override
    public double value() {
        return this.if > 1L ? this.void / (double)(this.if - 1L) : Double.NaN;
    }

    public void addData(double[] data1, double[] data2) {
        this.final(data1, data2);
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public Covariance() {
        this.false = new Variance();
    }

    public Covariance(Covariance that) {
        this.false = new Variance();
        this.if = that.if;
        this.new = that.new;
        this.false = that.false;
        this.void = that.void;
    }

    private void final(double[] a2, double[] a3) {
        Covariance a4;
        ArgumentAssertion.assertEqual(a2.length, a3.length, "data1's length", "data2's length");
        if (a4.if == 0L) {
            a4.if = a2.length;
            a4.new.addData(a2);
            a4.false.addData(a3);
            double a5 = a4.new.mean();
            double a6 = a4.false.mean();
            a4.void = 0.0;
            int a7 = 0;
            while ((long)a7 < a4.if) {
                a4.void += (a2[a7] - a5) * (a3[a7] - a6);
                ++a7;
            }
            return;
        }
        Covariance a8 = new Covariance(a2, a3);
        long a9 = a4.if + a8.if;
        double a10 = a8.new.mean() - a4.new.mean();
        double a11 = a8.false.mean() - a4.false.mean();
        double a12 = (double)a4.if / (double)a9 * (double)a8.if;
        a4.void += a8.void + (a12 *= a10 * a11);
        a4.new.addData(a2);
        a4.false.addData(a3);
        a4.if = a9;
    }

    @Override
    public void addData(double ... data) {
        ArgumentAssertion.assertTrue(data.length % 2 == 0, "there must be an even number of data points", new Object[0]);
        int a2 = data.length / 2;
        double[] a3 = Arrays.copyOfRange(data, 0, a2);
        double[] a4 = Arrays.copyOfRange(data, a2, data.length);
        this.addData(a3, a4);
    }
}

