/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.covariance.covarianceselection;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.stat.descriptive.correlation.CorrelationMatrix;
import dev.nm.stat.descriptive.covariance.SampleCovariance;
import dev.nm.stat.timeseries.datastructure.multivariate.MultivariateTimeSeries;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CovarianceSelectionProblem {
    private final ImmutableMatrix if;
    private final double new;

    public ImmutableMatrix S() {
        return this.if;
    }

    public CovarianceSelectionProblem(Matrix S, double t) {
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(S, PrecisionUtils.autoEpsilon(S)), "the covariance matrix must be symmetric", new Object[0]);
        ArgumentAssertion.assertNonNegative(t, "rho, the penalization parameter");
        this.if = new ImmutableMatrix(S);
        this.new = t;
    }

    public double t() {
        return this.new;
    }

    public CovarianceSelectionProblem(MultivariateTimeSeries ts, double t) {
        this(ts, t, false);
    }

    private double final(Matrix a2) {
        CovarianceSelectionProblem a3;
        double a4 = Math.log(MatrixMeasure.det(a2));
        double a5 = MatrixMeasure.tr(a3.if.multiply(a2));
        double a6 = a4 - a5;
        return a6;
    }

    public CovarianceSelectionProblem(CovarianceSelectionProblem that) {
        this.if = that.if;
        this.new = that.new;
    }

    public double penalizedL1(Matrix X) {
        double a2 = this.final(X);
        double a3 = 0.0;
        for (int a4 = 1; a4 <= X.nRows(); ++a4) {
            for (int a5 = 1; a5 <= X.nCols(); ++a5) {
                a3 += Math.abs(X.get(a4, a5));
            }
        }
        double a6 = a2 - this.new * a3;
        return a6;
    }

    public CovarianceSelectionProblem(MultivariateTimeSeries ts, double t, boolean isCor) {
        this(isCor ? new CorrelationMatrix(ts.toMatrix()) : new SampleCovariance(ts.toMatrix()), t);
    }

    public double penalizedCardinality(Matrix X) {
        double a2 = this.final(X);
        double a3 = 0.0;
        for (int a4 = 1; a4 <= X.nRows(); ++a4) {
            for (int a5 = 1; a5 <= X.nCols(); ++a5) {
                a3 += X.get(a4, a5) != 0.0 ? 1.0 : 0.0;
            }
        }
        double a6 = a2 - this.new * a3;
        return a6;
    }
}

