/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.univariate.bracketsearch;

import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.misc.Constants;
import dev.nm.solver.problem.C2OptimProblem;
import dev.nm.solver.univariate.bracketsearch.BracketSearchMinimizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GoldenMinimizer
extends BracketSearchMinimizer {
    private final double new = 1.0 - 1.0 / Constants.GOLDEN_RATIO;

    @Override
    public Solution solve(C2OptimProblem problem) {
        return new Solution((UnivariateRealFunction)problem.f());
    }

    public GoldenMinimizer(double epsilon, int maxIterations) {
        super(epsilon, maxIterations);
    }

    public class Solution
    extends BracketSearchMinimizer.Solution {
        @Override
        protected boolean isMinFound() {
            return this.xu - this.xl < GoldenMinimizer.this.epsilon;
        }

        @Override
        public double search(double lower, double upper) {
            double a2 = lower + GoldenMinimizer.this.new * (upper - lower);
            return super.search(lower, a2, upper);
        }

        @Override
        protected double xnext() {
            double a2 = this.xu - this.xmin;
            double a3 = this.xmin - this.xl;
            double a4 = this.xmin;
            return a4 += GoldenMinimizer.this.new * (a2 > a3 ? a2 : -a3);
        }

        private Solution(UnivariateRealFunction a3) {
            Solution a4;
            super(a3);
        }
    }
}

