/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.constraint.linear;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.constraint.GreaterThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.BoxConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearEqualityConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearLessThanConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.problem.LPProblemImpl1;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.simplex.solution.LPSimplexMinimizer;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.simplex.solution.LPSimplexSolution;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.simplex.solver.LPTwoPhaseSolver;

public class LinearGreaterThanConstraints
extends LinearConstraints
implements GreaterThanConstraints {
    public Vector getFeasibleInitialPoint(LinearEqualityConstraints equal) {
        Object a2;
        int a3 = this.dimension();
        ArgumentAssertion.assertTrue(equal == null || a3 == equal.dimension(), "the domains (variables) of both inequality and equality constraints must match", new Object[0]);
        DenseVector a4 = new DenseVector(a3 + 1);
        a4.set(a3 + 1, 1.0);
        DenseMatrix a5 = new DenseMatrix(DoubleUtils.rep(1.0, this.size()), this.size(), 1);
        Matrix a6 = MatrixFactory.cbind(this.A(), a5);
        LinearGreaterThanConstraints a7 = new LinearGreaterThanConstraints(a6, this.b());
        LinearEqualityConstraints a8 = null;
        if (equal != null) {
            a2 = MatrixFactory.cbind(equal.A(), new DenseMatrix(equal.A().nRows(), 1));
            a8 = new LinearEqualityConstraints((Matrix)a2, equal.b());
        }
        a2 = new BoxConstraints.Bound[a3];
        for (int a9 = 0; a9 < a3; ++a9) {
            a2[a9] = new BoxConstraints.Bound(a9 + 1, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        BoxConstraints a10 = new BoxConstraints(a3, (BoxConstraints.Bound)a2);
        LPProblemImpl1 a11 = new LPProblemImpl1(a4, a7, null, a8, a10);
        LPTwoPhaseSolver a12 = new LPTwoPhaseSolver();
        try {
            LPSimplexSolution a13 = (LPSimplexSolution)a12.solve(a11);
            return (Vector)((LPSimplexMinimizer)a13.minimizer()).minimizer();
        }
        catch (Exception a14) {
            throw new RuntimeException("LP problem not setup properly; there is no feasible initial");
        }
    }

    public LinearGreaterThanConstraints(Matrix A2, Vector b2) {
        super(A2, b2);
    }

    public Vector getFeasibleInitialPoint() {
        return this.getFeasibleInitialPoint(null);
    }

    @Override
    public LinearLessThanConstraints toLessThanConstraints() {
        return new LinearLessThanConstraints(this.A().scaled(-1.0), this.b().scaled(-1.0));
    }
}

